/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities.minigames;

import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntityCasino;
import mod.shared.util.Vector2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityMemory
extends TileEntityCasino {
    public boolean selected_A;
    public boolean selected_B;
    public Vector2 selected_A_pos;
    public Vector2 selected_B_pos;
    public int timer;

    public TileEntityMemory() {
        super(null, null);
    }

    public TileEntityMemory(TileEntityBoard te, BlockPos bp) {
        super(te, bp);
        this.gridI = new int[17][9];
    }

    public String func_174875_k() {
        return CasinoKeeper.GUIID_MEMORY.toString();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCasino(playerInventory, this.board);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_MEMORY.toString(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_MEMORY.toString(), new Object[0]);
    }

    @Override
    public void start2() {
        this.scoreLevel = 1;
        this.scoreLives = 8;
        this.selected_A = false;
        this.selected_B = false;
        this.timer = 0;
        this.selected_A_pos = new Vector2(-1, -1);
        this.selected_B_pos = new Vector2(-1, -1);
        this.Command_Create_Grid();
    }

    public void restart() {
        this.turnstate = 2;
        ++this.scoreLevel;
        this.scoreLives += this.scoreLevel * 2;
        this.selected_A = false;
        this.selected_B = false;
        this.timer = 0;
        this.selected_A_pos = new Vector2(-1, -1);
        this.selected_B_pos = new Vector2(-1, -1);
        this.Command_Create_Grid();
    }

    @Override
    public void actionTouch(int action) {
        if (action == -1) {
            this.restart();
        } else if (action == -2) {
            this.turnstate = 4;
        } else {
            this.Click_Mino(action % 17, action / 17);
        }
    }

    @Override
    public void update() {
        if (this.timer > 0) {
            this.timer -= 10;
            if (this.timer <= 0) {
                if (this.gridI[this.selected_A_pos.X][this.selected_A_pos.Y] == this.gridI[this.selected_B_pos.X][this.selected_B_pos.Y]) {
                    this.gridI[this.selected_A_pos.X][this.selected_A_pos.Y] = -1;
                    this.gridI[this.selected_B_pos.X][this.selected_B_pos.Y] = -1;
                } else {
                    --this.scoreLives;
                }
                boolean temp = false;
                for (int x = 0; x < 17; ++x) {
                    for (int y = 0; y < 9; ++y) {
                        if (this.gridI[x][y] == -1) continue;
                        temp = true;
                    }
                }
                if (!temp) {
                    this.turnstate = 3;
                    this.scorePoints += this.scoreLevel * 4;
                } else if (this.scoreLives <= 0) {
                    this.turnstate = 4;
                    this.scorePoints /= 2;
                }
                this.selected_A = false;
                this.selected_B = false;
                this.selected_A_pos = new Vector2(-1, -1);
                this.selected_B_pos = new Vector2(-1, -1);
            }
        }
    }

    @Override
    public int getValue(int index) {
        if (index == -1) {
            return this.timer;
        }
        if (index == 200) {
            return this.selected_A_pos.X;
        }
        if (index == 201) {
            return this.selected_A_pos.Y;
        }
        if (index == 202) {
            return this.selected_B_pos.X;
        }
        if (index == 203) {
            return this.selected_B_pos.Y;
        }
        return this.gridI[index % 17][index / 17];
    }

    public void Click_Mino(int x, int y) {
        if (!this.selected_A) {
            if (this.gridI[x][y] != -1) {
                this.selected_A = true;
                this.selected_A_pos = new Vector2(x, y);
            }
        } else if (!this.selected_B && this.gridI[x][y] != -1 && !this.selected_A_pos.matches(x, y)) {
            this.selected_B = true;
            this.selected_B_pos = new Vector2(x, y);
            this.timer = 400 - this.scoreLevel * 10;
        }
    }

    private void Command_Create_Grid() {
        int filler;
        for (int x = 0; x < 17; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.gridI[x][y] = -1;
            }
        }
        int max = this.difficulty == 2 ? 80 : 152;
        int filler2 = filler = this.scoreLevel * 4 < max ? this.scoreLevel * 4 : max;
        int[] color = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        while (filler > 0) {
            int z;
            int n = z = this.rand.nextInt(8);
            color[n] = color[n] + 2;
            filler -= 2;
        }
        block3: while (filler2 > 0) {
            int y;
            int x = this.rand.nextInt(this.difficulty == 2 ? 9 : 17) + (this.difficulty == 2 ? 4 : 0);
            if (this.gridI[x][y = this.rand.nextInt(9)] != -1) continue;
            for (int i = 0; i < 8; ++i) {
                if (color[i] <= 0) continue;
                this.gridI[x][y] = i;
                int n = i;
                color[n] = color[n] - 1;
                --filler2;
                continue block3;
            }
        }
    }
}

