/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities.minigames;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntityCasino;
import mod.shared.util.Vector2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityMinesweeper
extends TileEntityCasino {
    List<Vector2> FieldList = new ArrayList<Vector2>();
    boolean[][] grid_flag = new boolean[30][14];
    int bombs;

    public TileEntityMinesweeper() {
        super(null, null);
    }

    public TileEntityMinesweeper(TileEntityBoard te, BlockPos bp) {
        super(te, bp);
        this.gridI = new int[26][14];
        this.gridB = new boolean[26][14];
    }

    public String func_174875_k() {
        return CasinoKeeper.GUIID_MINESWEEPER.toString();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCasino(playerInventory, this.board);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_MINESWEEPER.toString(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_MINESWEEPER.toString(), new Object[0]);
    }

    @Override
    public void start2() {
        this.bombs = 0;
        this.selector = new Vector2(5, 5);
        this.FieldList.clear();
        this.scoreLevel = 1;
        this.Create_Field();
    }

    public void Restart() {
        this.turnstate = 2;
        this.FieldList.clear();
        ++this.scoreLevel;
        this.Create_Field();
    }

    @Override
    public void actionTouch(int action) {
        if (action == -1) {
            this.Restart();
        } else if (action == -2) {
            this.turnstate = 4;
        } else {
            this.selector = new Vector2(action % 26, action / 26);
            this.Command_Grid_Enter();
        }
    }

    @Override
    public void update() {
    }

    @Override
    public int getValue(int index) {
        return this.gridI[index % 26][index / 26];
    }

    @Override
    public boolean getFlag(int index) {
        return this.gridB[index % 26][index / 26];
    }

    private void Create_Field() {
        int y;
        int x;
        for (int i = 0; i < 14; ++i) {
            for (int j = 0; j < 26; ++j) {
                this.gridI[j][i] = 0;
                this.gridB[j][i] = false;
                this.grid_flag[j][i] = false;
            }
        }
        this.bombs = this.scoreLevel * this.difficulty;
        int max = this.difficulty == 2 ? 196 : 364;
        if (this.bombs > (max -= max / 4)) {
            this.bombs = max;
        }
        for (int i = 0; i < this.bombs; ++i) {
            int y2;
            x = this.rand.nextInt(this.difficulty == 2 ? 14 : 26) + (this.difficulty == 2 ? 6 : 0);
            if (this.gridI[x][y2 = this.rand.nextInt(14)] != 9) {
                this.gridI[x][y2] = 9;
                continue;
            }
            --i;
        }
        for (y = 0; y < 14; ++y) {
            for (x = this.difficulty == 2 ? 6 : 0; x < (this.difficulty == 2 ? 20 : 26); ++x) {
                this.gridB[x][y] = true;
                if (this.gridI[x][y] == 9) continue;
                int count = 0;
                if (x > 0 && y > 0 && this.gridI[x - 1][y - 1] == 9) {
                    ++count;
                }
                if (y > 0 && this.gridI[x][y - 1] == 9) {
                    ++count;
                }
                if (x < 25 && y > 0 && this.gridI[x + 1][y - 1] == 9) {
                    ++count;
                }
                if (x < 25 && this.gridI[x + 1][y] == 9) {
                    ++count;
                }
                if (x < 25 && y < 13 && this.gridI[x + 1][y + 1] == 9) {
                    ++count;
                }
                if (y < 13 && this.gridI[x][y + 1] == 9) {
                    ++count;
                }
                if (x > 0 && y < 13 && this.gridI[x - 1][y + 1] == 9) {
                    ++count;
                }
                if (x <= 0 || this.gridI[x - 1][y] == 9) {
                    // empty if block
                }
                this.gridI[x][y] = ++count;
            }
        }
        if (this.difficulty == 2) {
            for (y = 0; y < 6; ++y) {
                for (x = 0; x < 6; ++x) {
                }
            }
        }
    }

    private void Command_Grid_Enter() {
        if (this.gridB[this.selector.X][this.selector.Y]) {
            this.gridB[this.selector.X][this.selector.Y] = false;
            if (this.gridI[this.selector.X][this.selector.Y] == 9) {
                this.gridI[this.selector.X][this.selector.Y] = 10;
                this.Uncover_Bombs();
                this.turnstate = 4;
                this.scorePoints /= 2;
            } else {
                if (this.gridI[this.selector.X][this.selector.Y] == 0) {
                    this.FieldList.add(this.selector);
                    this.Uncover_Tiles();
                }
                boolean temp = false;
                for (int i = 0; i < 14; ++i) {
                    for (int j = 0; j < 26; ++j) {
                        if (this.gridI[j][i] == 9 || !this.gridB[j][i]) continue;
                        temp = true;
                    }
                }
                if (!temp) {
                    this.turnstate = 3;
                    this.scorePoints += this.bombs;
                }
            }
        }
    }

    private void Uncover_Tiles() {
        while (this.FieldList.size() > 0) {
            boolean temp0 = false;
            Iterator<Vector2> iterator = this.FieldList.iterator();
            if (iterator.hasNext()) {
                boolean temp;
                Vector2 v = iterator.next();
                if (v.X > 0 && v.Y > 0 && this.gridB[v.X - 1][v.Y - 1] && !this.grid_flag[v.X - 1][v.Y - 1]) {
                    this.gridB[v.X - 1][v.Y - 1] = false;
                    if (this.gridI[v.X - 1][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.Y > 0 && this.gridB[v.X][v.Y - 1] && !this.grid_flag[v.X][v.Y - 1]) {
                    this.gridB[v.X][v.Y - 1] = false;
                    if (this.gridI[v.X][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && v.Y > 0 && this.gridB[v.X + 1][v.Y - 1] && !this.grid_flag[v.X + 1][v.Y - 1]) {
                    this.gridB[v.X + 1][v.Y - 1] = false;
                    if (this.gridI[v.X + 1][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && this.gridB[v.X + 1][v.Y] && !this.grid_flag[v.X + 1][v.Y]) {
                    this.gridB[v.X + 1][v.Y] = false;
                    if (this.gridI[v.X + 1][v.Y] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && v.Y < 13 && this.gridB[v.X + 1][v.Y + 1] && !this.grid_flag[v.X + 1][v.Y + 1]) {
                    this.gridB[v.X + 1][v.Y + 1] = false;
                    if (this.gridI[v.X + 1][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.Y < 13 && this.gridB[v.X][v.Y + 1] && !this.grid_flag[v.X][v.Y + 1]) {
                    this.gridB[v.X][v.Y + 1] = false;
                    if (this.gridI[v.X][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X > 0 && v.Y < 13 && this.gridB[v.X - 1][v.Y + 1] && !this.grid_flag[v.X - 1][v.Y + 1]) {
                    this.gridB[v.X - 1][v.Y + 1] = false;
                    if (this.gridI[v.X - 1][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X > 0 && this.gridB[v.X - 1][v.Y] && !this.grid_flag[v.X - 1][v.Y]) {
                    this.gridB[v.X - 1][v.Y] = false;
                    if (this.gridI[v.X - 1][v.Y] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y));
                            temp0 = true;
                            break;
                        }
                    }
                }
            }
            if (temp0) continue;
            this.FieldList.remove(0);
        }
    }

    private void Uncover_Bombs() {
        for (int y = 0; y < 14; ++y) {
            for (int x = 0; x < 26; ++x) {
                if (this.gridI[x][y] != 9) continue;
                this.gridB[x][y] = false;
            }
        }
    }
}

