/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities.minigames;

import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntityCasino;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntitySlotMachine
extends TileEntityCasino {
    int slotID = -1;
    int multiplier;
    int wheel;
    int[] wheelPos = new int[3];
    int[] wheelSpeed = new int[3];
    float[] lines = new float[5];

    public TileEntitySlotMachine() {
        super(null, null);
    }

    public TileEntitySlotMachine(TileEntityBoard te, BlockPos bp) {
        super(te, bp);
        this.gridI = new int[9][3];
    }

    public String func_174875_k() {
        return CasinoKeeper.GUIID_ARCADE.toString();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCasino(playerInventory, this.board);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_ARCADE.toString(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_ARCADE.toString(), new Object[0]);
    }

    @Override
    public void start2() {
        this.slotID = this.slotID == -1 ? this.rand.nextInt(6) : (this.slotID + 1) % 6;
        this.Fill_Grid();
        this.wheelPos[0] = this.rand.nextInt(9) * 100;
        this.wheelPos[1] = this.rand.nextInt(9) * 100;
        this.wheelPos[2] = this.rand.nextInt(9) * 100;
        this.wheelSpeed[0] = 1 + this.rand.nextInt(5);
        this.wheelSpeed[1] = 1 + this.rand.nextInt(5);
        this.wheelSpeed[2] = 1 + this.rand.nextInt(5);
        this.multiplier = 1;
        this.wheel = 0;
        this.lines[0] = 0.0f;
        this.lines[1] = 0.0f;
        this.lines[2] = 0.0f;
        this.lines[3] = 0.0f;
        this.lines[4] = 0.0f;
    }

    @Override
    public void actionTouch(int action) {
        if (action == -1) {
            if (this.turnstate == 2) {
                this.turnstate = 3;
            } else if (this.turnstate == 3) {
                this.Spin();
            }
        }
    }

    @Override
    public void update() {
        if (this.turnstate == 3) {
            for (int i = 0; i < 3; ++i) {
                if (this.wheel <= i) {
                    this.wheelPos[i] = (this.wheelPos[i] + this.wheelSpeed[i]) % 900;
                    continue;
                }
                if (this.wheelSpeed[i] == 0) continue;
                if (this.wheelPos[i] % 100 >= 35 && this.wheelPos[i] % 100 <= 65) {
                    this.wheelPos[i] = this.wheelPos[i] / 100 * 100 + 50;
                    this.wheelSpeed[i] = 0;
                    continue;
                }
                this.wheelPos[i] = (this.wheelPos[i] + this.wheelSpeed[i] / 2) % 900;
            }
        }
        if (this.turnstate == 3 && this.wheelSpeed[2] == 0) {
            this.Result();
        }
        if (this.turnstate == 4) {
            // empty if block
        }
    }

    @Override
    public int getValue(int index) {
        if (index == -1) {
            return this.wheelPos[0];
        }
        if (index == -2) {
            return this.wheelPos[1];
        }
        if (index == -3) {
            return this.wheelPos[2];
        }
        return this.gridI[index % 9][index / 9];
    }

    private void Fill_Grid() {
        for (int y = 0; y < 3; ++y) {
            int[] gridtemp = this.Get_Grid((this.slotID + y) % 9);
            for (int x = 0; x < 9; ++x) {
                this.gridI[x][y] = gridtemp[x];
            }
        }
    }

    private int[] Get_Grid(int id) {
        switch (id) {
            case 0: {
                return new int[]{1, 0, 5, 4, 3, 2, 0, 5, 4};
            }
            case 1: {
                return new int[]{1, 2, 0, 5, 4, 3, 2, 0, 5};
            }
            case 2: {
                return new int[]{1, 3, 2, 0, 5, 4, 3, 2, 0};
            }
            case 3: {
                return new int[]{1, 4, 3, 2, 0, 5, 4, 3, 2};
            }
            case 4: {
                return new int[]{1, 5, 4, 3, 2, 0, 5, 4, 3};
            }
            case 5: {
                return new int[]{1, 0, 5, 4, 3, 2, 0, 5, 4};
            }
            case 6: {
                return new int[]{1, 2, 0, 5, 4, 3, 2, 0, 5};
            }
            case 7: {
                return new int[]{1, 3, 2, 0, 5, 4, 3, 2, 0};
            }
            case 8: {
                return new int[]{1, 4, 3, 2, 0, 5, 4, 3, 2};
            }
            case 9: {
                return new int[]{1, 5, 4, 3, 2, 0, 5, 4, 3};
            }
        }
        return null;
    }

    private void Spin() {
        if (this.wheel < 3) {
            ++this.wheel;
        }
    }

    private void Result() {
        this.turnstate = 4;
    }
}

