/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities.minigames;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntityCasino;
import mod.casinocraft.util.Entity;
import mod.shared.util.Vector2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntitySnake
extends TileEntityCasino {
    Entity octanom_head;
    List<Entity> octanom_tail = new ArrayList<Entity>();
    int temp_player;
    int temp_auto;
    int pointer;
    Vector2 point;
    boolean active_move_tail;

    public TileEntitySnake() {
        super(null, null);
    }

    public TileEntitySnake(TileEntityBoard te, BlockPos bp) {
        super(te, bp);
    }

    public String func_174875_k() {
        return CasinoKeeper.GUIID_SNAKE.toString();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCasino(playerInventory, this.board);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_SNAKE.toString(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_SNAKE.toString(), new Object[0]);
    }

    @Override
    public void start2() {
        this.active_move_tail = true;
        this.pointer = -1;
        this.temp_player = 0;
        this.temp_auto = 0;
        this.octanom_head = new Entity(1, new Vector2(0, 0), new Vector2(0, 0));
        this.point = new Vector2(-1, -1);
        this.Command_Spawn_Point();
        this.octanom_tail.clear();
    }

    @Override
    public void actionTouch(int action) {
        this.temp_player = action;
    }

    @Override
    public void update() {
        if (this.turnstate >= 2 && this.turnstate < 4) {
            this.octanom_head.Update();
            if (this.active_move_tail) {
                for (Entity tail : this.octanom_tail) {
                    tail.Update();
                }
            }
            this.Command_Move();
            this.Command_Collision();
        }
    }

    @Override
    public Vector2 getVector(int index) {
        return this.point;
    }

    @Override
    public Entity getEntity(int index) {
        return this.octanom_head;
    }

    @Override
    public List<Entity> getEntityList(int index) {
        return this.octanom_tail;
    }

    private void Command_Move() {
        if (this.octanom_head.Get_Pos().matches(this.octanom_head.Get_Next())) {
            Vector2 position = new Vector2(this.octanom_head.Get_Pos());
            if (this.temp_player == 1 && this.octanom_head.Get_Next().Y != 0) {
                this.octanom_head.Set_InMotion(0, -this.Speed());
                this.temp_auto = this.temp_player;
                this.temp_player = 0;
            } else if (this.temp_player == 1 && this.octanom_head.Get_Next().Y == 0) {
                this.octanom_head.Set_InMotion(0, 0);
                this.temp_auto = 0;
                this.temp_player = 0;
            } else if (this.temp_player == 2 && this.octanom_head.Get_Next().Y != 240) {
                this.octanom_head.Set_InMotion(0, this.Speed());
                this.temp_auto = this.temp_player;
                this.temp_player = 0;
            } else if (this.temp_player == 2 && this.octanom_head.Get_Next().Y == 240) {
                this.octanom_head.Set_InMotion(0, 0);
                this.temp_auto = 0;
                this.temp_player = 0;
            } else if (this.temp_player == 3 && this.octanom_head.Get_Next().X != 0) {
                this.octanom_head.Set_InMotion(-this.Speed(), 0);
                this.temp_auto = this.temp_player;
                this.temp_player = 0;
            } else if (this.temp_player == 3 && this.octanom_head.Get_Next().X == 0) {
                this.octanom_head.Set_InMotion(0, 0);
                this.temp_auto = 0;
                this.temp_player = 0;
            } else if (this.temp_player == 4 && this.octanom_head.Get_Next().X != 208) {
                this.octanom_head.Set_InMotion(this.Speed(), 0);
                this.temp_auto = this.temp_player;
                this.temp_player = 0;
            } else if (this.temp_player == 4 && this.octanom_head.Get_Next().X == 208) {
                this.octanom_head.Set_InMotion(0, 0);
                this.temp_auto = 0;
                this.temp_player = 0;
            } else if (this.temp_auto == 1 && this.octanom_head.Get_Next().Y != 0) {
                this.octanom_head.Set_InMotion(0, -this.Speed());
            } else if (this.temp_auto == 1 && this.octanom_head.Get_Next().Y == 0) {
                this.octanom_head.Set_InMotion(0, 0);
                this.temp_auto = 0;
            } else if (this.temp_auto == 2 && this.octanom_head.Get_Next().Y != 240) {
                this.octanom_head.Set_InMotion(0, this.Speed());
            } else if (this.temp_auto == 2 && this.octanom_head.Get_Next().Y == 240) {
                this.octanom_head.Set_InMotion(0, 0);
                this.temp_auto = 0;
            } else if (this.temp_auto == 3 && this.octanom_head.Get_Next().X != 0) {
                this.octanom_head.Set_InMotion(-this.Speed(), 0);
            } else if (this.temp_auto == 3 && this.octanom_head.Get_Next().X == 0) {
                this.octanom_head.Set_InMotion(0, 0);
                this.temp_auto = 0;
            } else if (this.temp_auto == 4 && this.octanom_head.Get_Next().X != 208) {
                this.octanom_head.Set_InMotion(this.Speed(), 0);
            } else if (this.temp_auto == 4 && this.octanom_head.Get_Next().X == 208) {
                this.octanom_head.Set_InMotion(0, 0);
                this.temp_auto = 0;
            }
            for (Entity tail : this.octanom_tail) {
                if (position.X > tail.Get_Pos().X) {
                    tail.Set_Pos(position.X - 16, position.Y);
                    tail.Set_Vel(this.Speed(), 0);
                } else if (position.X < tail.Get_Pos().X) {
                    tail.Set_Pos(position.X + 16, position.Y);
                    tail.Set_Vel(-this.Speed(), 0);
                } else if (position.Y > tail.Get_Pos().Y) {
                    tail.Set_Pos(position.X, position.Y - 16);
                    tail.Set_Vel(0, this.Speed());
                } else if (position.Y < tail.Get_Pos().Y) {
                    tail.Set_Pos(position.X, position.Y + 16);
                    tail.Set_Vel(0, -this.Speed());
                }
                position.set(tail.Get_Pos());
            }
            this.active_move_tail = !this.octanom_head.Get_Vel().matches(0, 0);
        }
    }

    private void Command_Collision() {
        for (int i = 0; i < 5; ++i) {
            if (!this.octanom_head.Get_Pos().matches(this.point.X * 16, this.point.Y * 16)) continue;
            this.scorePoints += 1 * this.difficulty;
            this.pointer = i;
            this.Command_Spawn_Point();
            this.Command_Spawn_Tail();
        }
        if (this.octanom_tail.size() > 1) {
            for (Entity tail : this.octanom_tail) {
                if (!this.octanom_head.Get_Pos().matches(tail.Get_Pos())) continue;
                this.turnstate = 4;
            }
        }
    }

    private int Speed() {
        return 2;
    }

    private void Command_Spawn_Point() {
        boolean temp_break = false;
        int x = 0;
        int y = 0;
        for (int i = 0; i < 1; ++i) {
            if (this.pointer != i && (this.pointer != -1 || i >= 1)) continue;
            int b = 0;
            temp_break = false;
            while (!temp_break) {
                boolean temp_internal = false;
                x = this.rand.nextInt(12) + 1;
                y = this.rand.nextInt(12) + 1;
                if (++b < 10) {
                    if (this.octanom_head.Get_Next() != new Vector2(x, y)) {
                        for (Entity tail : this.octanom_tail) {
                            if (!tail.Get_Grid().matches(x, y)) continue;
                            temp_internal = true;
                            break;
                        }
                        if (this.point.matches(x, y)) {
                            temp_internal = true;
                        }
                        if (!temp_internal) {
                            temp_break = true;
                        }
                    }
                } else if (this.octanom_head.Get_Next() != new Vector2(x, y)) {
                    temp_break = true;
                }
                this.point = new Vector2(x, y);
            }
        }
    }

    private void Command_Spawn_Tail() {
        Vector2 pos = new Vector2(this.octanom_head.Get_Pos());
        int i = 0;
        for (Entity tail : this.octanom_tail) {
            if (i + 1 == this.octanom_tail.size()) {
                pos.set(tail.Get_Pos());
            }
            ++i;
        }
        this.octanom_tail.add(new Entity(0, pos, pos));
    }
}

