/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities.minigames;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntityCasino;
import mod.casinocraft.util.Entity;
import mod.casinocraft.util.MapRoom;
import mod.shared.util.Vector2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntitySokoban
extends TileEntityCasino {
    MapRoom MP = new MapRoom();
    Entity octanom;
    List<Entity> crate = new ArrayList<Entity>();
    List<Entity> cross = new ArrayList<Entity>();
    boolean moving;

    public TileEntitySokoban() {
        super(null, null);
    }

    public TileEntitySokoban(TileEntityBoard te, BlockPos bp) {
        super(te, bp);
        this.gridI = new int[16][12];
        this.gridB = new boolean[16][12];
    }

    public String func_174875_k() {
        return CasinoKeeper.GUIID_SOKOBAN.toString();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCasino(playerInventory, this.board);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_SOKOBAN.toString(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_SOKOBAN.toString(), new Object[0]);
    }

    @Override
    public void start2() {
        this.gridB = new boolean[16][12];
        this.gridI = new int[16][12];
        this.octanom = new Entity(1, new Vector2(240, 240), new Vector2(240, 240));
        this.crate.clear();
        this.cross.clear();
        this.Load_Map();
    }

    @Override
    public void actionTouch(int action) {
        this.Command_Move(action);
    }

    @Override
    public void update() {
        if (this.moving) {
            boolean swittch = true;
            for (Entity c : this.crate) {
                if (c.Get_Pos().X == c.Get_Next().X * 16 && c.Get_Pos().Y == c.Get_Next().Y * 16) {
                    c.Set_InMotion(0, 0);
                    continue;
                }
                swittch = false;
            }
            if (swittch) {
                this.moving = false;
            }
        }
        if (this.turnstate >= 2 && this.turnstate < 4) {
            this.octanom.Update();
            boolean win = true;
            for (Entity e : this.crate) {
                e.Update();
                boolean hp1 = true;
                for (Entity c : this.cross) {
                    if (!c.Get_Pos().matches(e.Get_Pos())) continue;
                    hp1 = false;
                }
                if (hp1) {
                    e.Set_HP(1);
                    win = false;
                    continue;
                }
                e.Set_HP(2);
            }
            for (Entity e : this.cross) {
                e.Update();
            }
            if (win && this.turnstate < 4) {
                this.scorePoints = this.crate.size() * 500;
                this.turnstate = 4;
            }
        }
    }

    @Override
    public Entity getEntity(int index) {
        return this.octanom;
    }

    @Override
    public List<Entity> getEntityList(int index) {
        if (index == 0) {
            return this.crate;
        }
        return this.cross;
    }

    @Override
    public int getValue(int index) {
        return this.gridI[index % 16][index / 16];
    }

    @Override
    public boolean getFlag(int index) {
        return this.gridB[index % 16][index / 16];
    }

    @Override
    public String getString(int index) {
        return "";
    }

    private void Load_Map() {
        List<String> list = this.MP.LoadSokoban(this.rand);
        int y = 0;
        for (String s : list) {
            block8: for (int x = 0; x < 16; ++x) {
                char c = s.charAt(x);
                if (c != ' ') {
                    this.gridI[x][y] = this.ConvertGrid(x, y);
                }
                switch (c) {
                    case ' ': {
                        continue block8;
                    }
                    case 'X': {
                        this.gridB[x][y] = true;
                        continue block8;
                    }
                    case 'O': {
                        this.octanom = new Entity(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y));
                        continue block8;
                    }
                    case 'M': {
                        this.cross.add(new Entity(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y)));
                        continue block8;
                    }
                    case 'C': {
                        this.crate.add(new Entity(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y)));
                    }
                }
            }
            ++y;
        }
    }

    private int ConvertGrid(int x, int y) {
        if (y % 2 == 0 && x % 2 == 0) {
            return 1;
        }
        if (y % 2 == 0 && x % 2 != 0) {
            return 2;
        }
        if (y % 2 != 0 && x % 2 == 0) {
            return 2;
        }
        if (y % 2 != 0 && x % 2 != 0) {
            return 1;
        }
        return 0;
    }

    private void Command_Move(int direction) {
        if (!this.octanom.isMoving()) {
            int x = 0;
            int y = 0;
            if (direction == 0) {
                x = 0;
                y = -1;
            }
            if (direction == 1) {
                x = 0;
                y = 1;
            }
            if (direction == 2) {
                x = -1;
                y = 0;
            }
            if (direction == 3) {
                x = 1;
                y = 0;
            }
            if (!this.gridB[this.octanom.Get_Grid().X + x][this.octanom.Get_Grid().Y + y]) {
                boolean blockedO = false;
                for (Entity c : this.crate) {
                    if (c.Get_Grid().X != this.octanom.Get_Grid().X + x || c.Get_Grid().Y != this.octanom.Get_Grid().Y + y) continue;
                    blockedO = true;
                    if (this.gridB[this.octanom.Get_Grid().X + x * 2][this.octanom.Get_Grid().Y + y * 2]) continue;
                    boolean blockedC = false;
                    for (Entity c2 : this.crate) {
                        if (c.Get_Grid().X != this.octanom.Get_Grid().X + x * 2 || c.Get_Grid().Y != this.octanom.Get_Grid().Y + y * 2) continue;
                        blockedC = true;
                    }
                    if (blockedC) continue;
                    this.moving = true;
                    c.Set_InMotion(x * 2, y * 2);
                }
                if (!blockedO) {
                    this.octanom.Set_InMotion(x * 2, y * 2);
                }
            }
        }
    }
}

