/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.tileentities.minigames;

import javax.annotation.Nullable;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.tileentities.TileEntityCasino;
import mod.casinocraft.util.Card;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityVideoPoker
extends TileEntityCasino {
    public boolean end;
    public Card[] card = new Card[5];
    public boolean[] hold = new boolean[5];
    private int ticker;
    private int movestate;

    public TileEntityVideoPoker() {
        super(null, null);
    }

    public TileEntityVideoPoker(TileEntityBoard te, BlockPos bp) {
        super(te, bp);
    }

    public String func_174875_k() {
        return CasinoKeeper.GUIID_VIDEOPOKER.toString();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerCasino(playerInventory, this.board);
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_VIDEOPOKER.toString(), new Object[0]);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TextComponentTranslation(CasinoKeeper.GUIID_VIDEOPOKER.toString(), new Object[0]);
    }

    @Override
    public void start2() {
        for (int i = 0; i < 5; ++i) {
            this.card[i] = new Card(this.rand.nextInt(13), this.rand.nextInt(4), 0, 20 + 5 * i);
            this.hold[i] = false;
        }
        this.end = false;
        this.ticker = 0;
        this.movestate = 0;
    }

    @Override
    public void actionTouch(int action) {
        if (action == 5 && this.turnstate == 2) {
            this.turnstate = 3;
            this.movestate = 1;
            for (int i = 0; i < 5; ++i) {
                if (this.hold[i]) continue;
                this.card[i].hidden = true;
            }
        } else {
            this.hold[action] = !this.hold[action];
        }
    }

    @Override
    public void update() {
        int i;
        if (this.turnstate == 2) {
            for (i = 0; i < 5; ++i) {
                this.card[i].update();
            }
        }
        switch (this.movestate) {
            case 0: {
                break;
            }
            case 1: {
                ++this.ticker;
                for (i = 0; i < 5; ++i) {
                    if (this.hold[i]) continue;
                    --this.card[i].shiftY;
                }
                if (this.ticker < 30) break;
                if (!this.hold[0]) {
                    this.card[0].number = this.rand.nextInt(13);
                    this.card[0].suit = this.rand.nextInt(4);
                    this.card[0].hidden = false;
                }
                if (!this.hold[1]) {
                    this.card[1].number = this.rand.nextInt(13);
                    this.card[1].suit = this.rand.nextInt(4);
                    this.card[1].hidden = false;
                }
                if (!this.hold[2]) {
                    this.card[2].number = this.rand.nextInt(13);
                    this.card[2].suit = this.rand.nextInt(4);
                    this.card[2].hidden = false;
                }
                if (!this.hold[3]) {
                    this.card[3].number = this.rand.nextInt(13);
                    this.card[3].suit = this.rand.nextInt(4);
                    this.card[3].hidden = false;
                }
                if (!this.hold[4]) {
                    this.card[4].number = this.rand.nextInt(13);
                    this.card[4].suit = this.rand.nextInt(4);
                    this.card[4].hidden = false;
                }
                this.movestate = 2;
                break;
            }
            case 2: {
                --this.ticker;
                for (i = 0; i < 5; ++i) {
                    if (this.hold[i]) continue;
                    ++this.card[i].shiftY;
                }
                if (this.ticker != 0) break;
                this.movestate = 3;
                break;
            }
            case 3: {
                ++this.ticker;
                this.card[0].shiftX += 2;
                ++this.card[1].shiftX;
                --this.card[3].shiftX;
                this.card[4].shiftX -= 2;
                if (this.ticker != 48) break;
                this.Sort();
                this.card[0].shiftX = 96;
                this.card[1].shiftX = 48;
                this.card[2].shiftX = 0;
                this.card[3].shiftX = -48;
                this.card[4].shiftX = -96;
                this.movestate = 4;
                break;
            }
            case 4: {
                --this.ticker;
                this.card[0].shiftX -= 2;
                --this.card[1].shiftX;
                ++this.card[3].shiftX;
                this.card[4].shiftX += 2;
                if (this.ticker != 0) break;
                this.Result();
                this.turnstate = 4;
                this.movestate = 0;
            }
        }
    }

    @Override
    public Card getCard(int index) {
        return this.card[index];
    }

    @Override
    public boolean getFlag(int index) {
        return this.hold[index];
    }

    @Override
    public String getString(int index) {
        return this.hand;
    }

    public void Click_Hold(int i) {
        this.hold[i] = !this.hold[i];
    }

    private void Sort() {
        Card z;
        if (this.card[0].number > this.card[4].number) {
            z = this.card[0];
            this.card[0] = this.card[1];
            this.card[1] = this.card[2];
            this.card[2] = this.card[3];
            this.card[3] = this.card[4];
            this.card[4] = z;
        }
        if (this.card[0].number > this.card[3].number) {
            z = this.card[0];
            this.card[0] = this.card[1];
            this.card[1] = this.card[2];
            this.card[2] = this.card[3];
            this.card[3] = z;
        }
        if (this.card[0].number > this.card[2].number) {
            z = this.card[0];
            this.card[0] = this.card[1];
            this.card[1] = this.card[2];
            this.card[2] = z;
        }
        if (this.card[0].number > this.card[1].number) {
            z = this.card[0];
            this.card[0] = this.card[1];
            this.card[1] = z;
        }
        if (this.card[1].number > this.card[4].number) {
            z = this.card[1];
            this.card[1] = this.card[2];
            this.card[2] = this.card[3];
            this.card[3] = this.card[4];
            this.card[4] = z;
        }
        if (this.card[1].number > this.card[3].number) {
            z = this.card[1];
            this.card[1] = this.card[2];
            this.card[2] = this.card[3];
            this.card[3] = z;
        }
        if (this.card[1].number > this.card[2].number) {
            z = this.card[1];
            this.card[1] = this.card[2];
            this.card[2] = z;
        }
        if (this.card[2].number > this.card[4].number) {
            z = this.card[2];
            this.card[2] = this.card[3];
            this.card[3] = this.card[4];
            this.card[4] = z;
        }
        if (this.card[2].number > this.card[3].number) {
            z = this.card[2];
            this.card[2] = this.card[3];
            this.card[3] = z;
        }
        if (this.card[3].number > this.card[4].number) {
            z = this.card[3];
            this.card[3] = this.card[4];
            this.card[4] = z;
        }
    }

    private void Result() {
        if (this.card[0].number == this.card[1].number && this.card[0].number == this.card[2].number && this.card[0].number == this.card[3].number && this.card[0].number == this.card[4].number) {
            this.hand = "5 of a Kind";
            this.reward = 20;
        } else if (this.card[0].number == 9 && this.card[1].number == 10 && this.card[2].number == 11 && this.card[3].number == 12 && this.card[4].number == 0 && this.card[0].suit == this.card[1].suit && this.card[0].suit == this.card[2].suit && this.card[0].suit == this.card[3].suit && this.card[0].suit == this.card[4].suit) {
            this.hand = "ROYAL FLUSH!!";
            this.reward = 16;
        } else if (this.card[0].number <= 9 && this.card[0].number + 1 == this.card[1].number && this.card[0].number + 2 == this.card[2].number && this.card[0].number + 3 == this.card[3].number && this.card[0].number + 4 == this.card[4].number && this.card[0].suit == this.card[1].suit && this.card[0].suit == this.card[2].suit && this.card[0].suit == this.card[3].suit && this.card[0].suit == this.card[4].suit) {
            this.hand = "Straight Flush";
            this.reward = 12;
        } else if (this.card[0].number == this.card[1].number && this.card[0].number == this.card[2].number && this.card[0].number == this.card[3].number && this.card[0].number != this.card[4].number) {
            this.hand = "4 of a Kind";
            this.reward = 10;
        } else if (this.card[1].number == this.card[2].number && this.card[1].number == this.card[3].number && this.card[1].number == this.card[4].number && this.card[1].number != this.card[0].number) {
            this.hand = "4 of a Kind";
            this.reward = 10;
        } else if (this.card[0].number == this.card[1].number && this.card[0].number == this.card[2].number && this.card[0].number != this.card[3].number && this.card[3].number == this.card[4].number) {
            this.hand = "Full House";
            this.reward = 8;
        } else if (this.card[0].number == this.card[1].number && this.card[0].number != this.card[2].number && this.card[2].number == this.card[3].number && this.card[2].number == this.card[4].number) {
            this.hand = "Full House";
            this.reward = 8;
        } else if (this.card[0].suit == this.card[1].suit && this.card[0].suit == this.card[2].suit && this.card[0].suit == this.card[3].suit && this.card[0].suit == this.card[4].suit) {
            this.hand = "Flush";
            this.reward = 7;
        } else if (this.card[0].number <= 9 && this.card[0].number + 1 == this.card[1].number && this.card[0].number + 2 == this.card[2].number && this.card[0].number + 3 == this.card[3].number && this.card[0].number + 4 == this.card[4].number) {
            this.hand = "Straight";
            this.reward = 6;
        } else if (this.card[0].number == this.card[1].number && this.card[0].number == this.card[2].number && this.card[0].number != this.card[3].number && this.card[0].number != this.card[4].number) {
            this.hand = "3 of a Kind";
            this.reward = 4;
        } else if (this.card[1].number == this.card[2].number && this.card[1].number == this.card[3].number && this.card[1].number != this.card[0].number && this.card[1].number != this.card[4].number) {
            this.hand = "3 of a Kind";
            this.reward = 4;
        } else if (this.card[2].number == this.card[3].number && this.card[2].number == this.card[4].number && this.card[2].number != this.card[0].number && this.card[2].number != this.card[1].number) {
            this.hand = "3 of a Kind";
            this.reward = 4;
        } else if (this.card[0].number == this.card[1].number && this.card[2].number == this.card[3].number) {
            this.hand = "Two Pair";
            this.reward = 2;
        } else if (this.card[0].number == this.card[1].number && this.card[3].number == this.card[4].number) {
            this.hand = "Two Pair";
            this.reward = 2;
        } else if (this.card[1].number == this.card[2].number && this.card[3].number == this.card[4].number) {
            this.hand = "Two Pair";
            this.reward = 2;
        } else if ((this.card[0].number >= 10 || this.card[0].number == 0) && this.card[0].number == this.card[1].number) {
            this.hand = "Jacks or Better";
            this.reward = 1;
        } else if ((this.card[1].number >= 10 || this.card[1].number == 0) && this.card[1].number == this.card[2].number) {
            this.hand = "Jacks or Better";
            this.reward = 1;
        } else if ((this.card[2].number >= 10 || this.card[2].number == 0) && this.card[2].number == this.card[3].number) {
            this.hand = "Jacks or Better";
            this.reward = 1;
        } else if ((this.card[3].number >= 10 || this.card[3].number == 0) && this.card[3].number == this.card[4].number) {
            this.hand = "Jacks or Better";
            this.reward = 1;
        }
        this.end = true;
    }
}

