/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.container;

import mod.casinocraft.container.ContainerBase;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.tileentities.TileEntityBoard;
import mod.casinocraft.util.LogicData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ContainerCasino
extends ContainerBase {
    public final IInventory inventory;
    private final World world;
    private final IIntArray casinoData;
    private final LogicData logicData;
    private BlockPos pos = new BlockPos(0, 0, 0);
    public DyeColor color;
    public int tableID;
    protected LogicBase LOGIC;

    public ContainerCasino(ContainerType<?> type, int windowID, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(type, windowID, playerInventory, BlockPos.func_218283_e((long)packetBuffer.readLong()));
    }

    public ContainerCasino(ContainerType<?> type, int windowID, PlayerInventory playerInventory, BlockPos pos) {
        this(type, windowID, playerInventory, (TileEntityBoard)playerInventory.field_70458_d.func_130014_f_().func_175625_s(pos));
        this.pos = pos;
    }

    public ContainerCasino(ContainerType<?> type, int windowID, PlayerInventory playerInventory, TileEntityBoard board) {
        super(type, windowID);
        this.inventory = board;
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.casinoData = board.casinoData;
        this.logicData = board.logicData;
        this.color = board.color;
        this.tableID = board.tableID;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    public LogicBase logic() {
        return this.logicData.get();
    }

    public int turnstate() {
        return this.logicData.get().turnstate;
    }

    public boolean hasToken() {
        return this.casinoData.func_221476_a(0) > 0;
    }

    public int getBetStorage() {
        return this.casinoData.func_221476_a(0);
    }

    public int getBetLow() {
        return this.casinoData.func_221476_a(1);
    }

    public int getBetHigh() {
        return this.casinoData.func_221476_a(2);
    }

    public boolean isCreative() {
        return this.casinoData.func_221476_a(5) == 1;
    }

    public void setBetStorage(int value) {
        this.casinoData.func_221477_a(0, value);
    }

    public World world() {
        return this.world;
    }

    public ItemStack getToken() {
        return this.inventory.func_70301_a(4);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setToken(ItemStack itemStack) {
        this.inventory.func_70299_a(4, itemStack);
    }

    public abstract int getID();

    public String getCurrentPlayer(int index) {
        TileEntityBoard te = (TileEntityBoard)this.world.func_175625_s(this.pos);
        return this.logic().currentPlayer[index];
    }
}

