/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.container;

import mod.casinocraft.container.ContainerBase;
import mod.casinocraft.tileentities.TileEntityBoard;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ContainerMachine
extends ContainerBase {
    public final IInventory inventory;
    private final World world;
    private final IIntArray casinoData;
    private BlockPos pos = new BlockPos(0, 0, 0);
    public DyeColor color;

    public ContainerMachine(ContainerType<?> type, int windowID, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(type, windowID, playerInventory, BlockPos.func_218283_e((long)packetBuffer.readLong()));
    }

    public ContainerMachine(ContainerType<?> type, int windowID, PlayerInventory playerInventory, BlockPos pos) {
        this(type, windowID, playerInventory, (TileEntityBoard)playerInventory.field_70458_d.func_130014_f_().func_175625_s(pos));
        this.pos = pos;
    }

    public ContainerMachine(ContainerType<?> type, int windowID, PlayerInventory playerInventory, TileEntityBoard board) {
        super(type, windowID);
        this.inventory = board;
        this.world = playerInventory.field_70458_d.field_70170_p;
        this.func_75146_a(new Slot((IInventory)board, 0, 8, 62));
        this.func_75146_a(new Slot((IInventory)board, 1, 152, 62));
        this.func_75146_a(new Slot((IInventory)board, 2, 28, 16));
        this.func_75146_a(new Slot((IInventory)board, 3, 132, 16));
        this.addPlayerSlots(playerInventory);
        this.casinoData = board.casinoData;
        this.color = board.color;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(itemstack1, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    public boolean hasToken() {
        return this.casinoData.func_221476_a(0) > 0;
    }

    public int getBetStorage() {
        return this.casinoData.func_221476_a(0);
    }

    public int getBetLow() {
        return this.casinoData.func_221476_a(1);
    }

    public int getBetHigh() {
        return this.casinoData.func_221476_a(2);
    }

    public boolean isCreative() {
        return this.casinoData.func_221476_a(5) == 1;
    }

    public boolean getTransferIn() {
        return this.casinoData.func_221476_a(3) == 1;
    }

    public boolean getTransferOut() {
        return this.casinoData.func_221476_a(4) == 1;
    }

    public boolean getIsCreative() {
        return this.casinoData.func_221476_a(5) == 1;
    }

    public void setBetStorage(int value) {
        this.casinoData.func_221477_a(0, value);
    }

    public void setBetLow(int value) {
        this.casinoData.func_221477_a(1, value);
    }

    public void setBetHigh(int value) {
        this.casinoData.func_221477_a(2, value);
    }

    public void addBetStorage(int value) {
        this.casinoData.func_221477_a(0, this.casinoData.func_221476_a(0) + value);
    }

    public void addBetLow(int value) {
        this.casinoData.func_221477_a(1, this.casinoData.func_221476_a(1) + value);
    }

    public void addBetHigh(int value) {
        this.casinoData.func_221477_a(2, this.casinoData.func_221476_a(2) + value);
    }

    public void setTransferIn(boolean value) {
        this.casinoData.func_221477_a(3, value ? 1 : 0);
    }

    public void setTransferOut(boolean value) {
        this.casinoData.func_221477_a(4, value ? 1 : 0);
    }

    public void setIsCreative(boolean value) {
        this.casinoData.func_221477_a(5, value ? 1 : 0);
    }

    public World world() {
        return this.world;
    }

    public ItemStack getToken() {
        return this.inventory.func_70301_a(4);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ItemStack getScoreToken() {
        return this.inventory.func_70301_a(5);
    }

    public void setToken(ItemStack itemStack) {
        this.inventory.func_70299_a(4, itemStack);
    }
}

