/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.chip;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.MapRoom;
import mod.casinocraft.util.Ship;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public class LogicChipPink
extends LogicBase {
    public Ship octanom = new Ship(1, new Vector2(240, 240), new Vector2(240, 240));
    public List<Ship> crate = new ArrayList<Ship>();
    public List<Ship> cross = new ArrayList<Ship>();
    public boolean moving;

    public LogicChipPink(int tableID) {
        super(tableID, 12, 12);
    }

    @Override
    public void start2() {
        this.crate.clear();
        this.cross.clear();
        this.loadMap();
    }

    @Override
    public void command(int action) {
        if (action == -1) {
            this.turnstate = 4;
        } else {
            this.commandMove(action);
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void updateLogic() {
        if (this.moving) {
            boolean swittch = true;
            for (Ship c : this.crate) {
                if (c.Get_Pos().X == c.Get_Next().X * 16 && c.Get_Pos().Y == c.Get_Next().Y * 16) {
                    c.Set_InMotion(0, 0);
                    continue;
                }
                swittch = false;
            }
            if (swittch) {
                this.moving = false;
            }
        }
        if (this.turnstate >= 2 && this.turnstate < 4) {
            this.octanom.update();
            boolean win = true;
            for (Ship e : this.crate) {
                e.update();
                boolean hp1 = true;
                for (Ship c : this.cross) {
                    if (!c.Get_Pos().matches(e.Get_Pos())) continue;
                    hp1 = false;
                }
                if (hp1) {
                    e.Set_HP(1);
                    win = false;
                    continue;
                }
                e.Set_HP(2);
            }
            for (Ship e : this.cross) {
                e.update();
            }
            if (win && this.turnstate < 4) {
                this.scorePoint = this.crate.size() * 500;
                this.turnstate = 4;
            }
        }
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.octanom = this.loadEntity(compound, 0);
        this.crate = this.loadEntityList(compound, 1);
        this.cross = this.loadEntityList(compound, 2);
        this.moving = compound.func_74767_n("moving");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveEntity(compound, 0, this.octanom);
        this.saveEntityList(compound, 1, this.crate);
        this.saveEntityList(compound, 2, this.cross);
        compound.func_74757_a("moving", this.moving);
        return compound;
    }

    private void loadMap() {
        List<String> list = MapRoom.loadSokoban(this.RANDOM);
        int y = 0;
        for (String s : list) {
            block8: for (int x = 0; x < 12; ++x) {
                char c = s.charAt(x);
                switch (c) {
                    case ' ': {
                        continue block8;
                    }
                    case 'X': {
                        this.grid[x][y] = 1;
                        continue block8;
                    }
                    case 'O': {
                        this.octanom = new Ship(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y));
                        continue block8;
                    }
                    case 'M': {
                        this.cross.add(new Ship(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y)));
                        continue block8;
                    }
                    case 'C': {
                        this.crate.add(new Ship(1, new Vector2(16 * x, 16 * y), new Vector2(16 * x, 16 * y)));
                    }
                }
            }
            ++y;
        }
    }

    private void commandMove(int direction) {
        if (!this.octanom.isMoving()) {
            int x = 0;
            int y = 0;
            if (direction == 0) {
                x = 0;
                y = -1;
            }
            if (direction == 1) {
                x = 0;
                y = 1;
            }
            if (direction == 2) {
                x = -1;
                y = 0;
            }
            if (direction == 3) {
                x = 1;
                y = 0;
            }
            if (this.grid[this.octanom.Get_Grid().X + x][this.octanom.Get_Grid().Y + y] == 0) {
                boolean blockedO = false;
                for (Ship c : this.crate) {
                    if (c.Get_Grid().X != this.octanom.Get_Grid().X + x || c.Get_Grid().Y != this.octanom.Get_Grid().Y + y) continue;
                    blockedO = true;
                    if (this.grid[this.octanom.Get_Grid().X + x * 2][this.octanom.Get_Grid().Y + y * 2] != 0) continue;
                    boolean blockedC = false;
                    for (Ship c2 : this.crate) {
                        if (c.Get_Grid().X != this.octanom.Get_Grid().X + x * 2 || c.Get_Grid().Y != this.octanom.Get_Grid().Y + y * 2) continue;
                        blockedC = true;
                    }
                    if (blockedC) continue;
                    this.moving = true;
                    c.Set_InMotion(x * 4, y * 4);
                }
                if (!blockedO) {
                    this.octanom.Set_InMotion(x * 4, y * 4);
                }
            }
        }
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 27;
    }
}

