/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import java.util.function.Predicate;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.logic.other.LogicDummy;
import mod.casinocraft.network.MessageBlockServer;
import mod.casinocraft.network.MessagePlayerServer;
import mod.casinocraft.network.MessageScoreServer;
import mod.casinocraft.network.MessageStartServer;
import mod.casinocraft.network.MessageStateServer;
import mod.casinocraft.system.CasinoPacketHandler;
import mod.casinocraft.util.Card;
import mod.casinocraft.util.InventoryUtil;
import mod.casinocraft.util.Ship;
import mod.casinocraft.util.Vector2;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class ScreenCasino
extends ContainerScreen<ContainerCasino> {
    private final PlayerInventory PLAYER;
    protected final ContainerCasino CONTAINER;
    protected int tableID;
    protected int playerToken = -1;
    protected int bet = 0;
    protected int colour = 0;
    protected boolean colourUP = true;
    private final int grayscale = 0xFFFFFF;
    protected int camera1 = 0;
    protected int camera0 = 0;
    protected int shift = 1;
    protected int intro = 256;

    public ScreenCasino(ContainerCasino container, PlayerInventory player, ITextComponent name) {
        super((Container)container, player, name);
        this.PLAYER = player;
        this.CONTAINER = container;
        this.field_146999_f = 256;
        this.field_147000_g = 256;
        this.tableID = this.CONTAINER.tableID;
    }

    private LogicBase logic() {
        return this.CONTAINER.logic();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        this.keyTyped(p_keyPressed_1_);
        if (p_keyPressed_1_ == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        if (p_keyPressed_1_ == 258) {
            boolean flag;
            boolean bl = flag = !ScreenCasino.hasShiftDown();
            if (!this.changeFocus(flag)) {
                this.changeFocus(flag);
            }
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    private void keyTyped(int keyCode) {
        if (this.isCurrentPlayer()) {
            this.keyTyped2(keyCode);
        }
        if (this.tableID == 0) {
            if (this.CONTAINER.turnstate() == 0 && this.tableID == 0 && keyCode == 257) {
                if (!this.CONTAINER.hasToken() || this.playerToken >= this.CONTAINER.getBetLow()) {
                    if (this.CONTAINER.hasToken()) {
                        this.collectBet();
                    }
                    this.start();
                    this.shift = 2;
                }
            } else if (this.CONTAINER.turnstate() == 7 && this.tableID == 0 && keyCode == 257) {
                this.camera1 = 0;
                this.camera0 = 0;
                this.shift = 1;
                this.intro = 256;
                this.reset();
            } else if (this.CONTAINER.turnstate() == 5 && this.tableID == 0 && keyCode == 257) {
                if (this.logic().hasHighscore()) {
                    this.turnstate(7);
                    this.shift = 1;
                } else {
                    this.camera1 = 0;
                    this.camera0 = 0;
                    this.shift = 1;
                    this.intro = 256;
                    this.reset();
                }
            }
            if (this.CONTAINER.turnstate() == 2 && this.tableID == 0 && keyCode == 32) {
                CasinoPacketHandler.sendToServer(new MessageStateServer(true, -1, this.CONTAINER.getPos()));
            }
        } else if (this.tableID == 3) {
            if (this.CONTAINER.turnstate() == 0 && keyCode == 257) {
                if (this.playerToken >= this.CONTAINER.getBetLow()) {
                    this.collectBet();
                    this.start();
                }
            } else if (this.CONTAINER.turnstate() == 5 && keyCode == 257) {
                this.reset();
            }
            if (this.CONTAINER.turnstate() == 2 && this.tableID == 0 && keyCode == 32) {
                CasinoPacketHandler.sendToServer(new MessageStateServer(true, -1, this.CONTAINER.getPos()));
            }
        }
        if (keyCode == 256) {
            this.minecraft.field_71439_g.func_71053_j();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            if (this.CONTAINER.turnstate() == 0) {
                if (this.logic().hasHighscore() && this.mouseRect(82, 164, 92, 26, mouseX, mouseY)) {
                    this.turnstate(7);
                }
                if (this.mouseRect(56, 204, 26, 26, mouseX, mouseY) && this.bet > this.CONTAINER.getBetLow()) {
                    --this.bet;
                }
                if (this.mouseRect(174, 204, 26, 26, mouseX, mouseY) && this.bet < this.CONTAINER.getBetHigh()) {
                    ++this.bet;
                }
                if (this.mouseRect(82, 204, 92, 26, mouseX, mouseY)) {
                    if (!this.CONTAINER.hasToken()) {
                        this.start();
                    } else if (this.playerToken >= this.bet) {
                        this.collectBet();
                        this.playerToken = -1;
                        this.start();
                    }
                }
            } else if (this.CONTAINER.turnstate() == 5) {
                if (this.mouseRect(82, 204, 92, 26, mouseX, mouseY)) {
                    if (this.logic().hasHighscore()) {
                        this.turnstate(7);
                    } else {
                        this.reset();
                    }
                }
            } else if (this.CONTAINER.turnstate() == 7) {
                if (this.mouseRect(82, 204, 92, 26, mouseX, mouseY)) {
                    this.reset();
                }
            } else if (this.CONTAINER.logic().isMultiplayer() && this.CONTAINER.turnstate() == 2 && !this.isCurrentPlayer()) {
                if (this.CONTAINER.logic().hasFreePlayerSlots() && this.mouseRect(26, 237, 78, 22, mouseX, mouseY)) {
                    if (!this.CONTAINER.hasToken()) {
                        this.addNewPlayer();
                    } else if (this.playerToken >= this.bet) {
                        this.collectBet();
                        this.playerToken = -1;
                        this.addNewPlayer();
                    }
                }
            } else if (this.isCurrentPlayer()) {
                this.mouseClicked2(mouseX, mouseY, mouseButton);
            }
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.minecraft.field_71474_y.field_82882_x) {
            this.font.func_211126_b("PLAYER1: " + this.logic().currentPlayer[0], this.tableID == 2 ? 355.0f : 260.0f, 15.0f, 0xFFFFFF);
            this.font.func_211126_b("PLAYER2: " + this.logic().currentPlayer[1], this.tableID == 2 ? 355.0f : 260.0f, 25.0f, 0xFFFFFF);
            this.font.func_211126_b("PLAYER3: " + this.logic().currentPlayer[2], this.tableID == 2 ? 355.0f : 260.0f, 35.0f, 0xFFFFFF);
            this.font.func_211126_b("PLAYER4: " + this.logic().currentPlayer[3], this.tableID == 2 ? 355.0f : 260.0f, 45.0f, 0xFFFFFF);
            this.font.func_211126_b("PLAYER5: " + this.logic().currentPlayer[4], this.tableID == 2 ? 355.0f : 260.0f, 55.0f, 0xFFFFFF);
            this.font.func_211126_b("PLAYER6: " + this.logic().currentPlayer[5], this.tableID == 2 ? 355.0f : 260.0f, 65.0f, 0xFFFFFF);
            this.font.func_211126_b("TIMEOUT: " + this.logic().timeout, this.tableID == 2 ? 355.0f : 260.0f, 75.0f, 0xFFFFFF);
            this.font.func_211126_b("STATE:   " + this.logic().turnstate, this.tableID == 2 ? 355.0f : 260.0f, 85.0f, 0xFFFFFF);
            this.font.func_211126_b("PLAYERS: " + this.logic().getFirstFreePlayerSlot(), this.tableID == 2 ? 355.0f : 260.0f, 95.0f, 0xFFFFFF);
            this.font.func_211126_b("ACTIVE:  " + this.logic().activePlayer, this.tableID == 2 ? 355.0f : 260.0f, 105.0f, 0xFFFFFF);
        }
        if (this.logic() instanceof LogicDummy) {
            return;
        }
        if (this.playerToken == -1 && this.logic().turnstate < 4) {
            this.validateBet();
        }
        if (this.CONTAINER.logic().isMultiplayer() && this.CONTAINER.turnstate() == 2 && !this.isCurrentPlayer() && this.CONTAINER.logic().hasFreePlayerSlots()) {
            this.drawFont("BET:", 158, 244);
            this.itemRenderer.func_175042_a(this.CONTAINER.getToken(), 178, 240);
            if (this.CONTAINER.getBetLow() > 1) {
                this.drawFont("x" + this.CONTAINER.getBetLow(), 208, 244);
            }
        }
        if (this.CONTAINER.turnstate() == 0 && this.tableID != 0) {
            if (this.tableID < 3) {
                if (this.CONTAINER.hasToken() && this.CONTAINER.getBetHigh() > 0) {
                    if (this.CONTAINER.getBetLow() == this.CONTAINER.getBetHigh()) {
                        this.drawFont("The bet is:", 30, 100);
                        this.itemRenderer.func_175042_a(this.CONTAINER.getToken(), 100, 96);
                        if (this.CONTAINER.getBetLow() > 1) {
                            this.drawFont("x" + this.CONTAINER.getBetLow(), 124, 100);
                        }
                    } else {
                        this.drawFont("The bets are:", 30, 100);
                        this.itemRenderer.func_175042_a(this.CONTAINER.getToken(), 100, 96);
                        this.drawFont("x" + this.CONTAINER.getBetLow() + " to x" + this.CONTAINER.getBetHigh(), 124, 100);
                    }
                    if (this.playerToken < this.CONTAINER.getBetLow()) {
                        this.drawFont("You don't have enough Token to play...", 30, 120);
                    } else {
                        this.drawFont("Do you wish to play?", 30, 120);
                    }
                    if (this.CONTAINER.getBetHigh() != this.CONTAINER.getBetLow()) {
                        this.drawFont("Your Bet:  " + this.bet, 30, 140);
                    }
                }
            } else if (this.CONTAINER.hasToken() && this.CONTAINER.getBetHigh() > 0) {
                this.font.func_211126_b("INSERT ", 128.0f, 210.0f, 0xFFFFFF);
                this.itemRenderer.func_175042_a(this.CONTAINER.getToken(), 160, 206);
                if (this.CONTAINER.getBetLow() > 1) {
                    this.font.func_211126_b("x" + this.CONTAINER.getBetLow(), 180.0f, 210.0f, 0xFFFFFF);
                }
                this.font.func_211126_b("Press ENTER", 128.0f, 225.0f, 0xFFFFFF);
            }
        } else if (this.CONTAINER.turnstate() == 7 && this.tableID != 0) {
            for (int i = 0; i < 18; ++i) {
                this.drawFont(this.logic().scoreName[i], 40, 25 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
                this.drawFontInvert("" + this.logic().scoreHigh[i], 216, 25 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
            }
        } else if (this.CONTAINER.turnstate() == 0 && this.tableID == 0) {
            if (this.CONTAINER.hasToken() && this.CONTAINER.getBetHigh() > 0) {
                this.font.func_211126_b("INSERT ", 90.0f, 180.0f, 0xFFFFFF);
                this.itemRenderer.func_175042_a(this.CONTAINER.getToken(), 126, 176);
                if (this.CONTAINER.getBetLow() > 1) {
                    this.font.func_211126_b("x" + this.CONTAINER.getBetLow(), 145.0f, 180.0f, 0xFFFFFF);
                }
                if (this.playerToken < this.CONTAINER.getBetLow()) {
                    this.font.func_211126_b("NOT ENOUGH TOKEN", 80.0f, 210.0f, this.colour);
                } else {
                    this.font.func_211126_b("Press ENTER", 95.0f, 210.0f, this.colour);
                }
            } else {
                this.font.func_211126_b("Press ENTER", 95.0f, 210.0f, this.colour);
            }
            if (this.colourUP) {
                this.colour += 65793;
                if (this.colour >= 0xFFFFFF) {
                    this.colour = 0xFFFFFF;
                    this.colourUP = false;
                }
            } else {
                this.colour -= 65793;
                if (this.colour <= 0) {
                    this.colour = 0;
                    this.colourUP = true;
                }
            }
        } else if (this.CONTAINER.turnstate() == 7 && this.tableID == 0) {
            for (int i = 0; i < 18; ++i) {
                this.drawFont(this.logic().scoreName[i], 40, 25 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
                this.drawFontInvert("" + this.logic().scoreHigh[i], 216, 25 + 10 * i, this.logic().scoreLast == i ? 0x7FFFFF : 0xFFFFFF);
            }
            this.font.func_211126_b("Press ENTER", 95.0f, 220.0f, this.colour);
            if (this.colourUP) {
                this.colour += 65793;
                if (this.colour >= 0xFFFFFF) {
                    this.colour = 0xFFFFFF;
                    this.colourUP = false;
                }
            } else {
                this.colour -= 65793;
                if (this.colour <= 0) {
                    this.colour = 0;
                    this.colourUP = true;
                }
            }
        } else {
            this.drawGuiContainerForegroundLayer2(mouseX, mouseY);
            if (this.logic().turnstate == 4) {
                this.gameOver();
            }
        }
        if (this.CONTAINER.getID() != this.logic().getID()) {
            this.minecraft.field_71439_g.func_71053_j();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tableID == 0) {
            if (this.logic() instanceof LogicDummy) {
                Random RANDOM = new Random();
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_STATIC);
                for (int y = 0; y < 8; ++y) {
                    for (int x = 0; x < 6; ++x) {
                        this.blit(this.field_147003_i + 32 + 32 * x, this.field_147009_r + 32 * y, 32 * RANDOM.nextInt(8), 32 * RANDOM.nextInt(8), 32, 32);
                    }
                }
            } else {
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_GROUND_STARFIELD1);
                this.blit(this.field_147003_i, this.field_147009_r, 0, this.shift == 0 ? 0 : this.camera1, 256, 256);
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_GROUND_STARFIELD0);
                this.blit(this.field_147003_i, this.field_147009_r, 0, this.shift == 0 ? 0 : this.camera0, 256, 256);
            }
        } else if (this.tableID < 3) {
            this.minecraft.func_110434_K().func_110577_a(this.tableID == 0 ? CasinoKeeper.TEXTURE_GROUND_ARCADE : this.getBackground());
            if (this.tableID == 2) {
                this.blit(this.field_147003_i - 128 + 32, this.field_147009_r, 0, 0, this.field_146999_f - 32, this.field_147000_g);
                this.blit(this.field_147003_i + 128, this.field_147009_r, 32, 0, this.field_146999_f - 32, this.field_147000_g);
            } else {
                this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
            }
        } else {
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_SLOTMACHINE);
            this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        if (this.CONTAINER.turnstate() <= 1) {
            this.drawLogo();
        }
        if (this.CONTAINER.turnstate() == 1) {
            --this.intro;
            if (this.intro == 0) {
                this.turnstate(2);
            }
        }
        if (this.CONTAINER.turnstate() >= 1 && this.CONTAINER.turnstate() < 6) {
            if (this.logic().pause) {
                GlStateManager.color4f((float)0.35f, (float)0.35f, (float)0.35f, (float)1.0f);
            }
            this.drawGuiContainerBackgroundLayer2(partialTicks, mouseX, mouseY);
            if (this.isCurrentPlayer()) {
                this.drawGuiContainerBackgroundLayer3(partialTicks, mouseX, mouseY);
            }
            if (this.logic().pause) {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        if (!(this.CONTAINER.turnstate() != 5 && this.CONTAINER.turnstate() != 0 && this.CONTAINER.turnstate() != 7 || this.tableID != 1 && this.tableID != 2 || this.logic() instanceof LogicDummy)) {
            if (this.CONTAINER.turnstate() == 5 && this.logic().hasHighscore()) {
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
                this.blit(this.field_147003_i + 89, this.field_147009_r + 206, 0, 22, 78, 22);
            } else if (this.CONTAINER.turnstate() == 5) {
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
                this.blit(this.field_147003_i + 89, this.field_147009_r + 206, 156, 22, 78, 22);
            } else if (this.CONTAINER.turnstate() == 7) {
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
                this.blit(this.field_147003_i + 89, this.field_147009_r + 206, 156, 22, 78, 22);
            } else if (!this.CONTAINER.hasToken() || this.playerToken >= this.CONTAINER.getBetLow()) {
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
                this.blit(this.field_147003_i + 89, this.field_147009_r + 206, 78, 22, 78, 22);
            }
            if (this.CONTAINER.turnstate() == 0 && this.logic().hasHighscore()) {
                this.blit(this.field_147003_i + 89, this.field_147009_r + 166, 0, 22, 78, 22);
            }
            if (this.CONTAINER.turnstate() == 0 && this.playerToken >= this.CONTAINER.getBetLow()) {
                if (this.bet > this.CONTAINER.getBetLow()) {
                    this.blit(this.field_147003_i + 82 - 26 + 2, this.field_147009_r + 204 + 2, 234, 22, 22, 22);
                }
                if (this.bet < this.CONTAINER.getBetHigh()) {
                    this.blit(this.field_147003_i + 82 + 92 + 2, this.field_147009_r + 204 + 2, 234, 44, 22, 22);
                }
            }
        }
        if (this.CONTAINER.logic().isMultiplayer() && this.CONTAINER.turnstate() == 2 && !this.isCurrentPlayer() && this.CONTAINER.logic().hasFreePlayerSlots()) {
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
            this.blit(this.field_147003_i + 153, this.field_147009_r + 237, 78, 220, 78, 22);
            if (!this.CONTAINER.hasToken() || this.playerToken >= this.CONTAINER.getBetLow()) {
                this.blit(this.field_147003_i + 26, this.field_147009_r + 237, 0, 220, 78, 22);
            }
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_DICE);
            this.blit(this.field_147003_i + 128 - 16, this.field_147009_r + 232, 192, 32 + 32 * this.CONTAINER.logic().getFirstFreePlayerSlot(), 32, 32);
        }
        if (this.tableID == 0) {
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_GROUND_ARCADE);
            this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
            if (this.CONTAINER.turnstate() != 5) {
                this.camera1 = (this.camera1 + this.shift) % 256;
            }
            if (this.CONTAINER.turnstate() != 5) {
                this.camera0 = (this.camera0 + this.shift * 2) % 256;
            }
        }
        if ((this.logic().turnstate == 2 || this.logic().turnstate == 3) && this.logic().isMultiplayer()) {
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_DICE);
            for (int i = 0; i < this.logic().getFirstFreePlayerSlot(); ++i) {
                this.blit(this.field_147003_i + (this.tableID == 2 ? 340 : 245), this.field_147009_r + 32 + 36 * i, 224, 32 + 32 * i, 32, 32);
            }
            if (this.logic().activePlayer < this.logic().getFirstFreePlayerSlot()) {
                this.blit(this.field_147003_i + (this.tableID == 2 ? 340 : 245), this.field_147009_r + 32 + 36 * this.logic().activePlayer, 192, 32 + 32 * this.logic().activePlayer, 32, 32);
            }
        }
    }

    private void gameOver() {
        int pos = this.getPlayerPosition();
        if (pos > -1 && this.playerToken != -1) {
            this.payBet(this.logic().reward[pos]);
            this.turnstate(10 + pos);
            this.playerToken = -1;
        }
        if (this.allCleared()) {
            this.turnstate(5);
            if (this.logic().hasHighscore()) {
                CasinoPacketHandler.sendToServer(new MessageScoreServer(this.PLAYER.field_70458_d.func_200200_C_().getString(), this.logic().scorePoint, this.CONTAINER.getPos()));
            } else {
                this.turnstate(-3);
            }
        }
    }

    private boolean allCleared() {
        for (int i = 0; i < 6; ++i) {
            if (this.logic().reward[i] <= 0) continue;
            return false;
        }
        return true;
    }

    private ResourceLocation getBackground() {
        if (this.CONTAINER.color == DyeColor.BLACK) {
            return CasinoKeeper.TEXTURE_GROUND_BLACK;
        }
        if (this.CONTAINER.color == DyeColor.BLUE) {
            return CasinoKeeper.TEXTURE_GROUND_BLUE;
        }
        if (this.CONTAINER.color == DyeColor.BROWN) {
            return CasinoKeeper.TEXTURE_GROUND_BROWN;
        }
        if (this.CONTAINER.color == DyeColor.CYAN) {
            return CasinoKeeper.TEXTURE_GROUND_CYAN;
        }
        if (this.CONTAINER.color == DyeColor.GRAY) {
            return CasinoKeeper.TEXTURE_GROUND_GRAY;
        }
        if (this.CONTAINER.color == DyeColor.GREEN) {
            return CasinoKeeper.TEXTURE_GROUND_GREEN;
        }
        if (this.CONTAINER.color == DyeColor.LIGHT_BLUE) {
            return CasinoKeeper.TEXTURE_GROUND_LIGHT_BLUE;
        }
        if (this.CONTAINER.color == DyeColor.LIME) {
            return CasinoKeeper.TEXTURE_GROUND_LIME;
        }
        if (this.CONTAINER.color == DyeColor.MAGENTA) {
            return CasinoKeeper.TEXTURE_GROUND_MAGENTA;
        }
        if (this.CONTAINER.color == DyeColor.ORANGE) {
            return CasinoKeeper.TEXTURE_GROUND_ORANGE;
        }
        if (this.CONTAINER.color == DyeColor.PINK) {
            return CasinoKeeper.TEXTURE_GROUND_PINK;
        }
        if (this.CONTAINER.color == DyeColor.PURPLE) {
            return CasinoKeeper.TEXTURE_GROUND_PURPLE;
        }
        if (this.CONTAINER.color == DyeColor.RED) {
            return CasinoKeeper.TEXTURE_GROUND_RED;
        }
        if (this.CONTAINER.color == DyeColor.LIGHT_GRAY) {
            return CasinoKeeper.TEXTURE_GROUND_LIGHT_GRAY;
        }
        if (this.CONTAINER.color == DyeColor.WHITE) {
            return CasinoKeeper.TEXTURE_GROUND_WHITE;
        }
        if (this.CONTAINER.color == DyeColor.YELLOW) {
            return CasinoKeeper.TEXTURE_GROUND_YELLOW;
        }
        return CasinoKeeper.TEXTURE_GROUND_GRAY;
    }

    protected boolean mouseRect(int x, int y, int width, int height, double mouseX, double mouseY) {
        if ((double)(this.field_147003_i + x) < mouseX && mouseX < (double)(this.field_147003_i + x + width)) {
            return (double)(this.field_147009_r + y) < mouseY && mouseY < (double)(this.field_147009_r + y + height);
        }
        return false;
    }

    protected void validateBet() {
        this.playerToken = -2;
        if (this.bet < this.CONTAINER.getBetLow()) {
            this.bet = this.CONTAINER.getBetLow();
        }
        if (this.bet > this.CONTAINER.getBetHigh()) {
            this.bet = this.CONTAINER.getBetHigh();
        }
        if (this.CONTAINER.hasToken()) {
            Item item = this.CONTAINER.getToken().func_77973_b();
            int count = 0;
            for (int i = 0; i < 36; ++i) {
                if (item != this.PLAYER.func_70301_a(i).func_77973_b()) continue;
                count += this.PLAYER.func_70301_a(i).func_190916_E();
            }
            this.playerToken = count;
        }
    }

    protected boolean anotherBet() {
        this.validateBet();
        if (this.playerToken >= this.bet) {
            this.collectBet();
            return true;
        }
        return false;
    }

    protected void collectBet() {
        if (this.CONTAINER.hasToken()) {
            InventoryUtil.decreaseInventory(this.PLAYER, this.CONTAINER.getToken(), this.bet);
            this.PLAYER.func_195408_a(Predicate.isEqual(this.CONTAINER.getToken()), this.bet);
            CasinoPacketHandler.sendToServer(new MessagePlayerServer(this.CONTAINER.getToken().func_77973_b(), 0, -this.bet));
            if (!this.CONTAINER.isCreative()) {
                this.CONTAINER.setBetStorage(this.CONTAINER.getBetStorage() + this.bet);
                CasinoPacketHandler.sendToServer(new MessageBlockServer(this.CONTAINER.inventory.func_70301_a(0), this.CONTAINER.inventory.func_70301_a(1), this.CONTAINER.inventory.func_70301_a(4), this.CONTAINER.getBetStorage(), this.CONTAINER.getPos()));
            }
        }
    }

    private void payBet(int multi) {
        if (multi <= 0) {
            return;
        }
        if (this.CONTAINER.hasToken()) {
            if (!this.CONTAINER.isCreative()) {
                Item item = this.CONTAINER.getToken().func_77973_b();
                int count = this.bet * multi;
                int count2 = 0;
                count2 = Math.min(this.CONTAINER.getBetStorage(), count);
                this.CONTAINER.setBetStorage(this.CONTAINER.getBetStorage() - count);
                if (this.CONTAINER.getBetStorage() <= 0) {
                    this.CONTAINER.setBetStorage(0);
                    this.CONTAINER.setToken(new ItemStack((IItemProvider)Blocks.field_150350_a));
                }
                CasinoPacketHandler.sendToServer(new MessageBlockServer(this.CONTAINER.inventory.func_70301_a(0), this.CONTAINER.inventory.func_70301_a(1), this.CONTAINER.inventory.func_70301_a(4), this.CONTAINER.getBetStorage(), this.CONTAINER.getPos()));
                this.PLAYER.func_70441_a(new ItemStack((IItemProvider)item, count2));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, 0, count2));
            } else {
                Item item = this.CONTAINER.getToken().func_77973_b();
                int count = this.bet * multi;
                this.PLAYER.func_70441_a(new ItemStack((IItemProvider)item, count));
                CasinoPacketHandler.sendToServer(new MessagePlayerServer(item, 0, count));
            }
        }
    }

    protected void action(int action) {
        CasinoPacketHandler.sendToServer(new MessageStateServer(false, action, this.CONTAINER.getPos()));
    }

    protected void start() {
        Random r = new Random();
        CasinoPacketHandler.sendToServer(new MessageStartServer(this.PLAYER.field_70458_d.func_200200_C_().getString(), r.nextInt(1000000), this.CONTAINER.getPos()));
    }

    private void reset() {
        CasinoPacketHandler.sendToServer(new MessageStateServer(true, 0, this.CONTAINER.getPos()));
    }

    protected void turnstate(int state) {
        CasinoPacketHandler.sendToServer(new MessageStateServer(true, state, this.CONTAINER.getPos()));
    }

    private void addNewPlayer() {
        CasinoPacketHandler.sendToServer(new MessageStartServer(this.PLAYER.field_70458_d.func_200200_C_().getString(), -1, this.CONTAINER.getPos()));
    }

    protected boolean isCurrentPlayer() {
        if (this.CONTAINER.logic().isMultiplayer()) {
            if (this.CONTAINER.getCurrentPlayer(0).matches("void")) {
                return true;
            }
            for (int i = 0; i < 6; ++i) {
                if (!this.CONTAINER.getCurrentPlayer(i).matches(this.PLAYER.field_70458_d.func_200200_C_().getString())) continue;
                return true;
            }
        } else {
            return this.CONTAINER.getCurrentPlayer(0).matches("void") || this.CONTAINER.getCurrentPlayer(0).matches(this.PLAYER.field_70458_d.func_200200_C_().getString());
        }
        return false;
    }

    protected boolean isActivePlayer() {
        if (this.CONTAINER.logic().isMultiplayer()) {
            for (int i = 0; i < 6; ++i) {
                if (!this.CONTAINER.getCurrentPlayer(i).matches(this.PLAYER.field_70458_d.func_200200_C_().getString()) || i != this.logic().activePlayer) continue;
                return true;
            }
        } else {
            return this.CONTAINER.getCurrentPlayer(0).matches(this.PLAYER.field_70458_d.func_200200_C_().getString());
        }
        return false;
    }

    protected int getPlayerPosition() {
        if (this.CONTAINER.logic().isMultiplayer()) {
            for (int i = 0; i < 6; ++i) {
                if (!this.CONTAINER.getCurrentPlayer(i).matches(this.PLAYER.field_70458_d.func_200200_C_().getString())) continue;
                return i;
            }
        } else {
            return this.CONTAINER.getCurrentPlayer(0).matches(this.PLAYER.field_70458_d.func_200200_C_().getString()) ? 0 : -1;
        }
        return -1;
    }

    protected void drawFont(String text, int x, int y) {
        this.drawFont(text, x, y, 0xFFFFFF);
    }

    protected void drawFont(String text, int x, int y, int color) {
        this.font.func_211126_b(text, (float)(x + 1), (float)(y + 1), 0);
        this.font.func_211126_b(text, (float)(x + 0), (float)(y + 0), color);
    }

    protected void drawFontInvert(String text, int x, int y) {
        this.drawFontInvert(text, x, y, 0xFFFFFF);
    }

    protected void drawFontInvert(String text, int x, int y, int color) {
        int w = this.font.func_78256_a(text);
        this.font.func_211126_b(text, (float)(x + 1 - w), (float)(y + 1), 0);
        this.font.func_211126_b(text, (float)(x + 0 - w), (float)(y + 0), color);
    }

    protected void drawFontCenter(String text, int x, int y) {
        this.drawFontCenter(text, x, y, 0xFFFFFF);
    }

    protected void drawFontCenter(String text, int x, int y, int color) {
        int w = this.font.func_78256_a(text);
        this.font.func_211126_b(text, (float)(x + 1 - w / 2), (float)(y + 1), 0);
        this.font.func_211126_b(text, (float)(x + 0 - w / 2), (float)(y + 0), color);
    }

    public void drawCard(int posX, int posY, Card card) {
        int texY;
        if (card.suit == -1) {
            return;
        }
        if (card.hidden) {
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_NOIR);
        } else {
            if (card.suit <= 1) {
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_ROUGE);
            }
            if (card.suit >= 2) {
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_NOIR);
            }
        }
        int texX = card.suit == -1 || card.hidden ? 0 : card.number % 8;
        int n = texY = card.suit == -1 || card.hidden ? 4 : card.suit % 2 * 2 + card.number / 8;
        if (((Boolean)CasinoKeeper.config_animated_cards.get()).booleanValue() && !card.hidden && card.number >= 10 && this.logic().frame == card.suit * 12 + (card.number - 10) * 3) {
            texX += 3;
        }
        this.blit(this.field_147003_i + posX + card.shiftX, this.field_147009_r + posY + card.shiftY, texX * 32, texY * 48, 32, 48 - card.deathtimer);
    }

    public void drawCardBack(int posX, int posY, int color) {
        if (color <= 6) {
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_NOIR);
        } else {
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_ROUGE);
        }
        this.blit(this.field_147003_i + posX, this.field_147009_r + posY, color % 7 * 32, 192, 32, 48);
    }

    private void drawLetter(char c, int posX, int posY, int sizeX, int sizeY, int vanish) {
        if (c == 'a') {
            this.blit(posX, posY + vanish, 0 * sizeX, 0 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'b') {
            this.blit(posX, posY + vanish, 1 * sizeX, 0 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'c') {
            this.blit(posX, posY + vanish, 2 * sizeX, 0 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'd') {
            this.blit(posX, posY + vanish, 3 * sizeX, 0 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'e') {
            this.blit(posX, posY + vanish, 4 * sizeX, 0 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'f') {
            this.blit(posX, posY + vanish, 5 * sizeX, 0 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'g') {
            this.blit(posX, posY + vanish, 6 * sizeX, 0 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'h') {
            this.blit(posX, posY + vanish, 7 * sizeX, 0 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'i') {
            this.blit(posX, posY + vanish, 0 * sizeX, 1 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'j') {
            this.blit(posX, posY + vanish, 1 * sizeX, 1 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'k') {
            this.blit(posX, posY + vanish, 2 * sizeX, 1 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'l') {
            this.blit(posX, posY + vanish, 3 * sizeX, 1 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'm') {
            this.blit(posX, posY + vanish, 4 * sizeX, 1 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'n') {
            this.blit(posX, posY + vanish, 5 * sizeX, 1 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'o') {
            this.blit(posX, posY + vanish, 6 * sizeX, 1 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'p') {
            this.blit(posX, posY + vanish, 7 * sizeX, 1 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'q') {
            this.blit(posX, posY + vanish, 0 * sizeX, 2 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'r') {
            this.blit(posX, posY + vanish, 1 * sizeX, 2 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 's') {
            this.blit(posX, posY + vanish, 2 * sizeX, 2 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 't') {
            this.blit(posX, posY + vanish, 3 * sizeX, 2 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'u') {
            this.blit(posX, posY + vanish, 4 * sizeX, 2 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'v') {
            this.blit(posX, posY + vanish, 5 * sizeX, 2 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'w') {
            this.blit(posX, posY + vanish, 6 * sizeX, 2 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'x') {
            this.blit(posX, posY + vanish, 7 * sizeX, 2 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'y') {
            this.blit(posX, posY + vanish, 0 * sizeX, 3 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == 'z') {
            this.blit(posX, posY + vanish, 1 * sizeX, 3 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '0') {
            this.blit(posX, posY + vanish, 2 * sizeX, 3 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '1') {
            this.blit(posX, posY + vanish, 3 * sizeX, 3 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '2') {
            this.blit(posX, posY + vanish, 4 * sizeX, 3 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '3') {
            this.blit(posX, posY + vanish, 5 * sizeX, 3 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '4') {
            this.blit(posX, posY + vanish, 6 * sizeX, 3 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '5') {
            this.blit(posX, posY + vanish, 7 * sizeX, 3 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '6') {
            this.blit(posX, posY + vanish, 0 * sizeX, 4 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '7') {
            this.blit(posX, posY + vanish, 1 * sizeX, 4 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '8') {
            this.blit(posX, posY + vanish, 2 * sizeX, 4 * sizeY + vanish, sizeX, sizeY - vanish);
        }
        if (c == '9') {
            this.blit(posX, posY + vanish, 3 * sizeX, 4 * sizeY + vanish, sizeX, sizeY - vanish);
        }
    }

    private void drawLogo() {
        int vanish;
        int move = 256 - this.intro;
        int n = move < 32 ? 0 : (vanish = move - 30 > 32 ? 32 : move - 30);
        if (move >= 30) {
            boolean bl = false;
        }
        int sizeX = 0;
        String[] logo = this.getGameName().split("_");
        if (this.tableID <= 2) {
            if (this.tableID == 0) {
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_FONT_ARCADE);
                sizeX = 16;
            } else if (this.tableID == 1 || this.tableID == 2) {
                this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_FONT_CARDTABLE);
                sizeX = 32;
                vanish = 0;
            }
            for (int i = 0; i < logo.length; ++i) {
                for (int k = 0; k < logo[i].length(); ++k) {
                    this.drawLetter(logo[i].charAt(k), this.field_147003_i + 128 - logo[i].length() * (sizeX / 2) + sizeX * k, this.field_147009_r + 32 + 32 * i - move, 32, 32, vanish);
                }
            }
        }
    }

    protected void drawMino(int posX, int posY, int idX, int idY) {
        this.blit(this.field_147003_i + posX, this.field_147009_r + posY, 24 * idX, 24 * idY, 24, 24);
    }

    protected void drawMino(int posX, int posY) {
        this.drawMino(posX, posY, 0, 0);
    }

    protected void drawMinoSmall(int posX, int posY, int id, boolean alternate) {
        if (alternate) {
            this.blit(this.field_147003_i + posX, this.field_147009_r + posY, 240, 16 * id, 16, 16);
        } else {
            this.blit(this.field_147003_i + posX, this.field_147009_r + posY, 16 * id, 240, 16, 16);
        }
    }

    protected void drawMinoSmall(int posX, int posY) {
        this.drawMinoSmall(posX, posY, 0, false);
    }

    protected void drawDigi(int posX, int posY, int idX, int idY) {
        this.blit(this.field_147003_i + posX, this.field_147009_r + posY, 16 * idX, 16 + 16 * idY, 16, 16);
    }

    protected void drawDigi(int posX, int posY) {
        this.drawDigi(posX, posY, 0, 0);
    }

    protected void drawDigiSmall(int posX, int posY, int id) {
        this.blit(this.field_147003_i + posX, this.field_147009_r + posY, 2 + 16 * id, 2, 12, 12);
    }

    protected void drawDigiSmall(int posX, int posY) {
        this.drawDigiSmall(posX, posY, 0);
    }

    protected void drawButton(int posX, int posY, int id) {
    }

    protected void drawShip(Ship ship, int shipID, boolean hasLookDirection, boolean animate) {
        int frame;
        int n = frame = this.logic().turnstate < 4 && animate ? this.logic().frame % 12 / 2 : 0;
        if (frame == 4) {
            frame = 2;
        }
        if (frame == 5) {
            frame = 1;
        }
        int direction = hasLookDirection ? ship.Get_LookDirection() : 0;
        this.blit(this.field_147003_i + 32 + ship.Get_Pos().X, this.field_147009_r + 8 + ship.Get_Pos().Y, 64 * (shipID % 4) + 16 * frame, 128 + direction * 16 + shipID / 4 * 64, 16, 16);
    }

    protected void drawShip(Vector2 vec, int shipID) {
        int frame;
        int n = frame = this.logic().turnstate < 4 ? this.logic().frame % 12 / 2 : 0;
        if (frame == 4) {
            frame = 2;
        }
        if (frame == 5) {
            frame = 1;
        }
        this.blit(this.field_147003_i + 32 + vec.X * 16, this.field_147009_r + 8 + vec.Y * 16, 64 * (shipID % 4) + 16 * frame, 128 + shipID / 4 * 64, 16, 16);
    }

    protected abstract void keyTyped2(int var1);

    protected abstract void mouseClicked2(double var1, double var3, int var5);

    protected abstract void drawGuiContainerForegroundLayer2(int var1, int var2);

    protected abstract void drawGuiContainerBackgroundLayer2(float var1, int var2, int var3);

    protected abstract void drawGuiContainerBackgroundLayer3(float var1, int var2, int var3);

    protected abstract String getGameName();
}

