/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.mino;

import java.util.Random;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerCasino;
import mod.casinocraft.logic.mino.LogicMinoOrange;
import mod.casinocraft.screen.ScreenCasino;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class ScreenMinoOrange
extends ScreenCasino {
    private int diceColor = 0;

    public ScreenMinoOrange(ContainerCasino container, PlayerInventory player, ITextComponent name) {
        super(container, player, name);
        Random rand = new Random();
        this.diceColor = rand.nextInt(8);
    }

    public LogicMinoOrange logic() {
        return (LogicMinoOrange)this.CONTAINER.logic();
    }

    @Override
    protected void mouseClicked2(double mouseX, double mouseY, int mouseButton) {
        if (this.logic().turnstate == 2 && mouseButton == 0) {
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 8; ++x) {
                    int posX = this.tableID == 1 ? (x == 0 ? 48 : (x == 7 ? 176 : 80 + 16 * (x - 1))) : (x == 0 ? -48 : (x == 7 ? 272 : -16 + 48 * (x - 1)));
                    int posY = 48 + 32 * y;
                    int sizeX = this.tableID == 1 ? (x == 0 ? 32 : (x == 7 ? 32 : 16)) : (x == 0 ? 32 : (x == 7 ? 32 : 48));
                    int sizeY = 32;
                    if (!this.mouseRect(posX, posY, sizeX, sizeY, mouseX, mouseY)) continue;
                    this.action(x + y * 8);
                }
            }
            if (this.mouseRect(24, 235, 92, 26, mouseX, mouseY) && this.playerToken >= this.bet) {
                this.action(-1);
                this.collectBet();
                this.playerToken = -1;
            }
            if (this.mouseRect(140, 235, 92, 26, mouseX, mouseY)) {
                this.action(-2);
            }
        }
        if ((this.logic().turnstate == 3 || this.logic().turnstate == 4) && this.mouseRect(82, 235, 92, 26, mouseX, mouseY)) {
            this.action(-2);
        }
    }

    @Override
    protected void keyTyped2(int keyCode) {
        if (keyCode == 257) {
            this.action(-2);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer2(int mouseX, int mouseY) {
        if (this.logic().turnstate >= 2) {
            this.drawFont(this.logic().hand, 20, 28);
        }
        if (this.logic().result > -1) {
            this.drawFont("" + this.logic().result, 200, 28);
        }
        if (this.logic().point > -1) {
            this.drawFont("" + this.logic().point, 220, 28);
        }
        if (this.logic().comepoint > -1) {
            this.drawFont("" + this.logic().comepoint, 240, 28);
        }
        if (this.logic().turnstate == 2 && (Integer)CasinoKeeper.config_timeout.get() - this.logic().timeout > 0) {
            this.drawFontInvert("" + ((Integer)CasinoKeeper.config_timeout.get() - this.logic().timeout), this.tableID == 1 ? 238 : 336, 4);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer2(float partialTicks, int mouseX, int mouseY) {
        if (this.tableID == 1) {
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_CRAPS_MIDDLE);
            this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        } else {
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_CRAPS_LEFT);
            this.blit(this.field_147003_i - 128, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
            this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_CRAPS_RIGHT);
            this.blit(this.field_147003_i + 128, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_DICE);
        if (this.logic().turnstate >= 2) {
            int color = 0;
            for (int y = 0; y < 5; ++y) {
                for (int x = 0; x < 8; ++x) {
                    int posX = this.tableID == 1 ? (x == 0 ? 48 : (x == 7 ? 176 : 80 + 16 * (x - 1) - 8)) : (x == 0 ? -48 : (x == 7 ? 272 : -16 + 48 * (x - 1) + 8));
                    int posY = 48 + 32 * y;
                    color = this.logic().grid[x][y];
                    if (color != 0) {
                        this.blit(this.field_147003_i + posX, this.field_147009_r + posY, 192, 32 * color, 32, 32);
                    }
                    if (!this.logic().selector.matches(x, y)) continue;
                    this.blit(this.field_147003_i + posX, this.field_147009_r + posY, 224, 32 * (this.logic().activePlayer + 1), 32, 32);
                }
            }
        }
        if (this.logic().turnstate == 3) {
            this.blit(this.field_147003_i + this.logic().dice[0].posX, this.field_147009_r + this.logic().dice[0].posY, this.logic().dice[0].number * 32, this.diceColor * 32, 32, 32);
            this.blit(this.field_147003_i + this.logic().dice[1].posX, this.field_147009_r + this.logic().dice[1].posY, this.logic().dice[1].number * 32, this.diceColor * 32, 32, 32);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer3(float partialTicks, int mouseX, int mouseY) {
        this.minecraft.func_110434_K().func_110577_a(CasinoKeeper.TEXTURE_BUTTONS);
        if (this.logic().turnstate == 2) {
            if (this.playerToken == -1) {
                this.validateBet();
            }
            if (this.playerToken >= this.bet) {
                this.blit(this.field_147003_i + 24 + 7, this.field_147009_r + 251 - 16, 0, 0, 78, 22);
            }
            this.blit(this.field_147003_i + 140 + 7, this.field_147009_r + 251 - 16, 78, 0, 78, 22);
        }
        if (this.logic().turnstate == 3 && this.logic().dice[0].shiftX == 0 && this.logic().dice[1].shiftX == 0) {
            this.blit(this.field_147003_i + 89, this.field_147009_r + 251 - 16, 78, 44, 78, 22);
        }
    }

    @Override
    protected String getGameName() {
        return "craps";
    }
}

