/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.card;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.CompoundNBT;

public class LogicCardRed
extends LogicBase {
    public List<Card> cards_rouge = new ArrayList<Card>();
    public List<Card> cards_noir = new ArrayList<Card>();
    public int value_rouge = 0;
    public int value_noir = 0;

    public LogicCardRed(int table) {
        super(table);
    }

    @Override
    public void start2() {
        this.selector.set(-1, -1);
        this.cards_rouge.clear();
        this.cards_noir.clear();
        this.value_rouge = 0;
        this.value_noir = 0;
    }

    @Override
    public void command(int action) {
        this.selector.X = action;
        this.turnstate = 3;
        this.cards_rouge.add(new Card(this.RANDOM, 0, -50));
    }

    @Override
    public void updateMotion() {
        for (Card c : this.cards_rouge) {
            c.update();
        }
        for (Card c : this.cards_noir) {
            c.update();
        }
    }

    @Override
    public void updateLogic() {
        if (this.turnstate == 3) {
            if (this.value_rouge < 31) {
                if (this.cards_rouge.get((int)(this.cards_rouge.size() - 1)).shiftY >= -10) {
                    this.value_rouge += this.cards_rouge.get((int)(this.cards_rouge.size() - 1)).number >= 9 ? 10 : this.cards_rouge.get((int)(this.cards_rouge.size() - 1)).number + 1;
                    if (this.value_rouge >= 31) {
                        this.cards_noir.add(new Card(this.RANDOM, 0, -50));
                    } else {
                        this.cards_rouge.add(new Card(this.RANDOM, 0, -50));
                    }
                }
            } else if (this.cards_noir.get((int)(this.cards_noir.size() - 1)).shiftY >= -10) {
                this.value_noir += this.cards_noir.get((int)(this.cards_noir.size() - 1)).number >= 9 ? 10 : this.cards_noir.get((int)(this.cards_noir.size() - 1)).number + 1;
                if (this.value_noir >= 31) {
                    this.result();
                } else {
                    this.cards_noir.add(new Card(this.RANDOM, 0, -50));
                }
            }
        }
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.cards_rouge = this.loadCardList(compound, 0);
        this.cards_noir = this.loadCardList(compound, 1);
        this.value_rouge = compound.func_74762_e("valuerouge");
        this.value_noir = compound.func_74762_e("valuenoir");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveCardList(compound, 0, this.cards_rouge);
        this.saveCardList(compound, 1, this.cards_noir);
        compound.func_74768_a("valuerouge", this.value_rouge);
        compound.func_74768_a("valuenoir", this.value_noir);
        return compound;
    }

    public void result() {
        this.turnstate = 4;
        if (this.value_rouge < this.value_noir) {
            this.hand = "Rouge Wins!";
            if (this.selector.X == 0) {
                this.reward[0] = 2;
            }
        }
        if (this.value_rouge > this.value_noir) {
            this.hand = "Noir Wins!";
            if (this.selector.X == 1) {
                this.reward[0] = 2;
            }
        }
        if (this.value_rouge == this.value_noir) {
            this.hand = "Tie!";
            this.reward[0] = 1;
        }
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 13;
    }
}

