/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Vector2;
import net.minecraft.nbt.CompoundNBT;

public class LogicMinoLightGray
extends LogicBase {
    private List<Vector2> FieldList = new ArrayList<Vector2>();
    public int bombs = 0;

    public LogicMinoLightGray(int tableID) {
        super(tableID, 26, 14);
    }

    @Override
    public void start2() {
        this.bombs = 0;
        this.selector = new Vector2(5, 5);
        this.FieldList.clear();
        this.scoreLevel = 1;
        this.createField();
    }

    private void restart() {
        this.turnstate = 2;
        this.FieldList.clear();
        ++this.scoreLevel;
        this.resetGrid();
        this.createField();
    }

    @Override
    public void command(int action) {
        if (action == -1) {
            this.restart();
        } else if (action == -2) {
            this.turnstate = 4;
        } else {
            this.selector = new Vector2(action % 26, action / 26);
            this.commandGridEnter();
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void updateLogic() {
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.bombs = compound.func_74762_e("bombs");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        compound.func_74768_a("bombs", this.bombs);
        return compound;
    }

    private void createField() {
        int x;
        this.bombs = this.scoreLevel + this.scoreLevel * this.tableID * 3;
        int max = this.tableID == 1 ? 196 : 364;
        if (this.bombs > (max -= max / 4)) {
            this.bombs = max;
        }
        for (int i = 0; i < this.bombs; ++i) {
            int y;
            x = this.RANDOM.nextInt(this.tableID == 1 ? 14 : 26) + (this.tableID == 1 ? 6 : 0);
            if (this.grid[x][y = this.RANDOM.nextInt(14)] != 9) {
                this.grid[x][y] = 9;
                continue;
            }
            --i;
        }
        for (int y = 0; y < 14; ++y) {
            for (x = this.tableID == 1 ? 6 : 0; x < (this.tableID == 1 ? 20 : 26); ++x) {
                if (this.grid[x][y] != 9) {
                    int count = 0;
                    if (x > 0 && y > 0 && this.grid[x - 1][y - 1] % 20 == 9) {
                        ++count;
                    }
                    if (y > 0 && this.grid[x][y - 1] % 20 == 9) {
                        ++count;
                    }
                    if (x < 25 && y > 0 && this.grid[x + 1][y - 1] % 20 == 9) {
                        ++count;
                    }
                    if (x < 25 && this.grid[x + 1][y] % 20 == 9) {
                        ++count;
                    }
                    if (x < 25 && y < 13 && this.grid[x + 1][y + 1] % 20 == 9) {
                        ++count;
                    }
                    if (y < 13 && this.grid[x][y + 1] % 20 == 9) {
                        ++count;
                    }
                    if (x > 0 && y < 13 && this.grid[x - 1][y + 1] % 20 == 9) {
                        ++count;
                    }
                    if (x <= 0 || this.grid[x - 1][y] % 20 == 9) {
                        // empty if block
                    }
                    this.grid[x][y] = ++count;
                }
                int[] nArray = this.grid[x];
                int n = y;
                nArray[n] = nArray[n] + 20;
            }
        }
    }

    private void commandGridEnter() {
        if (this.grid[this.selector.X][this.selector.Y] >= 20) {
            int[] nArray = this.grid[this.selector.X];
            int n = this.selector.Y;
            nArray[n] = nArray[n] - 20;
            if (this.grid[this.selector.X][this.selector.Y] == 9) {
                this.grid[this.selector.X][this.selector.Y] = 10;
                this.uncoverBombs();
                this.turnstate = 4;
                this.scorePoint -= this.scorePoint / 2;
            } else {
                if (this.grid[this.selector.X][this.selector.Y] == 0) {
                    this.FieldList.add(this.selector);
                    this.uncoverTiles();
                }
                boolean uncoveredAll = true;
                for (int i = 0; i < 14; ++i) {
                    for (int j = 0; j < 26; ++j) {
                        if (this.grid[j][i] % 20 == 9 || this.grid[j][i] < 20) continue;
                        uncoveredAll = false;
                    }
                }
                if (uncoveredAll) {
                    this.turnstate = 3;
                    this.scorePoint += this.bombs;
                }
            }
        }
    }

    private void uncoverTiles() {
        while (this.FieldList.size() > 0) {
            boolean temp0 = false;
            Iterator<Vector2> iterator = this.FieldList.iterator();
            if (iterator.hasNext()) {
                boolean temp;
                Vector2 v = iterator.next();
                if (v.X > 0 && v.Y > 0 && this.grid[v.X - 1][v.Y - 1] >= 20) {
                    int[] nArray = this.grid[v.X - 1];
                    int n = v.Y - 1;
                    nArray[n] = nArray[n] - 20;
                    if (this.grid[v.X - 1][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.Y > 0 && this.grid[v.X][v.Y - 1] >= 20) {
                    int[] nArray = this.grid[v.X];
                    int n = v.Y - 1;
                    nArray[n] = nArray[n] - 20;
                    if (this.grid[v.X][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && v.Y > 0 && this.grid[v.X + 1][v.Y - 1] >= 20) {
                    int[] nArray = this.grid[v.X + 1];
                    int n = v.Y - 1;
                    nArray[n] = nArray[n] - 20;
                    if (this.grid[v.X + 1][v.Y - 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y - 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y - 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && this.grid[v.X + 1][v.Y] >= 20) {
                    int[] nArray = this.grid[v.X + 1];
                    int n = v.Y;
                    nArray[n] = nArray[n] - 20;
                    if (this.grid[v.X + 1][v.Y] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X < 25 && v.Y < 13 && this.grid[v.X + 1][v.Y + 1] >= 20) {
                    int[] nArray = this.grid[v.X + 1];
                    int n = v.Y + 1;
                    nArray[n] = nArray[n] - 20;
                    if (this.grid[v.X + 1][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X + 1, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X + 1, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.Y < 13 && this.grid[v.X][v.Y + 1] >= 20) {
                    int[] nArray = this.grid[v.X];
                    int n = v.Y + 1;
                    nArray[n] = nArray[n] - 20;
                    if (this.grid[v.X][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X > 0 && v.Y < 13 && this.grid[v.X - 1][v.Y + 1] >= 20) {
                    int[] nArray = this.grid[v.X - 1];
                    int n = v.Y + 1;
                    nArray[n] = nArray[n] - 20;
                    if (this.grid[v.X - 1][v.Y + 1] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y + 1)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y + 1));
                            temp0 = true;
                            break;
                        }
                    }
                }
                if (v.X > 0 && this.grid[v.X - 1][v.Y] >= 20) {
                    int[] nArray = this.grid[v.X - 1];
                    int n = v.Y;
                    nArray[n] = nArray[n] - 20;
                    if (this.grid[v.X - 1][v.Y] == 0) {
                        temp = false;
                        for (Vector2 v2 : this.FieldList) {
                            if (v2.matches(v.X - 1, v.Y)) {
                                temp = true;
                                break;
                            }
                            if (temp) continue;
                            this.FieldList.add(new Vector2(v.X - 1, v.Y));
                            temp0 = true;
                            break;
                        }
                    }
                }
            }
            if (temp0) continue;
            this.FieldList.remove(0);
        }
    }

    private void uncoverBombs() {
        for (int y = 0; y < 14; ++y) {
            for (int x = 0; x < 26; ++x) {
                if (this.grid[x][y] != 29) continue;
                this.grid[x][y] = 9;
            }
        }
    }

    @Override
    public boolean hasHighscore() {
        return true;
    }

    @Override
    public boolean isMultiplayer() {
        return false;
    }

    @Override
    public int getID() {
        return 39;
    }
}

