/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.logic.mino;

import java.util.ArrayList;
import java.util.List;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.logic.LogicBase;
import mod.casinocraft.util.Card;
import net.minecraft.nbt.CompoundNBT;

public class LogicMinoPink
extends LogicBase {
    public List<Card> chips = new ArrayList<Card>();
    private int max_chips;
    private int alpha;
    private boolean chips_up;

    public LogicMinoPink(int tableID) {
        super(tableID, 4, 1);
    }

    @Override
    public void start2() {
        this.chips.clear();
    }

    @Override
    public void command(int action) {
        this.timeout = 0;
        if (action == -1) {
            if (this.selector.X > -1) {
                this.grid[this.selector.X][this.selector.Y] = this.activePlayer + 1;
                this.selector.set(-1, -1);
                this.spin();
            }
        } else if (this.grid[action][0] == 0) {
            this.selector.set(action, 0);
        }
    }

    @Override
    public void updateMotion() {
    }

    @Override
    public void updateLogic() {
        if (this.turnstate == 2) {
            ++this.timeout;
            if (this.timeout == (Integer)CasinoKeeper.config_timeout.get()) {
                this.spin();
            }
        }
        if (this.turnstate == 3) {
            if (this.chips_up) {
                this.chips.add(new Card(32 + this.RANDOM.nextInt(192), 64 + this.RANDOM.nextInt(160)));
                if (this.chips.size() == this.max_chips) {
                    this.chips_up = false;
                    this.alpha = 100;
                }
            } else {
                this.alpha -= 20;
                if (this.alpha <= 0) {
                    this.alpha = 100;
                    this.chips.remove(this.chips.size() - 1);
                    this.chips.remove(this.chips.size() - 1);
                    this.chips.remove(this.chips.size() - 1);
                    this.chips.remove(this.chips.size() - 1);
                    if (this.chips.size() <= 4) {
                        this.result();
                    }
                }
            }
        }
    }

    @Override
    public void load2(CompoundNBT compound) {
        this.chips = this.loadCardList(compound, 0);
        this.max_chips = compound.func_74762_e("maxchips");
        this.alpha = compound.func_74762_e("alpha");
        this.chips_up = compound.func_74767_n("chipsup");
    }

    @Override
    public CompoundNBT save2(CompoundNBT compound) {
        this.saveCardList(compound, 0, this.chips);
        compound.func_74768_a("maxchips", this.max_chips);
        compound.func_74768_a("alpha", this.alpha);
        compound.func_74757_a("chipsup", this.chips_up);
        return compound;
    }

    private void spin() {
        this.turnstate = 3;
        this.max_chips = 40 + this.RANDOM.nextInt(60);
        this.chips_up = true;
    }

    private void result() {
        this.turnstate = 4;
        this.hand = "Chips: " + this.chips.size();
        for (int i = 0; i < 4; ++i) {
            if (this.grid[i][0] <= 0) continue;
            this.reward[this.grid[i][0] - 1] = this.chips.size() == i + 1 ? 4 : 0;
        }
    }

    @Override
    public boolean hasHighscore() {
        return false;
    }

    @Override
    public boolean isMultiplayer() {
        return true;
    }

    @Override
    public int getID() {
        return 43;
    }
}

