/*
 * Decompiled with CFR 0.152.
 */
package mod.casinocraft.screen.blocks;

import com.mojang.blaze3d.platform.GlStateManager;
import mod.casinocraft.CasinoKeeper;
import mod.casinocraft.container.ContainerMachine;
import mod.casinocraft.network.MessageBlockServer;
import mod.casinocraft.network.MessageBoardServer;
import mod.casinocraft.network.MessageInventoryServer;
import mod.casinocraft.network.MessageStateServer;
import mod.casinocraft.system.CasinoPacketHandler;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ScreenSlotMachine
extends ContainerScreen<ContainerMachine> {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("casinocraft:textures/gui/inventory.png");
    private final PlayerInventory PLAYER;
    protected final ContainerMachine CONTAINER;
    private boolean didReset = false;

    public ScreenSlotMachine(ContainerMachine container, PlayerInventory player, ITextComponent name) {
        super((Container)container, player, name);
        this.PLAYER = player;
        this.CONTAINER = container;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (this.mouseRect(72, 3, 16, 16, mouseX, mouseY)) {
                this.CONTAINER.addBetLow(1);
                if (this.CONTAINER.getBetHigh() < this.CONTAINER.getBetLow()) {
                    this.CONTAINER.setBetHigh(this.CONTAINER.getBetLow());
                }
                CasinoPacketHandler.sendToServer(new MessageBoardServer(this.CONTAINER.getBetLow(), this.CONTAINER.getBetHigh(), this.CONTAINER.getTransferIn(), this.CONTAINER.getTransferOut(), this.CONTAINER.isCreative(), this.CONTAINER.getPos()));
            }
            if (this.mouseRect(72, 33, 16, 16, mouseX, mouseY) && this.CONTAINER.getBetLow() > 0) {
                this.CONTAINER.addBetLow(-1);
                CasinoPacketHandler.sendToServer(new MessageBoardServer(this.CONTAINER.getBetLow(), this.CONTAINER.getBetHigh(), this.CONTAINER.getTransferIn(), this.CONTAINER.getTransferOut(), this.CONTAINER.isCreative(), this.CONTAINER.getPos()));
            }
            if (this.mouseRect(88, 3, 16, 16, mouseX, mouseY)) {
                this.CONTAINER.addBetHigh(1);
                CasinoPacketHandler.sendToServer(new MessageBoardServer(this.CONTAINER.getBetLow(), this.CONTAINER.getBetHigh(), this.CONTAINER.getTransferIn(), this.CONTAINER.getTransferOut(), this.CONTAINER.isCreative(), this.CONTAINER.getPos()));
            }
            if (this.mouseRect(88, 33, 16, 16, mouseX, mouseY) && this.CONTAINER.getBetHigh() > 0) {
                this.CONTAINER.addBetHigh(-1);
                if (this.CONTAINER.getBetLow() > this.CONTAINER.getBetHigh()) {
                    this.CONTAINER.setBetLow(this.CONTAINER.getBetHigh());
                }
                CasinoPacketHandler.sendToServer(new MessageBoardServer(this.CONTAINER.getBetLow(), this.CONTAINER.getBetHigh(), this.CONTAINER.getTransferIn(), this.CONTAINER.getTransferOut(), this.CONTAINER.isCreative(), this.CONTAINER.getPos()));
            }
            if (this.mouseRect(43, 15, 18, 18, mouseX, mouseY)) {
                this.CONTAINER.setTransferIn(!this.CONTAINER.getTransferIn());
                CasinoPacketHandler.sendToServer(new MessageBoardServer(this.CONTAINER.getBetLow(), this.CONTAINER.getBetHigh(), this.CONTAINER.getTransferIn(), this.CONTAINER.getTransferOut(), this.CONTAINER.isCreative(), this.CONTAINER.getPos()));
                if (!this.CONTAINER.getTransferIn()) {
                    CasinoPacketHandler.sendToServer(new MessageBlockServer(this.CONTAINER.inventory.func_70301_a(0), this.CONTAINER.inventory.func_70301_a(1), this.CONTAINER.inventory.func_70301_a(4), this.CONTAINER.getBetStorage(), this.CONTAINER.getPos()));
                }
            }
            if (this.mouseRect(115, 15, 18, 18, mouseX, mouseY)) {
                this.CONTAINER.setTransferOut(!this.CONTAINER.getTransferOut());
                CasinoPacketHandler.sendToServer(new MessageBoardServer(this.CONTAINER.getBetLow(), this.CONTAINER.getBetHigh(), this.CONTAINER.getTransferIn(), this.CONTAINER.getTransferOut(), this.CONTAINER.isCreative(), this.CONTAINER.getPos()));
                if (!this.CONTAINER.getTransferOut()) {
                    CasinoPacketHandler.sendToServer(new MessageBlockServer(this.CONTAINER.inventory.func_70301_a(0), this.CONTAINER.inventory.func_70301_a(1), this.CONTAINER.inventory.func_70301_a(4), this.CONTAINER.getBetStorage(), this.CONTAINER.getPos()));
                }
            }
            if (((Boolean)CasinoKeeper.config_allowed_creative.get()).booleanValue() && this.mouseRect(110, 62, 16, 16, mouseX, mouseY)) {
                this.CONTAINER.setIsCreative(!this.CONTAINER.getIsCreative());
                CasinoPacketHandler.sendToServer(new MessageBoardServer(this.CONTAINER.getBetLow(), this.CONTAINER.getBetHigh(), this.CONTAINER.getTransferIn(), this.CONTAINER.getTransferOut(), this.CONTAINER.isCreative(), this.CONTAINER.getPos()));
            }
            if (this.mouseRect(50, 62, 16, 16, mouseX, mouseY)) {
                CasinoPacketHandler.sendToServer(new MessageStateServer(true, -2, this.CONTAINER.getPos()));
                this.didReset = true;
            }
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b("Key", 6.0f, 50.0f, 0x404040);
        this.font.func_211126_b("Game", 148.0f, 50.0f, 0x404040);
        if (this.CONTAINER.getBetStorage() > 0) {
            this.itemRenderer.func_175042_a(this.CONTAINER.getToken(), 62, 16);
            if (this.CONTAINER.getIsCreative()) {
                this.font.func_211126_b("x CRTV", 80.0f, 20.0f, 0x404040);
            } else {
                this.font.func_211126_b("x" + this.CONTAINER.getBetStorage(), 80.0f, 20.0f, 0x404040);
            }
            this.font.func_211126_b(" low:" + this.CONTAINER.getBetLow(), 72.0f, 62.0f, 0x404040);
            this.font.func_211126_b("high:" + this.CONTAINER.getBetHigh(), 71.0f, 70.0f, 0x404040);
        } else {
            this.font.func_211126_b("NO TOKEN", 65.0f, 20.0f, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURES);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.blit(i + 72, j + 3, 224, 0, 16, 16);
        this.blit(i + 72, j + 33, 208, 0, 16, 16);
        this.blit(i + 88, j + 3, 224, 0, 16, 16);
        this.blit(i + 88, j + 33, 208, 0, 16, 16);
        this.blit(i + 45, j + 15, 240, this.CONTAINER.getTransferIn() ? 16 : 0, 16, 16);
        this.blit(i + 115, j + 15, 240, this.CONTAINER.getTransferOut() ? 16 : 0, 16, 16);
        if (((Boolean)CasinoKeeper.config_allowed_creative.get()).booleanValue()) {
            this.blit(i + 110, j + 62, 176, this.CONTAINER.getIsCreative() ? 16 : 0, 16, 16);
        }
        this.blit(i + 50, j + 62, 176, this.didReset ? 48 : 32, 16, 16);
    }

    protected boolean mouseRect(int x, int y, int width, int height, double mouseX, double mouseY) {
        if ((double)(this.field_147003_i + x) < mouseX && mouseX < (double)(this.field_147003_i + x + width)) {
            return (double)(this.field_147009_r + y) < mouseY && mouseY < (double)(this.field_147009_r + y + height);
        }
        return false;
    }

    public void removed() {
        NonNullList inv = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < 6; ++i) {
            inv.set(i, (Object)this.CONTAINER.inventory.func_70301_a(i));
        }
        CasinoPacketHandler.sendToServer(new MessageInventoryServer((NonNullList<ItemStack>)inv, this.CONTAINER.getPos()));
        if (this.minecraft.field_71439_g != null) {
            ((ContainerMachine)this.field_147002_h).func_75134_a((PlayerEntity)this.minecraft.field_71439_g);
        }
    }
}

