/*
 * Decompiled with CFR 0.152.
 */
package panda.corn.init;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import panda.corn.init.ModItems;

@Mod.EventBusSubscriber(modid="simplecorn")
public class InsertChestLoot {
    private static final MethodHandle LOOT_TABLE_POOLS;
    private static final MethodHandle LOOT_POOL_ENTRIES;

    @SubscribeEvent
    public static void onLootTableLoaded(LootTableLoadEvent event) {
        int weight = 0;
        ResourceLocation res = event.getName();
        if (res.equals((Object)LootTables.field_186424_f)) {
            weight = 10;
        } else if (res.equals((Object)LootTables.field_186422_d)) {
            weight = 10;
        }
        if (weight > 0) {
            LootEntry entry = ItemLootEntry.func_216168_a((IItemProvider)ModItems.KERNELS).func_216085_b(0).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)new RandomValueRange(1.0f, 3.0f))).func_216081_b();
            InsertChestLoot.addToLootTable(event.getTable(), entry);
        }
    }

    public static void addToLootTable(LootTable table, LootEntry entry) {
        List<LootPool> pools = InsertChestLoot.getPools(table);
        if (!pools.isEmpty()) {
            InsertChestLoot.getEntries(pools.get(0)).add(entry);
        }
    }

    public static List<LootPool> getPools(LootTable table) {
        try {
            return LOOT_TABLE_POOLS.invokeExact(table);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public static List<LootEntry> getEntries(LootPool pool) {
        try {
            return LOOT_POOL_ENTRIES.invokeExact(pool);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        Field lootTablePools = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");
        Field lootPoolEntries = ObfuscationReflectionHelper.findField(LootPool.class, (String)"field_186453_a");
        try {
            LOOT_TABLE_POOLS = lookup.unreflectGetter(lootTablePools);
            LOOT_POOL_ENTRIES = lookup.unreflectGetter(lootPoolEntries);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

