/*
 * Decompiled with CFR 0.152.
 */
package panda.corn;

import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import panda.corn.ConfigSimpleCorn;
import panda.corn.entity.MyEntityFireworkRocket;
import panda.corn.events.GenericBreedHandler;
import panda.corn.events.GenericFollowHandler;
import panda.corn.events.ToolTipHandler;
import panda.corn.gen.ComponentCornField;
import panda.corn.gen.CornWorldGen;
import panda.corn.init.ModItems;
import panda.corn.other.ImmersiveEngineeringCompat;
import panda.corn.other.ThermalCompat;
import panda.corn.proxy.CommonProxy;

@Mod(modid="simplecorn", name="Simple Corn", version="2.5.6", dependencies="after:immersiveengineering", acceptedMinecraftVersions="[1.12.2]")
public class SimpleCorn {
    public static final String MODID = "simplecorn";
    public static final String NAME = "Simple Corn";
    public static final String VERSION = "2.5.6";
    private static boolean isIEInstalled;
    private static boolean isThermalInstalled;
    public Configuration config;
    @Mod.Instance(value="simplecorn")
    public static SimpleCorn instance;
    @SidedProxy(clientSide="panda.corn.proxy.ClientProxy", serverSide="panda.corn.proxy.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MapGenStructureIO.func_143031_a(ComponentCornField.class, (String)"Vicf");
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new CornWorldGen());
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        ConfigSimpleCorn.load(this.config);
        MinecraftForge.EVENT_BUS.register((Object)new GenericFollowHandler(EntityPig.class, ModItems.CORNCOB));
        MinecraftForge.EVENT_BUS.register((Object)new GenericBreedHandler(EntityPig.class, ModItems.CORNCOB));
        MinecraftForge.EVENT_BUS.register((Object)new GenericFollowHandler(EntityChicken.class, ModItems.KERNELS));
        MinecraftForge.EVENT_BUS.register((Object)new GenericBreedHandler(EntityChicken.class, ModItems.KERNELS));
        MinecraftForge.EVENT_BUS.register((Object)new ToolTipHandler());
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("simplecorn:entitypopfirework"), MyEntityFireworkRocket.class, (String)"entitypopfirework", (int)132, (Object)instance, (int)64, (int)3, (boolean)true);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (isIEInstalled) {
            ImmersiveEngineeringCompat.init();
        }
        if (isThermalInstalled) {
            ThermalCompat.init();
        }
        if (ConfigSimpleCorn.popcornFireworks) {
            RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(new ResourceLocation("minecraft:fireworks"));
        }
        MinecraftForge.addGrassSeed((ItemStack)new ItemStack(ModItems.KERNELS), (int)ConfigSimpleCorn.kernelWeight);
        VillagerRegistry.FARMER.getCareer(0).addTrade(1, new EntityVillager.ITradeList[]{new EntityVillager.EmeraldForItems(ModItems.CORNCOB, new EntityVillager.PriceInfo(18, 22))});
    }

    @Mod.EventHandler
    public static void onConstructionEvent(FMLConstructionEvent event) {
        isIEInstalled = Loader.isModLoaded((String)"immersiveengineering");
        isThermalInstalled = Loader.isModLoaded((String)"thermalfoundation");
    }
}

