/*
 * Decompiled with CFR 0.152.
 */
package panda.corn.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import panda.corn.ConfigSimpleCorn;
import panda.corn.init.ModBlocks;
import panda.corn.init.ModItems;

public class BlockCorn
extends BlockCrops
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)5);
    protected static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockCorn() {
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.CORN_MID) {
            world.func_175655_b(pos.func_177977_b(), true);
            world.func_175655_b(pos.func_177979_c(2), true);
        } else if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == ModBlocks.CORN) {
            world.func_175655_b(pos.func_177977_b(), true);
        }
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_185525_y(state) ? 0.2f : 0.0f;
    }

    protected void func_176475_e(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_180671_f(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.func_185527_x(state) != this.func_185526_g()) {
            drops.add((Object)new ItemStack(ModItems.KERNELS));
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return this.func_176196_c(world, pos);
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.func_185525_y(state) && world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j();
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState down = world.func_180495_p(pos.func_177977_b());
        return down.func_177230_c().canSustainPlant(down, (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)this);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_185524_e()});
    }

    protected PropertyInteger func_185524_e() {
        return AGE;
    }

    protected int func_185529_b(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)1, (int)2);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    protected Item func_149865_P() {
        return ModItems.CORNCOB;
    }

    public int func_185526_g() {
        return 4;
    }

    public int func_176201_c(IBlockState state) {
        return this.func_185527_x(state) == 5 ? 15 : this.func_185527_x(state);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModItems.KERNELS);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta <= 4) {
            return this.func_185528_e(meta);
        }
        if (meta == 9 || meta == 15) {
            return this.func_185528_e(5);
        }
        if (meta <= 7) {
            return ModBlocks.CORN_MID.func_185528_e(meta - 5);
        }
        if (meta == 10) {
            return ModBlocks.CORN_MID.func_185528_e(3);
        }
        if (meta == 8) {
            return ModBlocks.CORN_TOP.func_185528_e(0);
        }
        if (meta == 11) {
            return ModBlocks.CORN_TOP.func_185528_e(1);
        }
        return this.func_176223_P();
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.func_180650_b(worldIn, pos, state, rand);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ConfigSimpleCorn.useeasyharvesting && this.func_185525_y(state)) {
            return worldIn.func_175656_a(pos, this.func_176223_P());
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public IBlockState getNextState() {
        return ModBlocks.CORN_MID.func_176223_P();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.func_176475_e(worldIn, pos, state);
        if (worldIn.func_180495_p(pos) == state) {
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && this.checkFertile(worldIn, pos)) {
                boolean canGrow;
                boolean bl = canGrow = rand.nextInt(ConfigSimpleCorn.growChance) == 0;
                if (!this.func_185525_y(state)) {
                    if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)canGrow)) {
                        worldIn.func_175656_a(pos, this.func_185528_e(this.func_185527_x(state) + 1));
                        ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
                        if (this.func_185525_y(worldIn.func_180495_p(pos)) && this.getNextState() != null && worldIn.func_180495_p(pos = pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)this.getNextState(), (boolean)canGrow)) {
                            worldIn.func_175656_a(pos, this.getNextState());
                            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)this.getNextState(), (IBlockState)worldIn.func_180495_p(pos));
                        }
                    }
                } else if (this.getNextState() != null && worldIn.func_180495_p(pos = pos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)this.getNextState(), (boolean)canGrow)) {
                    worldIn.func_175656_a(pos, this.getNextState());
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)this.getNextState(), (IBlockState)worldIn.func_180495_p(pos));
                }
            }
        }
    }

    public boolean checkFertile(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().isFertile(world, pos.func_177977_b());
    }
}

