/*
 * Decompiled with CFR 0.152.
 */
package panda.corn.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityParticlePopcornFX
extends Particle {
    private int fireworkAge;
    protected NBTTagList fireworkExplosions;

    public EntityParticlePopcornFX(World parWorld, double parX, double parY, double parZ, double parMotionX, double parMotionY, double parMotionZ) {
        super(parWorld, parX, parY, parZ, parMotionX, parMotionY, parMotionZ);
        this.func_70536_a(192);
        this.field_70544_f = 2.0f;
        this.func_70538_b(1.0f, 1.0f, 1.0f);
        this.func_82338_g(1.0f);
        this.func_187114_a(600);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187130_j -= 0.0031999999284744265;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= 0.98;
        this.field_187130_j *= 0.98;
        this.field_187131_k *= 0.98;
        if (this.field_187132_l) {
            this.field_187129_i *= 0.7;
            this.field_187131_k *= 0.7;
        }
        if (this.fireworkAge == 0 && this.fireworkExplosions != null) {
            boolean flag = this.isFarFromCamera();
            boolean flag1 = false;
            if (this.fireworkExplosions.func_74745_c() >= 3) {
                flag1 = true;
            } else {
                for (int i = 0; i < this.fireworkExplosions.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = this.fireworkExplosions.func_150305_b(i);
                    if (nbttagcompound.func_74771_c("Type") != 1) continue;
                    flag1 = true;
                    break;
                }
            }
            SoundEvent soundevent1 = flag1 ? (flag ? SoundEvents.field_187628_bn : SoundEvents.field_187625_bm) : (flag ? SoundEvents.field_187622_bl : SoundEvents.field_187619_bk);
            this.field_187122_b.func_184134_a(this.field_187126_f, this.field_187127_g, this.field_187128_h, soundevent1, SoundCategory.AMBIENT, 20.0f, 0.95f + this.field_187136_p.nextFloat() * 0.1f, true);
        }
        if (this.fireworkAge % 2 == 0 && this.fireworkExplosions != null && this.fireworkAge / 2 < this.fireworkExplosions.func_74745_c()) {
            int k = this.fireworkAge / 2;
            NBTTagCompound nbttagcompound1 = this.fireworkExplosions.func_150305_b(k);
            byte l = nbttagcompound1.func_74771_c("Type");
            if (l == 1) {
                this.createBall(0.5, 4);
            } else if (l == 2) {
                this.createShaped(0.5, new double[][]{{0.0, 1.0}, {0.3455, 0.309}, {0.9511, 0.309}, {0.3796, -0.1265}, {0.6122, -0.8041}, {0.0, -0.3592}}, false);
            } else if (l == 3) {
                this.createShaped(0.5, new double[][]{{0.0, 0.2}, {0.2, 0.2}, {0.2, 0.6}, {0.6, 0.6}, {0.6, 0.2}, {0.2, 0.2}, {0.2, 0.0}, {0.4, 0.0}, {0.4, -0.6}, {0.2, -0.6}, {0.2, -0.4}, {0.0, -0.4}}, true);
            } else if (l == 4) {
                this.createBurst();
            } else {
                this.createBall(0.25, 2);
            }
        }
        ++this.fireworkAge;
        if (this.fireworkAge > this.field_70547_e) {
            this.func_187112_i();
        }
    }

    private boolean isFarFromCamera() {
        Minecraft minecraft = Minecraft.func_71410_x();
        return minecraft == null || minecraft.func_175606_aa() == null || minecraft.func_175606_aa().func_70092_e(this.field_187126_f, this.field_187127_g, this.field_187128_h) >= 256.0;
    }

    private void createParticle(double x, double y, double z, double vx, double vy, double vz) {
        EntityParticlePopcornFX particle = new EntityParticlePopcornFX(this.field_187122_b, x, y, z, vx, vy, vz);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
    }

    private void createBall(double speed, int size) {
        double d0 = this.field_187126_f;
        double d1 = this.field_187127_g;
        double d2 = this.field_187128_h;
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                for (int k = -size; k <= size; ++k) {
                    double d3 = (double)j + this.field_187136_p.nextGaussian() * 0.5;
                    double d4 = (double)i + (this.field_187136_p.nextDouble() - this.field_187136_p.nextDouble()) * 0.5;
                    double d5 = (double)k + (this.field_187136_p.nextDouble() - this.field_187136_p.nextDouble()) * 0.5;
                    double d6 = (double)MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5)) / speed + this.field_187136_p.nextGaussian() * 0.05;
                    this.createParticle(d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                    if (i == -size || i == size || j == -size || j == size) continue;
                    k += size * 2 - 1;
                }
            }
        }
    }

    private void createShaped(double speed, double[][] shape, boolean star) {
        double d0 = shape[0][0];
        double d1 = shape[0][1];
        this.createParticle(this.field_187126_f, this.field_187127_g, this.field_187128_h, d0 * speed, d1 * speed, 0.0);
        float f = this.field_187136_p.nextFloat() * (float)Math.PI;
        double d2 = star ? 0.034 : 0.34;
        for (int i = 0; i < 3; ++i) {
            double d3 = (double)f + (double)((float)i * (float)Math.PI) * d2;
            double d4 = d0;
            double d5 = d1;
            for (int j = 1; j < shape.length; ++j) {
                double d6 = shape[j][0];
                double d7 = shape[j][1];
                for (double d8 = 0.25; d8 <= 1.0; d8 += 0.25) {
                    double d9 = (d4 + (d6 - d4) * d8) * speed;
                    double d10 = (d5 + (d7 - d5) * d8) * speed;
                    double d11 = d9 * Math.sin(d3);
                    d9 *= Math.cos(d3);
                    for (double d12 = -1.0; d12 <= 1.0; d12 += 2.0) {
                        this.createParticle(this.field_187126_f, this.field_187127_g, this.field_187128_h, d9 * d12, d10, d11 * d12);
                    }
                }
                d4 = d6;
                d5 = d7;
            }
        }
    }

    private void createBurst() {
        double d0 = this.field_187136_p.nextGaussian() * 0.05;
        double d1 = this.field_187136_p.nextGaussian() * 0.05;
        for (int i = 0; i < 70; ++i) {
            double d2 = this.field_187129_i * 0.5 + this.field_187136_p.nextGaussian() * 0.15 + d0;
            double d3 = this.field_187131_k * 0.5 + this.field_187136_p.nextGaussian() * 0.15 + d1;
            double d4 = this.field_187130_j * 0.5 + this.field_187136_p.nextDouble() * 0.5;
            this.createParticle(this.field_187126_f, this.field_187127_g, this.field_187128_h, d2, d4, d3);
        }
    }

    public static Particle generatePopcornParticles(World parWorld, double parX, double parY, double parZ, double parMotionX, double parMotionY, double parMotionZ, NBTTagCompound nbt) {
        EntityParticlePopcornFX particle = new EntityParticlePopcornFX(parWorld, parX, parY, parZ, parMotionX, parMotionY, parMotionZ);
        particle.fireworkExplosions = nbt.func_150295_c("Explosions", 10);
        particle.fireworkAge = 0;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        return particle;
    }
}

