/*
 * Decompiled with CFR 0.152.
 */
package panda.corn.other;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import panda.corn.blocks.BlockCorn;
import panda.corn.init.ModBlocks;
import panda.corn.init.ModItems;

@WailaPlugin
public class HwylaPlugin
implements IWailaPlugin {
    public void register(IWailaRegistrar registrar) {
        registrar.registerBodyProvider(new IWailaDataProvider(){

            @Nonnull
            public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
                Block block = accessor.getBlock();
                int age = (Integer)accessor.getBlockState().func_177229_b((IProperty)BlockCorn.AGE);
                currenttip.clear();
                if (block == ModBlocks.CORN) {
                    if (age == 5) {
                        currenttip.add(0, HwylaPlugin.this.getPercent(7));
                    } else {
                        IBlockState above = accessor.getWorld().func_180495_p(accessor.getPosition().func_177984_a());
                        int upperAge = 0;
                        if (above instanceof BlockCorn) {
                            upperAge = (Integer)above.func_177229_b((IProperty)BlockCorn.AGE);
                        }
                        currenttip.add(0, HwylaPlugin.this.getPercent(age + upperAge));
                    }
                } else if (block == ModBlocks.CORN_MID) {
                    currenttip.add(0, HwylaPlugin.this.getPercent(age + 4));
                } else if (block == ModBlocks.CORN_TOP) {
                    currenttip.add(0, HwylaPlugin.this.getPercent(age + 6));
                }
                return currenttip;
            }
        }, BlockCorn.class);
        registrar.registerStackProvider(new IWailaDataProvider(){

            @Nonnull
            public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
                return new ItemStack(ModItems.CORNCOB);
            }
        }, BlockCorn.class);
    }

    private String getPercent(int age) {
        if (age == 7) {
            return I18n.func_135052_a((String)"hud.msg.growth", (Object[])new Object[0]) + " : " + I18n.func_135052_a((String)"hud.msg.mature", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"hud.msg.growth", (Object[])new Object[0]) + " : " + Math.round((double)age / 7.0 * 100.0) + " %";
    }
}

