/*
 * Decompiled with CFR 0.152.
 */
package cavern.block;

import cavern.core.Cavern;
import cavern.item.ItemAcresia;
import cavern.util.PlayerHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockAcresia
extends BlockCrops {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)4);

    public BlockAcresia() {
        this.func_149663_c("acresia");
        this.func_149647_a(Cavern.TAB_CAVERN);
    }

    protected Item func_149865_P() {
        return Item.func_150898_a((Block)this);
    }

    protected int getCropDamage() {
        return ItemAcresia.EnumType.FRUITS.getMetadata();
    }

    public ItemStack getCropItem() {
        return this.getCropItem(1);
    }

    public ItemStack getCropItem(int amount) {
        return new ItemStack(this.func_149865_P(), amount, this.getCropDamage());
    }

    protected Item func_149866_i() {
        return Item.func_150898_a((Block)this);
    }

    protected int getSeedDamage() {
        return ItemAcresia.EnumType.SEEDS.getMetadata();
    }

    public ItemStack getSeedItem() {
        return this.getSeedItem(1);
    }

    public ItemStack getSeedItem(int amount) {
        return new ItemStack(this.func_149866_i(), amount, this.getSeedDamage());
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() != Blocks.field_150357_h && (state.func_185915_l() || state.func_177230_c() instanceof BlockFarmland);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        BlockPos down = pos.func_177977_b();
        IBlockState soil = world.func_180495_p(down);
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)this);
    }

    protected PropertyInteger func_185524_e() {
        return AGE;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_185524_e()});
    }

    public int func_185526_g() {
        return 4;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_185525_y(state) ? this.getCropDamage() : this.getSeedDamage();
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return this.getCropItem();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float f;
        this.func_176475_e(world, pos, state);
        int i = this.func_185527_x(state);
        if (i < this.func_185526_g() && rand.nextInt((int)(25.0f / (f = BlockAcresia.getGrowthChance((Block)this, world, pos))) + 1) == 0) {
            world.func_180501_a(pos, this.func_185528_e(i + 1), 2);
        }
    }

    protected static float getGrowthChance(Block block, World world, BlockPos pos) {
        boolean flag1;
        float chance = 1.0f;
        BlockPos soil = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float rate = 0.0f;
                IBlockState state = world.func_180495_p(soil.func_177982_a(i, 0, j));
                if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, soil.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)block)) {
                    rate = 4.0f;
                    if (state.func_177230_c().isFertile(world, soil.func_177982_a(i, 0, j))) {
                        rate = 8.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    rate /= 4.0f;
                }
                chance += rate;
            }
        }
        BlockPos north = pos.func_177978_c();
        BlockPos south = pos.func_177968_d();
        BlockPos west = pos.func_177976_e();
        BlockPos east = pos.func_177974_f();
        boolean flag = block == world.func_180495_p(west).func_177230_c() || block == world.func_180495_p(east).func_177230_c();
        boolean bl = flag1 = block == world.func_180495_p(north).func_177230_c() || block == world.func_180495_p(south).func_177230_c();
        if (flag && flag1) {
            chance /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = block == world.func_180495_p(west.func_177978_c()).func_177230_c() || block == world.func_180495_p(east.func_177978_c()).func_177230_c() || block == world.func_180495_p(east.func_177968_d()).func_177230_c() || block == world.func_180495_p(west.func_177968_d()).func_177230_c();
            if (flag2) {
                chance /= 2.0f;
            }
        }
        return chance;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack held;
        if (!this.func_176473_a(world, pos, state, world.field_72995_K) && !(held = player.func_184586_b(hand)).func_190926_b() && held.func_77973_b() instanceof ItemShears) {
            if (!world.field_72995_K) {
                int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)held);
                ItemStack crop = this.getCropItem(4 + world.field_73012_v.nextInt(3) + fortune);
                EntityItem drop = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5, crop);
                drop.func_174867_a(10);
                world.func_72838_d((Entity)drop);
                world.func_180501_a(pos, this.func_185528_e(2), 2);
                held.func_77972_a(1, (EntityLivingBase)player);
                drop.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.25f);
                PlayerHelper.grantAdvancement(player, "harvest_acresia");
            }
            return true;
        }
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList ret = Lists.newArrayList();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_180651_a(state)));
        }
        int age = this.func_185527_x(state);
        if (age >= this.func_185526_g()) {
            for (int i = 0; i < 3 + fortune; ++i) {
                if (rand.nextInt(2 * this.func_185526_g()) > age) continue;
                ret.add(this.getSeedItem());
            }
        }
        return ret;
    }
}

