/*
 * Decompiled with CFR 0.152.
 */
package cavern.block;

import cavern.api.event.RandomiteDropEvent;
import cavern.block.CaveBlocks;
import cavern.block.FissureHelper;
import cavern.block.RandomiteHelper;
import cavern.config.GeneralConfig;
import cavern.core.Cavern;
import cavern.item.CaveItems;
import cavern.item.ItemCave;
import cavern.util.PlayerHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCave
extends Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockCave() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.AQUAMARINE_ORE)));
        this.func_149663_c("blockCave");
        this.func_149647_a(Cavern.TAB_CAVERN);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public EnumType getType(IBlockState state) {
        if (state == null || state.func_177230_c() != this || state.func_177227_a().isEmpty()) {
            state = this.func_176223_P();
        }
        return (EnumType)((Object)state.func_177229_b(VARIANT));
    }

    public int func_176201_c(IBlockState state) {
        return this.getType(state).getMetadata();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return this.getType(state).getMapColor();
    }

    public Material func_149688_o(IBlockState state) {
        return this.getType(state).getMaterial();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        return this.getType(state).getSoundType();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return this.getType(state).getBlockHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.getType(world.func_180495_p(pos)).getBlockHardness() * 5.0f;
    }

    public String getHarvestTool(IBlockState state) {
        return "pickaxe";
    }

    public int getHarvestLevel(IBlockState state) {
        return this.getType(state).getHarvestLevel();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.VALUES) {
            list.add((Object)type.getItemStack());
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (this.getType(state) == EnumType.RANDOMITE_ORE) {
            double d;
            if (world instanceof World && ((World)world).field_72995_K) {
                return;
            }
            ItemStack drop = ItemStack.field_190927_a;
            if (GeneralConfig.generousRandomite && fortune > 0 && ((d = (double)(fortune / Enchantments.field_185308_t.func_77325_b())) >= 1.0 || RANDOM.nextDouble() < d)) {
                drop = RandomiteHelper.getRandomItem();
            }
            if (drop.func_190926_b()) {
                ItemStack stack;
                RandomiteHelper.Category category = RandomiteHelper.Category.COMMON;
                if (RANDOM.nextInt(20) == 0) {
                    category = RandomiteHelper.Category.FOOD;
                }
                if (!(stack = RandomiteHelper.getDropItem(category)).func_190926_b()) {
                    if (fortune > 0 && stack.func_77985_e()) {
                        stack.func_190917_f(RANDOM.nextInt(fortune) + 1);
                    }
                    drop = stack;
                }
            }
            RandomiteDropEvent event = new RandomiteDropEvent(world, pos, state, drop);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.getDropItem().func_190926_b()) {
                drops.add((Object)event.getDropItem());
            }
            return;
        }
        super.getDrops(drops, world, pos, state, fortune);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        EnumType type;
        if (!world.field_72995_K && !world.restoringBlockSnapshots && (type = this.getType(state)) == EnumType.FISSURED_STONE) {
            EntityPlayer player = (EntityPlayer)this.harvesters.get();
            if (fortune > 0 && player != null) {
                FissureHelper.fireIntensiveEffect((EntityLivingBase)player, fortune);
            } else if (RANDOM.nextDouble() < 0.1) {
                FissureHelper.fireExplosion(world, pos);
            } else {
                FissureHelper.fireAreaEffect(world, pos, (EntityLivingBase)player);
            }
            return;
        }
        super.func_180653_a(world, pos, state, chance, fortune);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
        if (world.field_72995_K || player.field_71075_bZ.field_75098_d) {
            return;
        }
        switch (this.getType(state)) {
            case RANDOMITE_ORE: {
                PlayerHelper.grantAdvancement(player, "mine_randomite");
                break;
            }
            case FISSURED_STONE: {
                PlayerHelper.grantAdvancement(player, "mine_fissure");
                break;
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch (this.getType(state)) {
            case AQUAMARINE_ORE: 
            case HEXCITE_ORE: {
                return CaveItems.CAVE_ITEM;
            }
            case RANDOMITE_ORE: 
            case FISSURED_STONE: {
                return Items.field_190931_a;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        switch (this.getType(state)) {
            case AQUAMARINE_ORE: {
                return ItemCave.EnumType.AQUAMARINE.getMetadata();
            }
            case HEXCITE_ORE: {
                return ItemCave.EnumType.HEXCITE.getMetadata();
            }
        }
        return this.func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int amount = this.func_149745_a(random);
        switch (this.getType(state)) {
            case AQUAMARINE_ORE: 
            case HEXCITE_ORE: {
                if (fortune <= 0) break;
                return amount * (Math.max(random.nextInt(fortune + 2) - 1, 0) + 1);
            }
            case RANDOMITE_ORE: 
            case FISSURED_STONE: {
                return 0;
            }
        }
        return amount;
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        switch (this.getType(state)) {
            case RANDOMITE_ORE: 
            case AQUAMARINE_ORE: {
                return MathHelper.func_76136_a((Random)RANDOM, (int)1, (int)3);
            }
            case FISSURED_STONE: 
            case HEXCITE_ORE: {
                return MathHelper.func_76136_a((Random)RANDOM, (int)3, (int)5);
            }
        }
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public static enum EnumType implements IStringSerializable
    {
        AQUAMARINE_ORE(0, "aquamarine_ore", "oreAquamarine", MapColor.field_151648_G, Material.field_151576_e, SoundType.field_185851_d, 3.0f, 1),
        AQUAMARINE_BLOCK(1, "aquamarine_block", "blockAquamarine", MapColor.field_151648_G, Material.field_151573_f, SoundType.field_185852_e, 3.5f, 1),
        MAGNITE_ORE(2, "magnite_ore", "oreMagnite", MapColor.field_151645_D, Material.field_151576_e, SoundType.field_185851_d, 3.0f, 2),
        MAGNITE_BLOCK(3, "magnite_block", "blockMagnite", MapColor.field_151645_D, Material.field_151573_f, SoundType.field_185852_e, 2.5f, 2),
        RANDOMITE_ORE(4, "randomite_ore", "oreRandomite", MapColor.field_151678_z, Material.field_151576_e, SoundType.field_185851_d, 4.0f, 1),
        HEXCITE_ORE(5, "hexcite_ore", "oreHexcite", MapColor.field_151666_j, Material.field_151576_e, SoundType.field_185851_d, 3.0f, 2),
        HEXCITE_BLOCK(6, "hexcite_block", "blockHexcite", MapColor.field_151666_j, Material.field_151573_f, SoundType.field_185852_e, 3.5f, 2),
        FISSURED_STONE(7, "fissured_stone", "stone.stone", MapColor.field_151665_m, Material.field_151576_e, SoundType.field_185851_d, 1.0f, 0);

        public static final EnumType[] VALUES;
        private final int meta;
        private final String name;
        private final String translationKey;
        private final MapColor mapColor;
        private final Material material;
        private final SoundType soundType;
        private final float blockHardness;
        private final int harvestLevel;

        private EnumType(int meta, String name, String key, MapColor color, Material material, SoundType soundType, float hardness, int harvestLevel) {
            this.meta = meta;
            this.name = name;
            this.translationKey = key;
            this.mapColor = color;
            this.material = material;
            this.soundType = soundType;
            this.blockHardness = hardness;
            this.harvestLevel = harvestLevel;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public Material getMaterial() {
            return this.material;
        }

        public SoundType getSoundType() {
            return this.soundType;
        }

        public float getBlockHardness() {
            return this.blockHardness;
        }

        public int getHarvestLevel() {
            return this.harvestLevel;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public ItemStack getItemStack() {
            return this.getItemStack(1);
        }

        public ItemStack getItemStack(int amount) {
            return new ItemStack((Block)CaveBlocks.CAVE_BLOCK, amount, this.getMetadata());
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= VALUES.length) {
                meta = 0;
            }
            return VALUES[meta];
        }

        public static EnumType byItemStack(ItemStack stack) {
            return EnumType.byMetadata(stack.func_190926_b() ? 0 : stack.func_77960_j());
        }

        static {
            VALUES = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.VALUES[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

