/*
 * Decompiled with CFR 0.152.
 */
package cavern.block;

import cavern.api.CavernAPI;
import cavern.api.IPortalCache;
import cavern.client.gui.GuiMiningRecords;
import cavern.client.gui.GuiRegeneration;
import cavern.config.CavernConfig;
import cavern.config.GeneralConfig;
import cavern.core.Cavern;
import cavern.network.CaveNetworkRegistry;
import cavern.network.client.RegenerationGuiMessage;
import cavern.plugin.MCEPlugin;
import cavern.stats.MinerRank;
import cavern.stats.MinerStats;
import cavern.stats.PortalCache;
import cavern.util.CaveUtils;
import cavern.world.CaveDimensions;
import cavern.world.TeleporterCavern;
import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class BlockPortalCavern
extends BlockPortal {
    public BlockPortalCavern() {
        this.func_149663_c("portal.cavern");
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149675_a(false);
        this.func_149722_s();
        this.func_149649_H();
        this.func_149647_a(Cavern.TAB_CAVERN);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
    }

    public boolean func_176548_d(World world, BlockPos pos) {
        if (CavernAPI.dimension.isMirageWorlds(world.field_73011_w.func_186058_p())) {
            return false;
        }
        Size size = new Size(world, pos, EnumFacing.Axis.X);
        if (size.isValid() && size.portalBlockCount == 0) {
            size.placePortalBlocks();
            return true;
        }
        size = new Size(world, pos, EnumFacing.Axis.Z);
        if (size.isValid() && size.portalBlockCount == 0) {
            size.placePortalBlocks();
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos pos2) {
        Size size;
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (axis == EnumFacing.Axis.X) {
            Size size2 = new Size(world, pos, EnumFacing.Axis.X);
            if (!size2.isValid() || size2.portalBlockCount < size2.width * size2.height) {
                world.func_175698_g(pos);
            }
        } else if (!(axis != EnumFacing.Axis.Z || (size = new Size(world, pos, EnumFacing.Axis.Z)).isValid() && size.portalBlockCount >= size.width * size.height)) {
            world.func_175698_g(pos);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!GeneralConfig.portalMenu) {
            return true;
        }
        if (Loader.isModLoaded((String)"mceconomy3") && this.openShop(world, pos, state, player, hand, side)) {
            return true;
        }
        if (world.field_73011_w.func_186058_p() == this.getDimension()) {
            if (world.field_72995_K) {
                this.openMiningRecords(world, pos, state, player, hand, side);
            }
            return true;
        }
        if (Cavern.proxy.isSinglePlayer() && world.field_72995_K) {
            this.openRegeneration(world, pos, state, player, hand, side);
        } else if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (playerMP.field_71133_b.func_184103_al().func_152596_g(playerMP.func_146103_bH())) {
                CaveNetworkRegistry.sendTo(new RegenerationGuiMessage(RegenerationGuiMessage.EnumType.OPEN), playerMP);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void openMiningRecords(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side) {
        FMLClientHandler.instance().showGuiScreen((Object)new GuiMiningRecords());
    }

    @SideOnly(value=Side.CLIENT)
    public void openRegeneration(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side) {
        GuiRegeneration regeneration = new GuiRegeneration();
        regeneration.dimensions.add(this.getDimension());
        FMLClientHandler.instance().showGuiScreen((Object)regeneration);
    }

    public boolean openShop(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side) {
        ItemStack held = player.func_184586_b(hand);
        return CaveUtils.isItemPickaxe(held) && MCEPlugin.openShop(MCEPlugin.getPortalShop(), world, player, pos);
    }

    @Nullable
    public DimensionType getDimension() {
        return CaveDimensions.CAVERN;
    }

    public boolean isEntityInCave(Entity entity) {
        return CavernAPI.dimension.isInCavern(entity);
    }

    public boolean isTriggerItem(ItemStack stack) {
        if (!CavernConfig.triggerItems.isEmpty()) {
            return CavernConfig.triggerItems.hasItemStack(stack);
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151166_bC) {
            return true;
        }
        for (ItemStack dictStack : OreDictionary.getOres((String)"gemEmerald", (boolean)false)) {
            if (!CaveUtils.isItemEqual(stack, dictStack)) continue;
            return true;
        }
        return false;
    }

    public MinerRank getMinerRank() {
        return MinerRank.BEGINNER;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (world.field_72995_K || this.getDimension() == null) {
            return;
        }
        if (entity.field_70128_L || entity.func_70093_af() || entity.func_184218_aH() || entity.func_184207_aI() || !entity.func_184222_aU() || entity instanceof IProjectile) {
            return;
        }
        if (entity.field_71088_bW <= 0) {
            ResourceLocation key = this.getRegistryName();
            IPortalCache cache = PortalCache.get((ICapabilityProvider)entity);
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            DimensionType dimOld = world.field_73011_w.func_186058_p();
            DimensionType dimNew = this.isEntityInCave(entity) ? cache.getLastDim(key) : this.getDimension();
            WorldServer worldNew = server.func_71218_a(dimNew.func_186068_a());
            TeleporterCavern teleporter = new TeleporterCavern(worldNew, this);
            BlockPos prevPos = entity.func_180425_c();
            entity.field_71088_bW = entity.func_82147_ab();
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                if (!player.field_71075_bZ.field_75098_d && MinerStats.get(player).getRank() < this.getMinerRank().getRank()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("cavern.message.portal.rank", new Object[]{new TextComponentTranslation(this.getMinerRank().getTranslationKey(), new Object[0])}), true);
                    return;
                }
            }
            cache.setLastDim(key, dimOld);
            cache.setLastPos(key, dimOld, prevPos);
            BlockPattern.PatternHelper pattern = this.func_181089_f(world, pos);
            double d0 = pattern.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)pattern.func_181117_a().func_177952_p() : (double)pattern.func_181117_a().func_177958_n();
            double d1 = pattern.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? entity.field_70161_v : entity.field_70165_t;
            d1 = Math.abs(MathHelper.func_181160_c((double)(d1 - (double)(pattern.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)pattern.func_181118_d())));
            double d2 = MathHelper.func_181160_c((double)(entity.field_70163_u - 1.0), (double)pattern.func_181117_a().func_177956_o(), (double)(pattern.func_181117_a().func_177956_o() - pattern.func_181119_e()));
            cache.setLastPortalVec(new Vec3d(d1, d2, 0.0));
            cache.setTeleportDirection(pattern.func_177669_b());
            entity.changeDimension(dimNew.func_186068_a(), (ITeleporter)teleporter);
        } else {
            entity.field_71088_bW = entity.func_82147_ab();
        }
    }

    public BlockPattern.PatternHelper func_181089_f(World world, BlockPos pos) {
        EnumFacing.Axis axis = EnumFacing.Axis.Z;
        Size size = new Size(world, pos, EnumFacing.Axis.X);
        LoadingCache cache = BlockPattern.func_181627_a((World)world, (boolean)true);
        if (!size.isValid()) {
            axis = EnumFacing.Axis.X;
            size = new Size(world, pos, EnumFacing.Axis.Z);
        }
        if (!size.isValid()) {
            return new BlockPattern.PatternHelper(pos, EnumFacing.NORTH, EnumFacing.UP, cache, 1, 1, 1);
        }
        int[] values = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing facing = size.rightDir.func_176735_f();
        BlockPos blockpos = size.bottomLeft.func_177981_b(size.getHeight() - 1);
        for (EnumFacing.AxisDirection direction : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper pattern = new BlockPattern.PatternHelper(facing.func_176743_c() == direction ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)direction, (EnumFacing.Axis)axis), EnumFacing.UP, cache, size.getWidth(), size.getHeight(), 1);
            for (int i = 0; i < size.getWidth(); ++i) {
                for (int j = 0; j < size.getHeight(); ++j) {
                    BlockWorldState state = pattern.func_177670_a(i, j, 1);
                    if (state.func_177509_a() == null || state.func_177509_a().func_185904_a() == Material.field_151579_a) continue;
                    int n = direction.ordinal();
                    values[n] = values[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection axis1 = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection direction : EnumFacing.AxisDirection.values()) {
            if (values[direction.ordinal()] >= values[axis1.ordinal()]) continue;
            axis1 = direction;
        }
        return new BlockPattern.PatternHelper(facing.func_176743_c() == axis1 ? blockpos : blockpos.func_177967_a(size.rightDir, size.getWidth() - 1), EnumFacing.func_181076_a((EnumFacing.AxisDirection)axis1, (EnumFacing.Axis)axis), EnumFacing.UP, cache, size.getWidth(), size.getHeight(), 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)this);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.getDimension() != null) {
            super.func_149666_a(tab, list);
        }
    }

    public class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private IBlockState portalFrame;

        public Size(World world, BlockPos pos, EnumFacing.Axis axis) {
            this.world = world;
            this.axis = axis;
            if (axis == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = pos;
            while (pos.func_177956_o() > blockpos.func_177956_o() - 21 && pos.func_177956_o() > 0 && this.isEmptyBlock(world.func_180495_p(pos.func_177977_b()))) {
                pos = pos.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, EnumFacing face) {
            BlockPos pos1;
            int i;
            for (i = 0; i < 22 && this.isEmptyBlock(this.world.func_180495_p(pos1 = pos.func_177967_a(face, i))) && this.isFrameBlock(this.world.func_180495_p(pos1.func_177977_b())); ++i) {
            }
            return this.isFrameBlock(this.world.func_180495_p(pos.func_177967_a(face, i))) ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            int i;
            this.height = 0;
            block0: while (this.height < 21) {
                for (i = 0; i < this.width; ++i) {
                    BlockPos pos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    IBlockState state = this.world.func_180495_p(pos);
                    if (!this.isEmptyBlock(state)) break block0;
                    if (state.func_177230_c() == BlockPortalCavern.this) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? !this.isFrameBlock(this.world.func_180495_p(pos.func_177972_a(this.leftDir))) : i == this.width - 1 && !this.isFrameBlock(this.world.func_180495_p(pos.func_177972_a(this.rightDir)))) break block0;
                }
                ++this.height;
            }
            for (i = 0; i < this.width; ++i) {
                if (this.isFrameBlock(this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height)))) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean isEmptyBlock(IBlockState state) {
            return state.func_185904_a() == Material.field_151579_a || state.func_177230_c() == BlockPortalCavern.this;
        }

        protected boolean isFrameBlock(IBlockState state) {
            if (this.portalFrame == null) {
                if (state.func_177230_c() == Blocks.field_150341_Y) {
                    this.portalFrame = Blocks.field_150341_Y.func_176223_P();
                } else if (state.func_177230_c() == Blocks.field_150417_aV && state.func_177230_c().func_176201_c(state) == BlockStoneBrick.field_176250_M) {
                    this.portalFrame = Blocks.field_150417_aV.func_176223_P().func_177226_a((IProperty)BlockStoneBrick.field_176249_a, (Comparable)BlockStoneBrick.EnumType.MOSSY);
                }
            }
            return CaveUtils.areBlockStatesEqual(this.portalFrame, state);
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos pos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(pos.func_177981_b(j), BlockPortalCavern.this.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
                }
            }
        }
    }
}

