/*
 * Decompiled with CFR 0.152.
 */
package cavern.block;

import cavern.api.CavernAPI;
import cavern.block.BlockPortalCavern;
import cavern.config.HugeCavernConfig;
import cavern.stats.MinerRank;
import cavern.util.CaveUtils;
import cavern.world.CaveDimensions;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DimensionType;
import net.minecraftforge.oredict.OreDictionary;

public class BlockPortalHugeCavern
extends BlockPortalCavern {
    public BlockPortalHugeCavern() {
        this.func_149663_c("portal.hugeCavern");
    }

    @Override
    public DimensionType getDimension() {
        return CaveDimensions.HUGE_CAVERN;
    }

    @Override
    public boolean isEntityInCave(Entity entity) {
        return CavernAPI.dimension.isInHugeCavern(entity);
    }

    @Override
    public boolean isTriggerItem(ItemStack stack) {
        if (!HugeCavernConfig.triggerItems.isEmpty()) {
            return HugeCavernConfig.triggerItems.hasItemStack(stack);
        }
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151045_i) {
            return true;
        }
        for (ItemStack dictStack : OreDictionary.getOres((String)"gemDiamond", (boolean)false)) {
            if (!CaveUtils.isItemEqual(stack, dictStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MinerRank getMinerRank() {
        return CaveDimensions.CAVERN == null ? MinerRank.BEGINNER : MinerRank.IRON_MINER;
    }
}

