/*
 * Decompiled with CFR 0.152.
 */
package cavern.block;

import cavern.block.BlockAcresia;
import cavern.block.BlockCave;
import cavern.block.BlockLeavesPerverted;
import cavern.block.BlockLogPerverted;
import cavern.block.BlockMirageBookshelf;
import cavern.block.BlockPortalAquaCavern;
import cavern.block.BlockPortalCavern;
import cavern.block.BlockPortalHugeCavern;
import cavern.block.BlockPortalMirageWorlds;
import cavern.block.BlockSaplingPerverted;
import cavern.block.BlockSlipperyIce;
import cavern.config.DisplayConfig;
import cavern.item.CaveItems;
import cavern.item.ItemAcresia;
import cavern.item.ItemBlockCave;
import cavern.item.ItemBlockPerverted;
import cavern.item.ItemCave;
import cavern.item.ItemPortalCave;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CaveBlocks {
    private static final List<Block> BLOCKS = Lists.newArrayList();
    public static final BlockPortalCavern CAVERN_PORTAL = new BlockPortalCavern();
    public static final BlockPortalHugeCavern HUGE_CAVERN_PORTAL = new BlockPortalHugeCavern();
    public static final BlockPortalAquaCavern AQUA_CAVERN_PORTAL = new BlockPortalAquaCavern();
    public static final BlockPortalMirageWorlds MIRAGE_PORTAL = new BlockPortalMirageWorlds();
    public static final BlockCave CAVE_BLOCK = new BlockCave();
    public static final BlockAcresia ACRESIA = new BlockAcresia();
    public static final BlockLogPerverted PERVERTED_LOG = new BlockLogPerverted();
    public static final BlockLeavesPerverted PERVERTED_LEAVES = new BlockLeavesPerverted();
    public static final BlockSaplingPerverted PERVERTED_SAPLING = new BlockSaplingPerverted();
    public static final BlockSlipperyIce SLIPPERY_ICE = new BlockSlipperyIce();
    public static final BlockMirageBookshelf MIRAGE_BOOKSHELF = new BlockMirageBookshelf();

    public static List<Block> getBlocks() {
        return Collections.unmodifiableList(BLOCKS);
    }

    public static void registerBlock(IForgeRegistry<Block> registry, Block block) {
        BLOCKS.add(block);
        registry.register((IForgeRegistryEntry)block);
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        CaveBlocks.registerBlock(registry, (Block)CAVERN_PORTAL.setRegistryName("cavern_portal"));
        CaveBlocks.registerBlock(registry, (Block)HUGE_CAVERN_PORTAL.setRegistryName("huge_cavern_portal"));
        CaveBlocks.registerBlock(registry, (Block)AQUA_CAVERN_PORTAL.setRegistryName("aqua_cavern_portal"));
        CaveBlocks.registerBlock(registry, (Block)MIRAGE_PORTAL.setRegistryName("mirage_portal"));
        CaveBlocks.registerBlock(registry, (Block)CAVE_BLOCK.setRegistryName("cave_block"));
        CaveBlocks.registerBlock(registry, (Block)ACRESIA.setRegistryName("acresia"));
        CaveBlocks.registerBlock(registry, (Block)PERVERTED_LOG.setRegistryName("perverted_log"));
        CaveBlocks.registerBlock(registry, (Block)PERVERTED_LEAVES.setRegistryName("perverted_leaves"));
        CaveBlocks.registerBlock(registry, (Block)PERVERTED_SAPLING.setRegistryName("perverted_sapling"));
        CaveBlocks.registerBlock(registry, (Block)SLIPPERY_ICE.setRegistryName("slippery_ice"));
        CaveBlocks.registerBlock(registry, (Block)MIRAGE_BOOKSHELF.setRegistryName("mirage_bookshelf"));
    }

    public static void registerItemBlocks(IForgeRegistry<Item> registry) {
        CaveItems.registerItem(registry, (Item)new ItemPortalCave((Block)CAVERN_PORTAL));
        CaveItems.registerItem(registry, (Item)new ItemPortalCave((Block)HUGE_CAVERN_PORTAL));
        CaveItems.registerItem(registry, (Item)new ItemPortalCave((Block)AQUA_CAVERN_PORTAL));
        CaveItems.registerItem(registry, (Item)new ItemPortalCave((Block)MIRAGE_PORTAL));
        CaveItems.registerItem(registry, (Item)new ItemBlockCave(CAVE_BLOCK));
        CaveItems.registerItem(registry, (Item)new ItemAcresia((Block)ACRESIA));
        CaveItems.registerItem(registry, (Item)new ItemBlockPerverted((Block)PERVERTED_LOG, Blocks.field_150364_r));
        CaveItems.registerItem(registry, (Item)new ItemBlockPerverted((Block)PERVERTED_LEAVES, (Block)Blocks.field_150362_t));
        CaveItems.registerItem(registry, (Item)new ItemBlockPerverted((Block)PERVERTED_SAPLING, Blocks.field_150345_g));
        CaveItems.registerItem(registry, (Item)new ItemBlock((Block)SLIPPERY_ICE).setRegistryName(SLIPPERY_ICE.getRegistryName()));
        CaveItems.registerItem(registry, (Item)new ItemBlock((Block)MIRAGE_BOOKSHELF).setRegistryName(MIRAGE_BOOKSHELF.getRegistryName()));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels() {
        ModelLoader.setCustomStateMapper((Block)CAVE_BLOCK, (IStateMapper)new StateMap.Builder().func_178440_a(BlockCave.VARIANT).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)PERVERTED_LOG, (IStateMapper)new StateMap.Builder().func_178440_a((IProperty)BlockOldLog.field_176301_b).func_178439_a("_log").func_178441_a());
        ModelLoader.setCustomStateMapper((Block)PERVERTED_LEAVES, (IStateMapper)new StateMap.Builder().func_178440_a((IProperty)BlockOldLeaf.field_176239_P).func_178439_a("_leaves").func_178442_a(new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)PERVERTED_SAPLING, (IStateMapper)new StateMap.Builder().func_178440_a((IProperty)BlockSapling.field_176480_a).func_178439_a("_sapling").func_178441_a());
        CaveBlocks.registerModel((Block)CAVERN_PORTAL);
        CaveBlocks.registerModel((Block)HUGE_CAVERN_PORTAL);
        CaveBlocks.registerModel((Block)AQUA_CAVERN_PORTAL);
        CaveBlocks.registerModel((Block)MIRAGE_PORTAL);
        CaveBlocks.registerModels(CAVE_BLOCK, "aquamarine_ore", "aquamarine_block", "magnite_ore", "magnite_block", "randomite_ore", "hexcite_ore", "hexcite_block", "fissured_stone");
        CaveBlocks.registerModels((Block)ACRESIA, "acresia_seeds", "acresia_fruits");
        CaveBlocks.registerVanillaModels((Block)PERVERTED_LOG, "oak_log", "spruce_log", "birch_log", "jungle_log");
        CaveBlocks.registerVanillaModels((Block)PERVERTED_LEAVES, "oak_leaves", "spruce_leaves", "birch_leaves", "jungle_leaves");
        CaveBlocks.registerVanillaModels((Block)PERVERTED_SAPLING, "oak_sapling", "spruce_sapling", "birch_sapling", "jungle_sapling", "acacia_sapling", "dark_oak_sapling");
        CaveBlocks.registerModel((Block)SLIPPERY_ICE);
        CaveBlocks.registerModel((Block)MIRAGE_BOOKSHELF);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Block block) {
        CaveItems.registerModel(Item.func_150898_a((Block)block));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModel(Block block, String modelName) {
        CaveItems.registerModel(Item.func_150898_a((Block)block), modelName);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerModels(Block block, String ... modelNames) {
        CaveItems.registerModels(Item.func_150898_a((Block)block), modelNames);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerVanillaModel(Block block, String modelName) {
        CaveItems.registerVanillaModel(Item.func_150898_a((Block)block), modelName);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerVanillaModels(Block block, String ... modelNames) {
        CaveItems.registerVanillaModels(Item.func_150898_a((Block)block), modelNames);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockColors(BlockColors colors) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        colors.func_186722_a((state, world, pos, tintIndex) -> {
            PERVERTED_LEAVES.func_150122_b(mc.field_71474_y.field_74347_j);
            BlockPlanks.EnumType type = (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P);
            switch (type) {
                case SPRUCE: {
                    return ColorizerFoliage.func_77466_a();
                }
                case BIRCH: {
                    return ColorizerFoliage.func_77469_b();
                }
            }
            if (world != null && pos != null) {
                BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos);
            }
            return ColorizerFoliage.func_77468_c();
        }, new Block[]{PERVERTED_LEAVES});
        colors.func_186722_a((state, world, pos, tintIndex) -> DisplayConfig.slipperyIceCustomColor ? 0xEFFAFF : -1, new Block[]{SLIPPERY_ICE});
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemBlockColors(BlockColors blockColors, ItemColors itemColors) {
        itemColors.func_186731_a((stack, tintIndex) -> {
            IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(state, null, null, tintIndex);
        }, new Block[]{PERVERTED_LEAVES, SLIPPERY_ICE});
    }

    public static void registerOreDicts() {
        OreDictionary.registerOre((String)"oreAquamarine", (ItemStack)BlockCave.EnumType.AQUAMARINE_ORE.getItemStack());
        OreDictionary.registerOre((String)"blockAquamarine", (ItemStack)BlockCave.EnumType.AQUAMARINE_BLOCK.getItemStack());
        OreDictionary.registerOre((String)"oreMagnite", (ItemStack)BlockCave.EnumType.MAGNITE_ORE.getItemStack());
        OreDictionary.registerOre((String)"blockMagnite", (ItemStack)BlockCave.EnumType.MAGNITE_BLOCK.getItemStack());
        OreDictionary.registerOre((String)"oreRandomite", (ItemStack)BlockCave.EnumType.RANDOMITE_ORE.getItemStack());
        OreDictionary.registerOre((String)"oreHexcite", (ItemStack)BlockCave.EnumType.HEXCITE_ORE.getItemStack());
        OreDictionary.registerOre((String)"blockHexcite", (ItemStack)BlockCave.EnumType.HEXCITE_BLOCK.getItemStack());
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)PERVERTED_LEAVES, 1, Short.MAX_VALUE));
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack((Block)PERVERTED_SAPLING, 1, Short.MAX_VALUE));
    }

    public static void registerSmeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)BlockCave.EnumType.AQUAMARINE_ORE.getItemStack(), (ItemStack)ItemCave.EnumType.AQUAMARINE.getItemStack(), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)BlockCave.EnumType.MAGNITE_ORE.getItemStack(), (ItemStack)ItemCave.EnumType.MAGNITE_INGOT.getItemStack(), (float)0.7f);
        GameRegistry.addSmelting((ItemStack)BlockCave.EnumType.HEXCITE_ORE.getItemStack(), (ItemStack)ItemCave.EnumType.HEXCITE.getItemStack(), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)PERVERTED_LOG, 1, Short.MAX_VALUE), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.0f);
    }
}

