/*
 * Decompiled with CFR 0.152.
 */
package cavern.block;

import cavern.config.GeneralConfig;
import cavern.item.ItemCave;
import cavern.util.CaveUtils;
import cavern.util.WeightedItemStack;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.oredict.OreDictionary;

public class RandomiteHelper {
    private static final Random RANDOM = new Random();

    public static void refreshItems() {
        TreeSet oreNames = Sets.newTreeSet();
        String[] targetNames = new String[]{"treeSapling", "sugarcane", "vine", "slimeball", "enderpearl", "bone", "gunpowder", "string", "torch"};
        String[] targetPrefixes = new String[]{"gem", "ingot", "nugget", "dust", "crop"};
        for (String name : targetNames) {
            if (!OreDictionary.doesOreNameExist((String)name)) continue;
            oreNames.add(name);
        }
        for (String name : OreDictionary.getOreNames()) {
            for (String prefix : targetPrefixes) {
                if (!name.startsWith(prefix) || name.length() == prefix.length() || !Character.isUpperCase(name.charAt(prefix.length()))) continue;
                oreNames.add(name);
            }
        }
        Category.COMMON.getItems().clear();
        for (String name : oreNames) {
            int weight = 30;
            if (name.startsWith("gem") || name.startsWith("ingot") || name.startsWith("nugget") || name.startsWith("dust")) {
                weight = 50;
            } else if (name.equals("treeSapling")) {
                weight = 10;
            }
            for (ItemStack stack : OreDictionary.getOres((String)name, (boolean)false)) {
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    NonNullList list = NonNullList.func_191196_a();
                    stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, list);
                    for (ItemStack subStack : list) {
                        RandomiteHelper.addItem(Category.COMMON, subStack, weight);
                    }
                    continue;
                }
                RandomiteHelper.addItem(Category.COMMON, stack, weight);
            }
        }
        Category.FOOD.getItems().clear();
        for (Item item : Item.field_150901_e) {
            if (item == null || item == Items.field_190931_a || item instanceof ItemBlock) continue;
            if (item instanceof ItemFood) {
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(CreativeTabs.field_78027_g, list);
                for (ItemStack stack : list) {
                    RandomiteHelper.addItem(Category.FOOD, stack, 10);
                }
                continue;
            }
            if (!(item instanceof ItemArrow)) continue;
            RandomiteHelper.addItem(Category.COMMON, new ItemStack(item), 10);
        }
        RandomiteHelper.addItem(Category.COMMON, ItemCave.EnumType.MINER_ORB.getItemStack(), 1);
    }

    public static boolean addItem(Category category, ItemStack stack, int weight) {
        if (stack.func_190926_b() || GeneralConfig.randomiteExcludeItems.hasItemStack(stack)) {
            return false;
        }
        return category.getItems().add((Object)new WeightedItemStack(stack, Math.max(weight, 1)));
    }

    public static ItemStack getDropItem(Category category) {
        NonNullList<WeightedItemStack> items = category.getItems();
        if (items.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        int totalWeight = WeightedRandom.func_76272_a(items);
        WeightedItemStack item = (WeightedItemStack)WeightedRandom.func_180166_a(items, (int)RANDOM.nextInt(totalWeight));
        return item != null ? item.getItemStack() : ItemStack.field_190927_a;
    }

    public static ItemStack getRandomItem() {
        for (int i = 0; i < 20; ++i) {
            Item item = (Item)Item.field_150901_e.func_186801_a(RANDOM);
            if (item == null || item == Items.field_190931_a) continue;
            NonNullList list = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, list);
            ItemStack stack = CaveUtils.getRandomObject(list, ItemStack.field_190927_a);
            if (stack.func_190926_b() || GeneralConfig.randomiteExcludeItems.hasItemStack(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static enum Category {
        COMMON,
        FOOD;

        private final NonNullList<WeightedItemStack> items = NonNullList.func_191196_a();

        public NonNullList<WeightedItemStack> getItems() {
            return this.items;
        }
    }
}

