/*
 * Decompiled with CFR 0.152.
 */
package cavern.capability;

import cavern.api.IMinerStats;
import cavern.api.IMiningData;
import cavern.api.IPlayerData;
import cavern.api.IPortalCache;
import cavern.capability.CapabilityMagicBook;
import cavern.capability.CapabilityMagicStorage;
import cavern.capability.CapabilityMinerStats;
import cavern.capability.CapabilityMiningAssistUnit;
import cavern.capability.CapabilityMiningData;
import cavern.capability.CapabilityOreCompass;
import cavern.capability.CapabilityPlayerData;
import cavern.capability.CapabilityPortalCache;
import cavern.inventory.InventoryMagicStorage;
import cavern.item.ItemMagicBook;
import cavern.item.OreCompass;
import cavern.magic.MagicBook;
import cavern.miningassist.MiningAssistUnit;
import cavern.util.CaveUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CaveCapabilities {
    @CapabilityInject(value=IPortalCache.class)
    public static Capability<IPortalCache> PORTAL_CACHE = null;
    @CapabilityInject(value=IPlayerData.class)
    public static Capability<IPlayerData> PLAYER_DATA = null;
    @CapabilityInject(value=IMinerStats.class)
    public static Capability<IMinerStats> MINER_STATS = null;
    @CapabilityInject(value=IMiningData.class)
    public static Capability<IMiningData> MINING_DATA = null;
    @CapabilityInject(value=MiningAssistUnit.class)
    public static Capability<MiningAssistUnit> MINING_ASSIST = null;
    @CapabilityInject(value=OreCompass.class)
    public static Capability<OreCompass> ORE_COMPASS = null;
    @CapabilityInject(value=MagicBook.class)
    public static Capability<MagicBook> MAGIC_BOOK = null;
    @CapabilityInject(value=InventoryMagicStorage.class)
    public static Capability<InventoryMagicStorage> MAGIC_STORAGE = null;

    public static void registerCapabilities() {
        CapabilityPortalCache.register();
        CapabilityPlayerData.register();
        CapabilityMinerStats.register();
        CapabilityMiningData.register();
        CapabilityMiningAssistUnit.register();
        CapabilityOreCompass.register();
        CapabilityMagicBook.register();
        CapabilityMagicStorage.register();
        MinecraftForge.EVENT_BUS.register((Object)new CaveCapabilities());
    }

    public static <T> boolean isValid(Capability<T> capability) {
        return capability != null;
    }

    public static <T> boolean hasCapability(ICapabilityProvider entry, Capability<T> capability) {
        return entry != null && CaveCapabilities.isValid(capability) && entry.hasCapability(capability, null);
    }

    @Nullable
    public static <T> T getCapability(ICapabilityProvider entry, Capability<T> capability) {
        return (T)(CaveCapabilities.hasCapability(entry, capability) ? entry.getCapability(capability, null) : null);
    }

    @SubscribeEvent
    public void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(CaveUtils.getKey("portal_cache"), (ICapabilityProvider)new CapabilityPortalCache());
        if (event.getObject() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getObject();
            event.addCapability(CaveUtils.getKey("player_data"), (ICapabilityProvider)new CapabilityPlayerData());
            event.addCapability(CaveUtils.getKey("miner_stats"), (ICapabilityProvider)new CapabilityMinerStats(player));
            event.addCapability(CaveUtils.getKey("mining_data"), (ICapabilityProvider)new CapabilityMiningData(player));
            event.addCapability(CaveUtils.getKey("mining_assist"), (ICapabilityProvider)new CapabilityMiningAssistUnit(player));
            event.addCapability(CaveUtils.getKey("magic_book"), (ICapabilityProvider)new CapabilityMagicBook());
        }
    }

    @SubscribeEvent
    public void onAttachItemStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMagicBook && ItemMagicBook.EnumType.byItemStack(stack) == ItemMagicBook.EnumType.STORAGE) {
            event.addCapability(stack.func_77973_b().getRegistryName(), (ICapabilityProvider)new CapabilityMagicStorage());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        EntityPlayer original = event.getOriginal();
        IPortalCache originalPortalCache = CaveCapabilities.getCapability((ICapabilityProvider)original, PORTAL_CACHE);
        IPortalCache portalCache = CaveCapabilities.getCapability((ICapabilityProvider)player, PORTAL_CACHE);
        if (originalPortalCache != null && portalCache != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            originalPortalCache.writeToNBT(nbt);
            portalCache.readFromNBT(nbt);
        }
        IPlayerData originalPlayerData = CaveCapabilities.getCapability((ICapabilityProvider)original, PLAYER_DATA);
        IPlayerData playerData = CaveCapabilities.getCapability((ICapabilityProvider)player, PLAYER_DATA);
        if (originalPlayerData != null && playerData != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            originalPlayerData.writeToNBT(nbt);
            playerData.readFromNBT(nbt);
        }
        IMinerStats originalMinerStats = CaveCapabilities.getCapability((ICapabilityProvider)original, MINER_STATS);
        IMinerStats minerStats = CaveCapabilities.getCapability((ICapabilityProvider)player, MINER_STATS);
        if (originalMinerStats != null && minerStats != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            originalMinerStats.writeToNBT(nbt);
            minerStats.readFromNBT(nbt);
        }
    }
}

