/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class CaveCategoryEntry
extends GuiConfigEntries.CategoryEntry {
    public CaveCategoryEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
        super(owningScreen, owningEntryList, prop);
    }

    protected abstract Configuration getConfig();

    protected abstract String getEntryName();

    protected List<IConfigElement> getConfigElements() {
        ArrayList list = Lists.newArrayList();
        for (String category : this.getConfig().getCategoryNames()) {
            list.addAll(new ConfigElement(this.getConfig().getCategory(category)).getChildElements());
        }
        return list;
    }

    protected GuiScreen buildChildScreen() {
        return new GuiConfig((GuiScreen)this.owningScreen, this.getConfigElements(), this.owningScreen.modID, this.getEntryName(), this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)("cavern.config." + this.getEntryName()), (Object[])new Object[0]), GuiConfig.getAbridgedConfigPath((String)this.getConfig().toString()));
    }

    public boolean enabled() {
        if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).configElements.isEmpty()) {
            return false;
        }
        return super.enabled();
    }
}

