/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.api.ISummonMob;
import cavern.client.config.CaveConfigGui;
import cavern.client.gui.GuiListSlot;
import cavern.util.ArrayListExtended;
import cavern.util.CaveUtils;
import cavern.util.PanoramaPaths;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class GuiSelectMob
extends GuiScreen {
    protected final GuiScreen parent;
    protected GuiConfigEntries.ArrayEntry arrayEntry;
    protected MobList mobList;
    protected GuiButton doneButton;
    protected GuiCheckBox detailInfo;
    protected GuiCheckBox instantFilter;
    protected GuiTextField filterTextField;
    protected HoverChecker detailHoverChecker;
    protected HoverChecker instantHoverChecker;
    protected HoverChecker selectedHoverChecker;

    public GuiSelectMob(GuiScreen parent) {
        this.parent = parent;
    }

    public GuiSelectMob(GuiScreen parent, @Nullable GuiConfigEntries.ArrayEntry entry) {
        this(parent);
        this.arrayEntry = entry;
    }

    public void func_73866_w_() {
        if (this.mobList == null) {
            this.mobList = new MobList();
        }
        this.mobList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 28);
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, 145, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 10;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        if (this.detailInfo == null) {
            this.detailInfo = new GuiCheckBox(1, 0, 5, I18n.func_135052_a((String)"cavern.config.detail", (Object[])new Object[0]), true);
        }
        this.detailInfo.setIsChecked(CaveConfigGui.detailInfo);
        this.detailInfo.field_146128_h = this.field_146294_l / 2 + 95;
        if (this.instantFilter == null) {
            this.instantFilter = new GuiCheckBox(2, 0, this.detailInfo.field_146129_i + this.detailInfo.field_146121_g + 2, I18n.func_135052_a((String)"cavern.config.instant", (Object[])new Object[0]), true);
        }
        this.instantFilter.setIsChecked(CaveConfigGui.instantFilter);
        this.instantFilter.field_146128_h = this.detailInfo.field_146128_h;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        this.field_146292_n.add(this.detailInfo);
        this.field_146292_n.add(this.instantFilter);
        if (this.filterTextField == null) {
            this.filterTextField = new GuiTextField(0, this.field_146289_q, 0, 0, 150, 16);
            this.filterTextField.func_146203_f(100);
        }
        this.filterTextField.field_146209_f = this.field_146294_l / 2 - this.filterTextField.field_146218_h - 5;
        this.filterTextField.field_146210_g = this.field_146295_m - this.filterTextField.field_146219_i - 6;
        this.detailHoverChecker = new HoverChecker((GuiButton)this.detailInfo, 800);
        this.instantHoverChecker = new HoverChecker((GuiButton)this.instantFilter, 800);
        this.selectedHoverChecker = new HoverChecker(0, 20, 0, 100, 800);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.arrayEntry != null) {
                        this.arrayEntry.setListFromChildScreen(this.mobList.selected.toArray());
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                    this.mobList.selected.clear();
                    this.mobList.scrollToTop();
                    break;
                }
                case 1: {
                    CaveConfigGui.detailInfo = this.detailInfo.isChecked();
                    break;
                }
                case 2: {
                    CaveConfigGui.instantFilter = this.instantFilter.isChecked();
                }
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.filterTextField.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        this.mobList.func_148128_a(mouseX, mouseY, ticks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.mob", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, ticks);
        this.filterTextField.func_146194_f();
        if (this.detailHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.detail.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.instantHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.instant.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (!this.mobList.selected.isEmpty()) {
            if (mouseX <= 100 && mouseY <= 20) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.mob.selected", (Object[])new Object[]{this.mobList.selected.size()}), 5, 5, 0xEFEFEF);
            }
            if (this.detailInfo.isChecked() && this.selectedHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList values = Lists.newArrayList();
                for (String mob : this.mobList.selected) {
                    values.add(CaveUtils.getEntityName(new ResourceLocation(mob)));
                }
                this.func_146283_a(values, mouseX, mouseY);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.mobList.func_178039_p();
    }

    protected void func_73864_a(int x, int y, int code) throws IOException {
        super.func_73864_a(x, y, code);
        this.filterTextField.func_146192_a(x, y, code);
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (this.filterTextField.func_146206_l()) {
            boolean changed;
            if (code == 1) {
                this.filterTextField.func_146195_b(false);
            }
            String prev = this.filterTextField.func_146179_b();
            this.filterTextField.func_146201_a(c, code);
            String text = this.filterTextField.func_146179_b();
            boolean bl = changed = text != prev;
            if (Strings.isNullOrEmpty((String)text) && changed) {
                this.mobList.setFilter(null);
            } else if (this.instantFilter.isChecked() && changed || code == 28) {
                this.mobList.setFilter(text);
            }
        } else if (code == 1) {
            this.field_146297_k.func_147108_a(this.parent);
            if (this.parent == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (code == 14) {
            this.mobList.selected.clear();
        } else if (code == 15) {
            if (++this.mobList.nameType > 1) {
                this.mobList.nameType = 0;
            }
        } else if (code == 200) {
            this.mobList.scrollUp();
        } else if (code == 208) {
            this.mobList.scrollDown();
        } else if (code == 199) {
            this.mobList.scrollToTop();
        } else if (code == 207) {
            this.mobList.scrollToEnd();
        } else if (code == 57) {
            this.mobList.scrollToSelected();
        } else if (code == 201) {
            this.mobList.scrollToPrev();
        } else if (code == 209) {
            this.mobList.scrollToNext();
        } else if (code == 33 || code == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.filterTextField.func_146195_b(true);
        } else if (GuiSelectMob.func_146271_m() && code == 30) {
            this.mobList.contents.forEach(entry -> this.mobList.selected.add((String)entry));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected class MobList
    extends GuiListSlot {
        protected final ArrayListExtended<String> mobs;
        protected final ArrayListExtended<String> contents;
        protected final Set<String> selected;
        protected final Map<String, List<String>> filterCache;
        protected int nameType;
        protected boolean clickFlag;

        protected MobList() {
            super(GuiSelectMob.this.field_146297_k, 0, 0, 0, 0, 18);
            this.mobs = new ArrayListExtended();
            this.contents = new ArrayListExtended();
            this.selected = Sets.newTreeSet();
            this.filterCache = Maps.newHashMap();
            for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
                EntityEntry entityEntry = (EntityEntry)entry.getValue();
                Class entityClass = entityEntry.getEntityClass();
                if (EntityMob.class == entityClass || EntityLiving.class == entityClass || !EntityLiving.class.isAssignableFrom(entityClass) || ISummonMob.class.isAssignableFrom(entityClass)) continue;
                this.mobs.addIfAbsent(((ResourceLocation)entry.getKey()).toString());
            }
            Collections.sort(this.mobs);
            this.contents.addAll(this.mobs);
            if (GuiSelectMob.this.arrayEntry != null) {
                Arrays.stream(GuiSelectMob.this.arrayEntry.getCurrentValues()).map(obj -> Objects.toString(obj, "")).filter(str -> !Strings.isNullOrEmpty((String)str)).forEach(str -> this.selected.add((String)str));
            }
        }

        @Override
        public PanoramaPaths getPanoramaPaths() {
            return null;
        }

        @Override
        public void scrollToSelected() {
            if (!this.selected.isEmpty()) {
                int amount = 0;
                for (String entry : this.selected) {
                    amount = this.contents.indexOf(entry) * this.func_148146_j();
                    if (this.func_148148_g() == amount) continue;
                    break;
                }
                this.scrollToTop();
                this.func_148145_f(amount);
            }
        }

        protected int func_148127_b() {
            return this.contents.size();
        }

        protected void func_148123_a() {
            GuiSelectMob.this.func_146276_q_();
        }

        protected void func_192637_a(int index, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            String name;
            String entry = this.contents.get(index, null);
            if (Strings.isNullOrEmpty((String)entry)) {
                return;
            }
            switch (this.nameType) {
                case 1: {
                    name = entry;
                    break;
                }
                default: {
                    name = CaveUtils.getEntityName(new ResourceLocation(entry));
                }
            }
            GuiSelectMob.this.func_73732_a(GuiSelectMob.this.field_146289_q, name, this.field_148155_a / 2, par3 + 1, 0xFFFFFF);
        }

        protected void func_148144_a(int index, boolean flag, int mouseX, int mouseY) {
            String entry = this.contents.get(index, null);
            if (!Strings.isNullOrEmpty((String)entry) && (this.clickFlag = !this.clickFlag) && !this.selected.remove(entry)) {
                this.selected.add(entry);
            }
        }

        protected boolean func_148131_a(int index) {
            String entry = this.contents.get(index, null);
            return !Strings.isNullOrEmpty((String)entry) && this.selected.contains(entry);
        }

        protected void setFilter(String filter) {
            List<String> result;
            if (Strings.isNullOrEmpty((String)filter)) {
                result = this.mobs;
            } else if (filter.equals("selected")) {
                result = Lists.newArrayList(this.selected);
            } else {
                if (!this.filterCache.containsKey(filter)) {
                    this.filterCache.put(filter, this.mobs.parallelStream().filter(e -> this.filterMatch((String)e, filter)).collect(Collectors.toList()));
                }
                result = this.filterCache.get(filter);
            }
            if (!this.contents.equals(result)) {
                this.contents.clear();
                this.contents.addAll(result);
            }
        }

        protected boolean filterMatch(String entry, String filter) {
            if ("monster".equalsIgnoreCase(filter)) {
                Class entityClass = EntityList.getClass((ResourceLocation)new ResourceLocation(entry));
                return IMob.class.isAssignableFrom(entityClass);
            }
            if ("animal".equalsIgnoreCase(filter)) {
                Class entityClass = EntityList.getClass((ResourceLocation)new ResourceLocation(entry));
                if (IMob.class.isAssignableFrom(entityClass)) {
                    return false;
                }
                return IAnimals.class.isAssignableFrom(entityClass);
            }
            if (StringUtils.containsIgnoreCase((CharSequence)entry, (CharSequence)filter)) {
                return true;
            }
            String name = CaveUtils.getEntityName(new ResourceLocation(entry));
            if (!Strings.isNullOrEmpty((String)name)) {
                return StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)filter);
            }
            return false;
        }
    }
}

