/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.config.CaveConfigGui;
import cavern.client.gui.GuiListSlot;
import cavern.client.gui.ISelectorCallback;
import cavern.client.gui.SelectSwitchEntry;
import cavern.util.ArrayListExtended;
import cavern.util.CaveUtils;
import cavern.util.PanoramaPaths;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class GuiSelectOreDict
extends GuiScreen {
    protected final GuiScreen parent;
    protected ISelectorCallback<OreDictEntry> selectorCallback;
    protected SelectSwitchEntry switchEntry;
    protected GuiConfigEntries.ArrayEntry arrayEntry;
    protected OreDictList oreDictList;
    protected GuiButton doneButton;
    protected GuiButton switchButton;
    protected GuiCheckBox detailInfo;
    protected GuiCheckBox instantFilter;
    protected GuiTextField filterTextField;
    protected HoverChecker selectedHoverChecker;
    protected HoverChecker detailHoverChecker;
    protected HoverChecker instantHoverChecker;

    public GuiSelectOreDict(GuiScreen parent) {
        this.parent = parent;
    }

    public GuiSelectOreDict(GuiScreen parent, @Nullable GuiConfigEntries.ArrayEntry arrayEntry) {
        this(parent);
        this.arrayEntry = arrayEntry;
    }

    public GuiSelectOreDict(GuiScreen parent, @Nullable ISelectorCallback<OreDictEntry> callback) {
        this(parent);
        this.selectorCallback = callback;
    }

    public GuiSelectOreDict(GuiScreen parent, @Nullable GuiConfigEntries.ArrayEntry arrayEntry, @Nullable ISelectorCallback<OreDictEntry> callback) {
        this(parent, arrayEntry);
        this.selectorCallback = callback;
    }

    public void setSwitchEntry(@Nullable SelectSwitchEntry entry) {
        this.switchEntry = entry;
    }

    public void func_73866_w_() {
        int buttonWidth;
        if (this.oreDictList == null) {
            this.oreDictList = new OreDictList();
        }
        this.oreDictList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 28);
        boolean hasSwitch = this.switchEntry != null;
        int n = buttonWidth = hasSwitch ? 70 : 145;
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, buttonWidth, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 10;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        if (this.switchButton == null) {
            this.switchButton = new GuiButtonExt(3, 0, 0, buttonWidth, 20, hasSwitch ? this.switchEntry.getTranslatedName() : "");
            this.switchButton.field_146125_m = hasSwitch;
        }
        this.switchButton.field_146128_h = this.doneButton.field_146128_h;
        this.switchButton.field_146129_i = this.doneButton.field_146129_i;
        if (hasSwitch) {
            this.doneButton.field_146128_h += buttonWidth + 3;
        }
        if (this.detailInfo == null) {
            this.detailInfo = new GuiCheckBox(1, 0, 5, I18n.func_135052_a((String)"cavern.config.detail", (Object[])new Object[0]), true);
        }
        this.detailInfo.setIsChecked(CaveConfigGui.detailInfo);
        this.detailInfo.field_146128_h = this.field_146294_l / 2 + 95;
        if (this.instantFilter == null) {
            this.instantFilter = new GuiCheckBox(2, 0, this.detailInfo.field_146129_i + this.detailInfo.field_146121_g + 2, I18n.func_135052_a((String)"cavern.config.instant", (Object[])new Object[0]), true);
        }
        this.instantFilter.setIsChecked(CaveConfigGui.instantFilter);
        this.instantFilter.field_146128_h = this.detailInfo.field_146128_h;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        this.field_146292_n.add(this.switchButton);
        this.field_146292_n.add(this.detailInfo);
        this.field_146292_n.add(this.instantFilter);
        if (this.filterTextField == null) {
            this.filterTextField = new GuiTextField(0, this.field_146289_q, 0, 0, 150, 16);
            this.filterTextField.func_146203_f(100);
        }
        this.filterTextField.field_146209_f = this.field_146294_l / 2 - this.filterTextField.field_146218_h - 5;
        this.filterTextField.field_146210_g = this.field_146295_m - this.filterTextField.field_146219_i - 6;
        this.selectedHoverChecker = new HoverChecker(0, 20, 0, 100, 800);
        this.detailHoverChecker = new HoverChecker((GuiButton)this.detailInfo, 800);
        this.instantHoverChecker = new HoverChecker((GuiButton)this.instantFilter, 800);
        if (this.switchEntry != null && this.field_146297_k.field_71462_r == this) {
            this.switchEntry.getGuiScreen().func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }

    protected void setResult() {
        if (this.selectorCallback != null) {
            this.selectorCallback.onSelected((List<OreDictEntry>)ImmutableList.copyOf(this.oreDictList.selected));
        }
        if (this.arrayEntry != null) {
            if (this.switchEntry == null || this.field_146297_k.field_71462_r == this) {
                if (this.oreDictList.selected.isEmpty()) {
                    this.arrayEntry.setListFromChildScreen((Object[])new String[0]);
                } else {
                    this.arrayEntry.setListFromChildScreen(this.oreDictList.selected.stream().map(OreDictEntry::getName).collect(Collectors.toList()).toArray());
                }
            } else if (!this.oreDictList.selected.isEmpty()) {
                Object[] values = this.arrayEntry.getCurrentValues();
                Object[] newValues = this.oreDictList.selected.stream().map(OreDictEntry::getName).collect(Collectors.toList()).toArray();
                if (values == null || values.length <= 0) {
                    this.arrayEntry.setListFromChildScreen(newValues);
                } else {
                    this.arrayEntry.setListFromChildScreen(ArrayUtils.addAll((Object[])values, (Object[])newValues));
                }
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        super.func_73878_a(result, id);
        if (id == 3) {
            this.setResult();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    this.setResult();
                    if (this.switchEntry != null) {
                        this.switchEntry.getGuiScreen().func_73878_a(true, 3);
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                    this.oreDictList.selected.clear();
                    this.oreDictList.scrollToTop();
                    break;
                }
                case 1: {
                    CaveConfigGui.detailInfo = this.detailInfo.isChecked();
                    break;
                }
                case 2: {
                    CaveConfigGui.instantFilter = this.instantFilter.isChecked();
                    break;
                }
                case 3: {
                    if (this.switchEntry == null) break;
                    this.field_146297_k.func_147108_a(this.switchEntry.getGuiScreen());
                    break;
                }
                default: {
                    this.oreDictList.func_148147_a(button);
                }
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.filterTextField.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        this.oreDictList.func_148128_a(mouseX, mouseY, ticks);
        String name = I18n.func_135052_a((String)"cavern.config.select.oreDict", (Object[])new Object[0]);
        if (!Strings.isNullOrEmpty((String)name)) {
            this.func_73732_a(this.field_146289_q, name, this.field_146294_l / 2, 15, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, ticks);
        this.filterTextField.func_146194_f();
        if (this.detailHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.detail.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.instantHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.instant.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        if (!this.oreDictList.selected.isEmpty()) {
            if (mouseX <= 100 && mouseY <= 20) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.oreDict.selected", (Object[])new Object[]{this.oreDictList.selected.size()}), 5, 5, 0xEFEFEF);
            }
            if (this.selectedHoverChecker.checkHover(mouseX, mouseY)) {
                this.func_146283_a(this.oreDictList.selected.stream().map(OreDictEntry::getName).collect(Collectors.toList()), mouseX, mouseY);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.oreDictList.func_178039_p();
    }

    protected void func_73864_a(int x, int y, int code) throws IOException {
        super.func_73864_a(x, y, code);
        this.filterTextField.func_146192_a(x, y, code);
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (this.filterTextField.func_146206_l()) {
            boolean changed;
            if (code == 1) {
                this.filterTextField.func_146195_b(false);
            }
            String prev = this.filterTextField.func_146179_b();
            this.filterTextField.func_146201_a(c, code);
            String text = this.filterTextField.func_146179_b();
            boolean bl = changed = text != prev;
            if (Strings.isNullOrEmpty((String)text) && changed) {
                this.oreDictList.setFilter(null);
            } else if (this.instantFilter.isChecked() && changed || code == 28) {
                this.oreDictList.setFilter(text);
            }
        } else if (code == 1) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (code == 14) {
            this.oreDictList.selected.clear();
        } else if (code == 15) {
            if (++this.oreDictList.nameType > 1) {
                this.oreDictList.nameType = 0;
            }
        } else if (code == 200) {
            this.oreDictList.scrollUp();
        } else if (code == 208) {
            this.oreDictList.scrollDown();
        } else if (code == 203 || code == 205) {
            this.switchButton.func_146113_a(this.field_146297_k.func_147118_V());
            this.func_146284_a(this.switchButton);
        } else if (code == 199) {
            this.oreDictList.scrollToTop();
        } else if (code == 207) {
            this.oreDictList.scrollToEnd();
        } else if (code == 57) {
            this.oreDictList.scrollToSelected();
        } else if (code == 201) {
            this.oreDictList.scrollToPrev();
        } else if (code == 209) {
            this.oreDictList.scrollToNext();
        } else if (code == 33 || code == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.filterTextField.func_146195_b(true);
        } else if (GuiSelectOreDict.func_146271_m() && code == 30) {
            this.oreDictList.contents.forEach(entry -> this.oreDictList.selected.add((OreDictEntry)entry));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public static class OreDictEntry
    implements Comparable<OreDictEntry> {
        private String oreDictName;
        private ItemStack cachedItemStack;

        public OreDictEntry(String name) {
            this.oreDictName = name;
        }

        public String getName() {
            return this.oreDictName;
        }

        public void setName(String name) {
            this.oreDictName = name;
            this.refreshItemStack();
        }

        public ItemStack getItemStack() {
            if (this.cachedItemStack == null) {
                this.refreshItemStack();
            }
            return this.cachedItemStack;
        }

        public void refreshItemStack() {
            for (ItemStack stack : OreDictionary.getOres((String)this.oreDictName, (boolean)false)) {
                if (stack.func_190926_b()) continue;
                if (stack.func_77960_j() == Short.MAX_VALUE) {
                    this.cachedItemStack = new ItemStack(stack.func_77973_b());
                    if (!stack.func_77942_o()) break;
                    this.cachedItemStack.func_77982_d(stack.func_77978_p());
                    break;
                }
                this.cachedItemStack = stack.func_77946_l();
                break;
            }
            if (this.cachedItemStack == null) {
                this.cachedItemStack = ItemStack.field_190927_a;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof OreDictEntry)) {
                return false;
            }
            OreDictEntry entry = (OreDictEntry)obj;
            return this.oreDictName.equals(entry.oreDictName);
        }

        public int hashCode() {
            return this.oreDictName.hashCode();
        }

        public String toString() {
            return this.oreDictName;
        }

        @Override
        public int compareTo(OreDictEntry entry) {
            int i = CaveUtils.compareWithNull(this, entry);
            if (i == 0 && entry != null) {
                i = this.oreDictName.compareTo(entry.oreDictName);
            }
            return i;
        }
    }

    protected class OreDictList
    extends GuiListSlot {
        protected final ArrayListExtended<OreDictEntry> entries;
        protected final ArrayListExtended<OreDictEntry> contents;
        protected final Set<OreDictEntry> selected;
        protected final Map<String, List<OreDictEntry>> filterCache;
        protected int nameType;
        protected boolean clickFlag;

        protected OreDictList() {
            super(GuiSelectOreDict.this.field_146297_k, 0, 0, 0, 0, 18);
            this.entries = new ArrayListExtended();
            this.contents = new ArrayListExtended();
            this.selected = Sets.newTreeSet();
            this.filterCache = Maps.newHashMap();
            HashSet select = Sets.newHashSet();
            if (GuiSelectOreDict.this.arrayEntry != null) {
                Arrays.stream(GuiSelectOreDict.this.arrayEntry.getCurrentValues()).map(Object::toString).filter(value -> !Strings.isNullOrEmpty((String)value)).forEach(value -> {
                    if (OreDictionary.doesOreNameExist((String)(value = value.trim()))) {
                        select.add(value);
                    }
                });
            }
            for (String name : OreDictionary.getOreNames()) {
                if (Strings.isNullOrEmpty((String)name)) continue;
                OreDictEntry entry = new OreDictEntry(name);
                if (GuiSelectOreDict.this.selectorCallback != null && !GuiSelectOreDict.this.selectorCallback.isValidEntry(entry)) continue;
                this.entries.addIfAbsent(entry);
                this.contents.addIfAbsent(entry);
                if (!select.contains(name)) continue;
                this.selected.add(entry);
            }
            if (!this.selected.isEmpty()) {
                this.scrollToTop();
                this.scrollToSelected();
            }
        }

        @Override
        public PanoramaPaths getPanoramaPaths() {
            return null;
        }

        @Override
        public void scrollToSelected() {
            if (!this.selected.isEmpty()) {
                int amount = 0;
                for (OreDictEntry entry : this.selected) {
                    amount = this.contents.indexOf(entry) * this.func_148146_j();
                    if (this.func_148148_g() == amount) continue;
                    break;
                }
                this.scrollToTop();
                this.func_148145_f(amount);
            }
        }

        protected int func_148127_b() {
            return this.contents.size();
        }

        protected void func_148123_a() {
            GuiSelectOreDict.this.func_146276_q_();
        }

        protected void func_192637_a(int slot, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            String displayName;
            OreDictEntry entry = this.contents.get(slot, null);
            if (entry == null) {
                return;
            }
            String name = entry.getName();
            if (this.nameType == 1 && !Strings.isNullOrEmpty((String)(displayName = entry.getItemStack().func_82833_r()))) {
                name = displayName;
            }
            if (!Strings.isNullOrEmpty((String)name)) {
                GuiSelectOreDict.this.func_73732_a(GuiSelectOreDict.this.field_146289_q, name, this.field_148155_a / 2, par3 + 1, 0xFFFFFF);
            }
            if (GuiSelectOreDict.this.detailInfo.isChecked()) {
                this.drawItemStack(GuiSelectOreDict.this.field_146296_j, entry.getItemStack(), this.field_148155_a / 2 - 100, par3 - 1);
            }
        }

        protected void func_148144_a(int slot, boolean flag, int mouseX, int mouseY) {
            OreDictEntry entry = this.contents.get(slot, null);
            if (entry != null && (this.clickFlag = !this.clickFlag) && !this.selected.remove(entry)) {
                this.selected.add(entry);
            }
        }

        protected boolean func_148131_a(int slot) {
            OreDictEntry entry = this.contents.get(slot, null);
            return entry != null && this.selected.contains(entry);
        }

        protected void setFilter(String filter) {
            List<OreDictEntry> result;
            if (Strings.isNullOrEmpty((String)filter)) {
                result = this.entries;
            } else if (filter.equals("selected")) {
                result = Lists.newArrayList(this.selected);
            } else {
                if (!this.filterCache.containsKey(filter)) {
                    this.filterCache.put(filter, this.entries.parallelStream().filter(e -> this.filterMatch((OreDictEntry)e, filter)).collect(Collectors.toList()));
                }
                result = this.filterCache.get(filter);
            }
            if (!this.contents.equals(result)) {
                this.contents.clear();
                this.contents.addAll(result);
            }
        }

        protected boolean filterMatch(OreDictEntry entry, String filter) {
            if (entry == null) {
                return false;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)entry.getName(), (CharSequence)filter)) {
                return true;
            }
            return StringUtils.containsIgnoreCase((CharSequence)entry.getItemStack().func_82833_r(), (CharSequence)filter);
        }
    }
}

