/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.gui;

import cavern.client.config.CaveConfigGui;
import cavern.client.gui.GuiListSlot;
import cavern.client.gui.GuiSelectBiome;
import cavern.client.gui.GuiSelectBlock;
import cavern.config.CavernConfig;
import cavern.config.Config;
import cavern.config.manager.CaveVein;
import cavern.config.manager.CaveVeinManager;
import cavern.util.ArrayListExtended;
import cavern.util.BlockMeta;
import cavern.util.CaveFilters;
import cavern.util.CaveUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiVeinsEditor
extends GuiScreen {
    protected final GuiScreen parent;
    protected final CaveVeinManager manager;
    protected VeinList veinList;
    protected GuiButton doneButton;
    protected GuiButton editButton;
    protected GuiButton cancelButton;
    protected GuiButton addButton;
    protected GuiButton removeButton;
    protected GuiButton clearButton;
    protected GuiCheckBox detailInfo;
    protected GuiCheckBox instantFilter;
    protected GuiTextField filterTextField;
    protected boolean editMode;
    protected GuiTextField blockField;
    protected GuiTextField blockMetaField;
    protected GuiTextField targetField;
    protected GuiTextField targetMetaField;
    protected GuiTextField weightField;
    protected GuiTextField chanceField;
    protected GuiTextField sizeField;
    protected GuiTextField minHeightField;
    protected GuiTextField maxHeightField;
    protected GuiTextField biomesField;
    protected HoverChecker detailHoverChecker;
    protected HoverChecker instantHoverChecker;
    protected HoverChecker blockHoverChecker;
    protected HoverChecker targetHoverChecker;
    protected HoverChecker weightHoverChecker;
    protected HoverChecker chanceHoverChecker;
    protected HoverChecker sizeHoverChecker;
    protected HoverChecker heightHoverChecker;
    protected HoverChecker biomesHoverChecker;
    protected int maxLabelWidth;
    protected final List<String> editLabelList = Lists.newArrayList();
    protected final List<GuiTextField> editFieldList = Lists.newArrayList();

    public GuiVeinsEditor(GuiScreen parent, CaveVeinManager manager) {
        this.parent = parent;
        this.manager = manager;
    }

    public void func_73866_w_() {
        if (this.veinList == null) {
            this.veinList = new VeinList();
            this.refreshVeins(this.manager.getCaveVeins());
        }
        this.veinList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - (this.editMode ? 170 : 28));
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, 65, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 135;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        if (this.editButton == null) {
            this.editButton = new GuiButtonExt(1, 0, 0, this.doneButton.field_146120_f, this.doneButton.field_146121_g, I18n.func_135052_a((String)"gui.edit", (Object[])new Object[0]));
            this.editButton.field_146124_l = false;
        }
        this.editButton.field_146128_h = this.doneButton.field_146128_h - this.doneButton.field_146120_f - 3;
        this.editButton.field_146129_i = this.doneButton.field_146129_i;
        this.editButton.field_146124_l = this.veinList.selected != null;
        boolean bl = this.editButton.field_146125_m = !this.editMode;
        if (this.cancelButton == null) {
            this.cancelButton = new GuiButtonExt(2, 0, 0, this.editButton.field_146120_f, this.editButton.field_146121_g, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]));
        }
        this.cancelButton.field_146128_h = this.editButton.field_146128_h;
        this.cancelButton.field_146129_i = this.editButton.field_146129_i;
        this.cancelButton.field_146125_m = this.editMode;
        if (this.removeButton == null) {
            this.removeButton = new GuiButtonExt(4, 0, 0, this.doneButton.field_146120_f, this.doneButton.field_146121_g, I18n.func_135052_a((String)"gui.remove", (Object[])new Object[0]));
        }
        this.removeButton.field_146128_h = this.editButton.field_146128_h - this.editButton.field_146120_f - 3;
        this.removeButton.field_146129_i = this.doneButton.field_146129_i;
        boolean bl2 = this.removeButton.field_146125_m = !this.editMode;
        if (this.addButton == null) {
            this.addButton = new GuiButtonExt(3, 0, 0, this.doneButton.field_146120_f, this.doneButton.field_146121_g, I18n.func_135052_a((String)"gui.add", (Object[])new Object[0]));
        }
        this.addButton.field_146128_h = this.removeButton.field_146128_h - this.removeButton.field_146120_f - 3;
        this.addButton.field_146129_i = this.doneButton.field_146129_i;
        boolean bl3 = this.addButton.field_146125_m = !this.editMode;
        if (this.clearButton == null) {
            this.clearButton = new GuiButtonExt(5, 0, 0, this.removeButton.field_146120_f, this.removeButton.field_146121_g, I18n.func_135052_a((String)"gui.clear", (Object[])new Object[0]));
        }
        this.clearButton.field_146128_h = this.removeButton.field_146128_h;
        this.clearButton.field_146129_i = this.removeButton.field_146129_i;
        this.clearButton.field_146125_m = false;
        if (this.detailInfo == null) {
            this.detailInfo = new GuiCheckBox(6, 0, 5, I18n.func_135052_a((String)"cavern.config.detail", (Object[])new Object[0]), true);
        }
        this.detailInfo.setIsChecked(CaveConfigGui.detailInfo);
        this.detailInfo.field_146128_h = this.field_146294_l / 2 + 95;
        if (this.instantFilter == null) {
            this.instantFilter = new GuiCheckBox(7, 0, this.detailInfo.field_146129_i + this.detailInfo.field_146121_g + 2, I18n.func_135052_a((String)"cavern.config.instant", (Object[])new Object[0]), true);
        }
        this.instantFilter.setIsChecked(CaveConfigGui.instantFilter);
        this.instantFilter.field_146128_h = this.detailInfo.field_146128_h;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        if (this.editMode) {
            this.field_146292_n.add(this.cancelButton);
        } else {
            this.field_146292_n.add(this.editButton);
            this.field_146292_n.add(this.addButton);
            this.field_146292_n.add(this.removeButton);
            this.field_146292_n.add(this.clearButton);
        }
        this.field_146292_n.add(this.detailInfo);
        this.field_146292_n.add(this.instantFilter);
        if (this.filterTextField == null) {
            this.filterTextField = new GuiTextField(0, this.field_146289_q, 0, 0, 122, 16);
            this.filterTextField.func_146203_f(500);
        }
        this.filterTextField.field_146209_f = this.field_146294_l / 2 - 200;
        this.filterTextField.field_146210_g = this.field_146295_m - this.filterTextField.field_146219_i - 6;
        this.detailHoverChecker = new HoverChecker((GuiButton)this.detailInfo, 800);
        this.instantHoverChecker = new HoverChecker((GuiButton)this.instantFilter, 800);
        this.editLabelList.clear();
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.veins.block", (Object[])new Object[0]));
        this.editLabelList.add("");
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.veins.targetBlock", (Object[])new Object[0]));
        this.editLabelList.add("");
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.veins.weight", (Object[])new Object[0]));
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.veins.chance", (Object[])new Object[0]));
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.veins.size", (Object[])new Object[0]));
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.veins.height", (Object[])new Object[0]));
        this.editLabelList.add("");
        this.editLabelList.add(I18n.func_135052_a((String)"cavern.config.veins.biomes", (Object[])new Object[0]));
        for (String key : this.editLabelList) {
            this.maxLabelWidth = Math.max(this.maxLabelWidth, this.field_146289_q.func_78256_a(key));
        }
        if (this.blockField == null) {
            this.blockField = new GuiTextField(1, this.field_146289_q, 0, 0, 0, 15);
            this.blockField.func_146203_f(100);
        }
        int i = this.maxLabelWidth + 8 + this.field_146294_l / 2;
        this.blockField.field_146209_f = this.field_146294_l / 2 - i / 2 + this.maxLabelWidth + 10;
        this.blockField.field_146210_g = this.veinList.field_148154_c + 5;
        int fieldWidth = this.field_146294_l / 2 + i / 2 - 45 - this.blockField.field_146209_f + 40;
        this.blockField.field_146218_h = fieldWidth / 4 + fieldWidth / 2 - 1;
        if (this.blockMetaField == null) {
            this.blockMetaField = new GuiTextField(2, this.field_146289_q, 0, 0, 0, this.blockField.field_146219_i);
            this.blockMetaField.func_146203_f(100);
        }
        this.blockMetaField.field_146209_f = this.blockField.field_146209_f + this.blockField.field_146218_h + 3;
        this.blockMetaField.field_146210_g = this.blockField.field_146210_g;
        this.blockMetaField.field_146218_h = fieldWidth / 4 - 1;
        if (this.targetField == null) {
            this.targetField = new GuiTextField(3, this.field_146289_q, 0, 0, 0, this.blockField.field_146219_i);
            this.targetField.func_146203_f(100);
        }
        this.targetField.field_146209_f = this.blockField.field_146209_f;
        this.targetField.field_146210_g = this.blockField.field_146210_g + this.blockField.field_146219_i + 5;
        this.targetField.field_146218_h = this.blockField.field_146218_h;
        if (this.targetMetaField == null) {
            this.targetMetaField = new GuiTextField(4, this.field_146289_q, 0, 0, 0, this.blockField.field_146219_i);
            this.targetMetaField.func_146203_f(100);
        }
        this.targetMetaField.field_146209_f = this.targetField.field_146209_f + this.targetField.field_146218_h + 3;
        this.targetMetaField.field_146210_g = this.targetField.field_146210_g;
        this.targetMetaField.field_146218_h = this.blockMetaField.field_146218_h;
        if (this.weightField == null) {
            this.weightField = new GuiTextField(5, this.field_146289_q, 0, 0, 0, this.blockField.field_146219_i);
            this.weightField.func_146203_f(3);
        }
        this.weightField.field_146209_f = this.targetField.field_146209_f;
        this.weightField.field_146210_g = this.targetField.field_146210_g + this.targetField.field_146219_i + 5;
        this.weightField.field_146218_h = fieldWidth;
        if (this.chanceField == null) {
            this.chanceField = new GuiTextField(6, this.field_146289_q, 0, 0, 0, this.blockField.field_146219_i);
            this.chanceField.func_146203_f(3);
        }
        this.chanceField.field_146209_f = this.weightField.field_146209_f;
        this.chanceField.field_146210_g = this.weightField.field_146210_g + this.weightField.field_146219_i + 5;
        this.chanceField.field_146218_h = this.weightField.field_146218_h;
        if (this.sizeField == null) {
            this.sizeField = new GuiTextField(7, this.field_146289_q, 0, 0, 0, this.blockField.field_146219_i);
            this.sizeField.func_146203_f(3);
        }
        this.sizeField.field_146209_f = this.chanceField.field_146209_f;
        this.sizeField.field_146210_g = this.chanceField.field_146210_g + this.chanceField.field_146219_i + 5;
        this.sizeField.field_146218_h = this.chanceField.field_146218_h;
        if (this.minHeightField == null) {
            this.minHeightField = new GuiTextField(8, this.field_146289_q, 0, 0, 0, this.blockField.field_146219_i);
            this.minHeightField.func_146203_f(3);
        }
        this.minHeightField.field_146209_f = this.sizeField.field_146209_f;
        this.minHeightField.field_146210_g = this.sizeField.field_146210_g + this.sizeField.field_146219_i + 5;
        this.minHeightField.field_146218_h = fieldWidth / 2 - 1;
        if (this.maxHeightField == null) {
            this.maxHeightField = new GuiTextField(9, this.field_146289_q, 0, 0, 0, this.blockField.field_146219_i);
            this.maxHeightField.func_146203_f(3);
        }
        this.maxHeightField.field_146209_f = this.minHeightField.field_146209_f + this.minHeightField.field_146218_h + 3;
        this.maxHeightField.field_146210_g = this.minHeightField.field_146210_g;
        this.maxHeightField.field_146218_h = this.minHeightField.field_146218_h;
        if (this.biomesField == null) {
            this.biomesField = new GuiTextField(10, this.field_146289_q, 0, 0, 0, this.blockField.field_146219_i);
            this.biomesField.func_146203_f(800);
        }
        this.biomesField.field_146209_f = this.minHeightField.field_146209_f;
        this.biomesField.field_146210_g = this.minHeightField.field_146210_g + this.minHeightField.field_146219_i + 5;
        this.biomesField.field_146218_h = this.sizeField.field_146218_h;
        this.editFieldList.clear();
        if (this.editMode) {
            this.editFieldList.add(this.blockField);
            this.editFieldList.add(this.blockMetaField);
            this.editFieldList.add(this.targetField);
            this.editFieldList.add(this.targetMetaField);
            this.editFieldList.add(this.weightField);
            this.editFieldList.add(this.chanceField);
            this.editFieldList.add(this.sizeField);
            this.editFieldList.add(this.minHeightField);
            this.editFieldList.add(this.maxHeightField);
            this.editFieldList.add(this.biomesField);
        }
        this.blockHoverChecker = new HoverChecker(this.blockField.field_146210_g - 1, this.blockField.field_146210_g + this.blockField.field_146219_i, this.blockField.field_146209_f - this.maxLabelWidth - 12, this.blockField.field_146209_f - 10, 800);
        this.targetHoverChecker = new HoverChecker(this.targetField.field_146210_g - 1, this.targetField.field_146210_g + this.targetField.field_146219_i, this.targetField.field_146209_f - this.maxLabelWidth - 12, this.targetField.field_146209_f - 10, 800);
        this.weightHoverChecker = new HoverChecker(this.weightField.field_146210_g - 1, this.weightField.field_146210_g + this.weightField.field_146219_i, this.weightField.field_146209_f - this.maxLabelWidth - 12, this.weightField.field_146209_f - 10, 800);
        this.chanceHoverChecker = new HoverChecker(this.chanceField.field_146210_g - 1, this.chanceField.field_146210_g + this.chanceField.field_146219_i, this.chanceField.field_146209_f - this.maxLabelWidth - 12, this.chanceField.field_146209_f - 10, 800);
        this.sizeHoverChecker = new HoverChecker(this.sizeField.field_146210_g - 1, this.sizeField.field_146210_g + this.sizeField.field_146219_i, this.sizeField.field_146209_f - this.maxLabelWidth - 12, this.sizeField.field_146209_f - 10, 800);
        this.heightHoverChecker = new HoverChecker(this.minHeightField.field_146210_g - 1, this.minHeightField.field_146210_g + this.minHeightField.field_146219_i, this.minHeightField.field_146209_f - this.maxLabelWidth - 12, this.minHeightField.field_146209_f - 10, 800);
        this.biomesHoverChecker = new HoverChecker(this.biomesField.field_146210_g - 1, this.biomesField.field_146210_g + this.biomesField.field_146219_i, this.biomesField.field_146209_f - this.maxLabelWidth - 12, this.biomesField.field_146209_f - 10, 800);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    if (this.editMode) {
                        for (CaveVein vein : this.veinList.selected) {
                            int meta;
                            Block block;
                            if (!Strings.isNullOrEmpty((String)this.blockField.func_146179_b()) && (block = Block.func_149684_b((String)this.blockField.func_146179_b())) != null && block != Blocks.field_150350_a) {
                                meta = BlockMeta.getMetaFromString(block, this.blockMetaField.func_146179_b());
                                if (meta < 0) {
                                    meta = 0;
                                }
                                vein.setBlockMeta(new BlockMeta(block, meta));
                            }
                            if (!Strings.isNullOrEmpty((String)this.targetField.func_146179_b()) && (block = Block.func_149684_b((String)this.targetField.func_146179_b())) != null && block != Blocks.field_150350_a) {
                                meta = BlockMeta.getMetaFromString(block, this.targetMetaField.func_146179_b());
                                if (meta < 0) {
                                    meta = 0;
                                }
                                vein.setTarget(new BlockMeta(block, meta));
                            }
                            if (!Strings.isNullOrEmpty((String)this.weightField.func_146179_b())) {
                                vein.setWeight(NumberUtils.toInt((String)this.weightField.func_146179_b(), (int)vein.getWeight()));
                            }
                            if (!Strings.isNullOrEmpty((String)this.chanceField.func_146179_b())) {
                                vein.setChance(NumberUtils.toDouble((String)this.chanceField.func_146179_b(), (double)vein.getChance()));
                            }
                            if (!Strings.isNullOrEmpty((String)this.sizeField.func_146179_b())) {
                                vein.setSize(NumberUtils.toInt((String)this.sizeField.func_146179_b(), (int)vein.getSize()));
                            }
                            if (!Strings.isNullOrEmpty((String)this.minHeightField.func_146179_b())) {
                                vein.setMinHeight(NumberUtils.toInt((String)this.minHeightField.func_146179_b(), (int)vein.getMinHeight()));
                            }
                            if (!Strings.isNullOrEmpty((String)this.maxHeightField.func_146179_b())) {
                                vein.setMaxHeight(NumberUtils.toInt((String)this.maxHeightField.func_146179_b(), (int)vein.getMaxHeight()));
                            }
                            if (Strings.isNullOrEmpty((String)this.biomesField.func_146179_b())) continue;
                            String text = this.biomesField.func_146179_b();
                            TreeSet biomes = Sets.newTreeSet();
                            if (text.contains(",")) {
                                for (String str : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)text)) {
                                    if (!Strings.isNullOrEmpty((String)str)) continue;
                                    biomes.add(str);
                                }
                            } else {
                                biomes.add(text);
                            }
                            if (biomes.isEmpty()) continue;
                            vein.setBiomes(biomes.toArray(new String[biomes.size()]));
                        }
                        this.func_146284_a(this.cancelButton);
                        this.veinList.scrollToTop();
                        this.veinList.scrollToSelected();
                        break;
                    }
                    this.manager.getCaveVeins().clear();
                    try {
                        FileUtils.forceDelete((File)new File(this.manager.config.toString()));
                        this.manager.config.load();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    CavernConfig.generateVeinsConfig(this.manager, this.veinList.veins);
                    Config.saveConfig(this.manager.config);
                    this.func_146284_a(this.cancelButton);
                    this.veinList.selected.clear();
                    this.veinList.scrollToTop();
                    break;
                }
                case 1: {
                    if (this.editMode) {
                        this.func_146284_a(this.cancelButton);
                        break;
                    }
                    if (this.veinList.selected.isEmpty()) break;
                    this.editMode = true;
                    this.func_73866_w_();
                    this.veinList.scrollToTop();
                    this.veinList.scrollToSelected();
                    if (this.veinList.selected.size() > 1) {
                        this.blockField.func_146180_a("");
                        this.blockMetaField.func_146180_a("");
                        this.targetField.func_146180_a("");
                        this.targetMetaField.func_146180_a("");
                        this.weightField.func_146180_a("");
                        this.chanceField.func_146180_a("");
                        this.sizeField.func_146180_a("");
                        this.minHeightField.func_146180_a("");
                        this.maxHeightField.func_146180_a("");
                        this.biomesField.func_146180_a("");
                        break;
                    }
                    for (CaveVein vein : this.veinList.selected) {
                        if (vein == null) continue;
                        this.blockField.func_146180_a(vein.getBlockMeta().getBlockName());
                        this.blockMetaField.func_146180_a(vein.getBlockMeta().getMetaString());
                        this.targetField.func_146180_a(vein.getTarget().getBlockName());
                        this.targetMetaField.func_146180_a(vein.getTarget().getMetaString());
                        this.weightField.func_146180_a(Integer.toString(vein.getWeight()));
                        this.chanceField.func_146180_a(Double.toString(vein.getChance()));
                        this.sizeField.func_146180_a(Integer.toString(vein.getSize()));
                        this.minHeightField.func_146180_a(Integer.toString(vein.getMinHeight()));
                        this.maxHeightField.func_146180_a(Integer.toString(vein.getMaxHeight()));
                        Object[] biomes = vein.getBiomes();
                        if (biomes == null || biomes.length <= 0) {
                            this.biomesField.func_146180_a("");
                            continue;
                        }
                        this.biomesField.func_146180_a(Joiner.on((String)", ").join(biomes));
                    }
                    break;
                }
                case 2: {
                    if (this.editMode) {
                        this.editMode = false;
                        this.func_73866_w_();
                        break;
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                    break;
                }
                case 3: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectBlock((GuiScreen)this, selected -> {
                        if (this.editMode) {
                            return;
                        }
                        this.veinList.selected.clear();
                        for (BlockMeta blockMeta : selected) {
                            CaveVein vein = new CaveVein(blockMeta, 1, 1, 1, 255, new Object[0]);
                            this.veinList.veins.addIfAbsent(vein);
                            this.veinList.contents.addIfAbsent(vein);
                            this.veinList.selected.add(vein);
                        }
                        this.veinList.scrollToTop();
                        this.veinList.scrollToSelected();
                    }));
                    break;
                }
                case 4: {
                    for (CaveVein vein : this.veinList.selected) {
                        this.veinList.veins.remove(vein);
                        this.veinList.contents.remove(vein);
                    }
                    this.veinList.selected.clear();
                    break;
                }
                case 5: {
                    this.veinList.veins.forEach(entry -> this.veinList.selected.add((CaveVein)entry));
                    this.func_146284_a(this.removeButton);
                    break;
                }
                case 6: {
                    CaveConfigGui.detailInfo = this.detailInfo.isChecked();
                    break;
                }
                case 7: {
                    CaveConfigGui.instantFilter = this.instantFilter.isChecked();
                    break;
                }
                default: {
                    this.veinList.func_148147_a(button);
                }
            }
        }
    }

    public void func_73876_c() {
        if (this.editMode) {
            for (GuiTextField textField : this.editFieldList) {
                textField.func_146178_a();
            }
        } else {
            this.removeButton.field_146124_l = this.editButton.field_146124_l = !this.veinList.selected.isEmpty();
            this.filterTextField.func_146178_a();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        CaveVein vein;
        this.veinList.func_148128_a(mouseX, mouseY, ticks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.veins", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, ticks);
        if (this.editMode) {
            String key;
            for (int i = 0; i < this.editFieldList.size(); ++i) {
                GuiTextField textField = this.editFieldList.get(i);
                textField.func_146194_f();
                this.func_73731_b(this.field_146289_q, this.editLabelList.get(i), textField.field_146209_f - this.maxLabelWidth - 10, textField.field_146210_g + 3, 0xBBBBBB);
            }
            if (this.blockHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                key = "cavern.config.veins.block";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            } else if (this.targetHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                key = "cavern.config.veins.targetBlock";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            } else if (this.weightHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                key = "cavern.config.veins.weight";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            } else if (this.chanceHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                key = "cavern.config.veins.chance";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            } else if (this.sizeHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                key = "cavern.config.veins.size";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            } else if (this.heightHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                key = "cavern.config.veins.height";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            } else if (this.biomesHoverChecker.checkHover(mouseX, mouseY)) {
                ArrayList hover = Lists.newArrayList();
                key = "cavern.config.veins.biomes";
                hover.add(TextFormatting.GRAY + I18n.func_135052_a((String)key, (Object[])new Object[0]));
                hover.addAll(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)(key + ".tooltip"), (Object[])new Object[0]), 300));
                this.func_146283_a(hover, mouseX, mouseY);
            }
        } else {
            this.filterTextField.func_146194_f();
        }
        if (this.detailHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.detail.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.instantHoverChecker.checkHover(mouseX, mouseY)) {
            this.func_146283_a(this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.instant.hover", (Object[])new Object[0]), 300), mouseX, mouseY);
        } else if (this.veinList.func_148141_e(mouseY) && GuiVeinsEditor.func_146271_m() && (vein = (CaveVein)this.veinList.contents.get(this.veinList.func_148124_c(mouseX, mouseY), null)) != null) {
            ArrayList info = Lists.newArrayList();
            String prefix = TextFormatting.GRAY.toString();
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.veins.block", (Object[])new Object[0]) + ": " + vein.getBlockMeta().getName());
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.veins.targetBlock", (Object[])new Object[0]) + ": " + vein.getTarget().getName());
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.veins.weight", (Object[])new Object[0]) + ": " + vein.getWeight());
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.veins.chance", (Object[])new Object[0]) + ": " + vein.getChance());
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.veins.size", (Object[])new Object[0]) + ": " + vein.getSize());
            info.add(prefix + I18n.func_135052_a((String)"cavern.config.veins.height", (Object[])new Object[0]) + ": " + vein.getMinHeight() + ", " + vein.getMaxHeight());
            Object[] biomes = vein.getBiomes();
            if (biomes != null && biomes.length > 0) {
                List list = this.field_146289_q.func_78271_c(I18n.func_135052_a((String)"cavern.config.veins.biomes", (Object[])new Object[0]) + ": " + Joiner.on((String)", ").join(biomes), 300);
                for (String text : list) {
                    info.add(prefix + text);
                }
            }
            this.func_146283_a(info, mouseX, mouseY);
        }
        if (this.veinList.selected.size() > 1 && mouseX <= 100 && mouseY <= 20) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"cavern.config.select.entry.selected", (Object[])new Object[]{this.veinList.selected.size()}), 5, 5, 0xEFEFEF);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.veinList.func_178039_p();
        if (this.editMode) {
            if (this.weightField.func_146206_l()) {
                int i = Mouse.getDWheel();
                if (i < 0) {
                    this.weightField.func_146180_a(Integer.toString(Math.max(NumberUtils.toInt((String)this.weightField.func_146179_b()) - 1, 1)));
                } else if (i > 0) {
                    this.weightField.func_146180_a(Integer.toString(Math.min(NumberUtils.toInt((String)this.weightField.func_146179_b()) + 1, 100)));
                }
            } else if (this.chanceField.func_146206_l()) {
                int i = Mouse.getDWheel();
                if (i < 0) {
                    this.chanceField.func_146180_a(Double.toString(Math.max(NumberUtils.toDouble((String)this.chanceField.func_146179_b()) - 0.1, 0.0)));
                } else if (i > 0) {
                    this.chanceField.func_146180_a(Double.toString(Math.min(NumberUtils.toDouble((String)this.chanceField.func_146179_b()) + 0.1, 1.0)));
                }
            } else if (this.sizeField.func_146206_l()) {
                int i = Mouse.getDWheel();
                if (i < 0) {
                    this.sizeField.func_146180_a(Integer.toString(Math.max(NumberUtils.toInt((String)this.sizeField.func_146179_b()) - 1, 1)));
                } else if (i > 0) {
                    this.sizeField.func_146180_a(Integer.toString(Math.min(NumberUtils.toInt((String)this.sizeField.func_146179_b()) + 1, 500)));
                }
            } else if (this.minHeightField.func_146206_l()) {
                int i = Mouse.getDWheel();
                if (i < 0) {
                    this.minHeightField.func_146180_a(Integer.toString(Math.max(NumberUtils.toInt((String)this.minHeightField.func_146179_b()) - 1, 0)));
                } else if (i > 0) {
                    this.minHeightField.func_146180_a(Integer.toString(Math.min(NumberUtils.toInt((String)this.minHeightField.func_146179_b()) + 1, NumberUtils.toInt((String)this.maxHeightField.func_146179_b()) - 1)));
                }
            } else if (this.maxHeightField.func_146206_l()) {
                int i = Mouse.getDWheel();
                if (i < 0) {
                    this.maxHeightField.func_146180_a(Integer.toString(Math.max(NumberUtils.toInt((String)this.maxHeightField.func_146179_b()) - 1, NumberUtils.toInt((String)this.minHeightField.func_146179_b()) + 1)));
                } else if (i > 0) {
                    this.maxHeightField.func_146180_a(Integer.toString(Math.min(NumberUtils.toInt((String)this.maxHeightField.func_146179_b()) + 1, 255)));
                }
            }
        }
    }

    protected void func_73864_a(int x, int y, int code) throws IOException {
        super.func_73864_a(x, y, code);
        if (code == 1) {
            this.func_146284_a(this.editButton);
        } else if (this.editMode) {
            for (GuiTextField textField : this.editFieldList) {
                textField.func_146192_a(x, y, code);
            }
            if (!GuiVeinsEditor.func_146272_n()) {
                if (this.blockField.func_146206_l()) {
                    this.blockField.func_146195_b(false);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectBlock((GuiScreen)this, this.blockField, this.blockMetaField));
                } else if (this.targetField.func_146206_l()) {
                    this.targetField.func_146195_b(false);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectBlock((GuiScreen)this, this.targetField, this.targetMetaField));
                } else if (this.biomesField.func_146206_l()) {
                    this.biomesField.func_146195_b(false);
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiSelectBiome((GuiScreen)this, this.biomesField));
                }
            }
        } else {
            this.filterTextField.func_146192_a(x, y, code);
        }
    }

    public void func_146282_l() throws IOException {
        super.func_146282_l();
        if (Keyboard.getEventKey() == 42 || Keyboard.getEventKey() == 54) {
            this.clearButton.field_146125_m = !this.editMode && Keyboard.getEventKeyState();
        }
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (this.editMode) {
            for (GuiTextField textField : this.editFieldList) {
                if (code == 1) {
                    textField.func_146195_b(false);
                    continue;
                }
                if (!textField.func_146206_l() || textField != this.blockField && textField != this.blockMetaField && textField != this.targetField && textField != this.targetMetaField && textField != this.biomesField && !CharUtils.isAsciiControl((char)c) && !CharUtils.isAsciiNumeric((char)c)) continue;
                textField.func_146201_a(c, code);
            }
        } else if (this.filterTextField.func_146206_l()) {
            boolean changed;
            if (code == 1) {
                this.filterTextField.func_146195_b(false);
            }
            String prev = this.filterTextField.func_146179_b();
            this.filterTextField.func_146201_a(c, code);
            String text = this.filterTextField.func_146179_b();
            boolean bl = changed = text != prev;
            if (Strings.isNullOrEmpty((String)text) && changed) {
                this.veinList.setFilter(null);
            } else if (this.instantFilter.isChecked() && changed || code == 28) {
                this.veinList.setFilter(text);
            }
        } else if (code == 1) {
            this.func_146284_a(this.doneButton);
        } else if (code == 14) {
            this.veinList.selected.clear();
        } else if (code == 15) {
            if (++this.veinList.nameType > 2) {
                this.veinList.nameType = 0;
            }
        } else if (code == 200) {
            if (GuiVeinsEditor.func_146271_m()) {
                Collections.sort(this.veinList.selected, this.veinList);
                for (CaveVein vein : this.veinList.selected) {
                    this.veinList.contents.swapTo(this.veinList.contents.indexOf(vein), -1);
                    this.veinList.veins.swapTo(this.veinList.veins.indexOf(vein), -1);
                }
                this.veinList.scrollToTop();
                this.veinList.scrollToSelected();
            } else {
                this.veinList.scrollUp();
            }
        } else if (code == 208) {
            if (GuiVeinsEditor.func_146271_m()) {
                Collections.sort(this.veinList.selected, this.veinList);
                Collections.reverse(this.veinList.selected);
                for (CaveVein vein : this.veinList.selected) {
                    this.veinList.contents.swapTo(this.veinList.contents.indexOf(vein), 1);
                    this.veinList.veins.swapTo(this.veinList.veins.indexOf(vein), 1);
                }
                this.veinList.scrollToTop();
                this.veinList.scrollToSelected();
            } else {
                this.veinList.scrollDown();
            }
        } else if (code == 199) {
            this.veinList.scrollToTop();
        } else if (code == 207) {
            this.veinList.scrollToEnd();
        } else if (code == 57) {
            this.veinList.scrollToSelected();
        } else if (code == 201) {
            this.veinList.scrollToPrev();
        } else if (code == 209) {
            this.veinList.scrollToNext();
        } else if (code == 33 || code == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.filterTextField.func_146195_b(true);
        } else if (GuiVeinsEditor.func_146271_m() && code == 30) {
            this.veinList.contents.forEach(entry -> this.veinList.selected.add((CaveVein)entry));
        } else if (code == 211 && !this.veinList.selected.isEmpty()) {
            this.func_146284_a(this.removeButton);
        } else if (code == 46 && GuiVeinsEditor.func_146271_m()) {
            Collections.sort(this.veinList.selected, this.veinList);
            this.veinList.copied.clear();
            for (CaveVein entry2 : this.veinList.selected) {
                this.veinList.copied.add(new CaveVein(entry2));
            }
        } else if (code == 45 && GuiVeinsEditor.func_146271_m()) {
            this.func_73869_a('\u0000', 46);
            this.func_146284_a(this.removeButton);
        } else if (code == 47 && GuiVeinsEditor.func_146271_m() && !this.veinList.copied.isEmpty()) {
            int index1 = -1;
            int index2 = -1;
            int i = 0;
            for (CaveVein vein : this.veinList.copied) {
                CaveVein entry3 = new CaveVein(vein);
                if (!this.veinList.veins.add(entry3) || !this.veinList.contents.add(entry3) || this.veinList.selected.isEmpty()) continue;
                if (index1 < 0) {
                    index1 = this.veinList.contents.indexOf(this.veinList.selected.get(this.veinList.selected.size() - 1)) + 1;
                }
                Collections.swap(this.veinList.contents, index1 + i, this.veinList.contents.indexOf(entry3));
                if (index2 < 0) {
                    index2 = this.veinList.veins.indexOf(this.veinList.selected.get(this.veinList.selected.size() - 1)) + 1;
                }
                Collections.swap(this.veinList.veins, index2 + i, this.veinList.veins.indexOf(entry3));
                ++i;
            }
            this.veinList.scrollToTop();
            this.veinList.scrollToSelected();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        this.veinList.currentPanoramaPaths = null;
    }

    public void refreshVeins(Collection<CaveVein> veins) {
        this.veinList.veins.clear();
        this.veinList.contents.clear();
        for (CaveVein vein : veins) {
            this.veinList.veins.addIfAbsent(vein);
            this.veinList.contents.addIfAbsent(vein);
        }
    }

    protected class VeinList
    extends GuiListSlot
    implements Comparator<CaveVein> {
        protected final ArrayListExtended<CaveVein> veins;
        protected final ArrayListExtended<CaveVein> contents;
        protected final List<CaveVein> selected;
        protected final List<CaveVein> copied;
        protected final Map<String, List<CaveVein>> filterCache;
        protected int nameType;
        protected boolean clickFlag;

        public VeinList() {
            super(GuiVeinsEditor.this.field_146297_k, 0, 0, 0, 0, 22);
            this.veins = new ArrayListExtended();
            this.contents = new ArrayListExtended();
            this.selected = Lists.newArrayList();
            this.copied = Lists.newArrayList();
            this.filterCache = Maps.newHashMap();
        }

        @Override
        public void scrollToSelected() {
            if (!this.selected.isEmpty()) {
                int amount = 0;
                for (CaveVein vein : this.selected) {
                    amount = this.contents.indexOf(vein) * this.func_148146_j();
                    if (this.func_148148_g() == amount) continue;
                    break;
                }
                this.scrollToTop();
                this.func_148145_f(amount);
            }
        }

        protected int func_148127_b() {
            return this.contents.size();
        }

        protected void func_148123_a() {
            GuiVeinsEditor.this.func_146276_q_();
        }

        protected void func_192637_a(int slot, int par2, int par3, int par4, int mouseX, int mouseY, float partialTicks) {
            int meta;
            CaveVein vein = this.contents.get(slot, null);
            if (vein == null) {
                return;
            }
            BlockMeta blockMeta = vein.getBlockMeta();
            Block block = blockMeta.getBlock();
            ItemStack stack = new ItemStack(block, 1, meta = blockMeta.getMeta());
            boolean hasItem = stack.func_77973_b() != Items.field_190931_a;
            String text = null;
            if (this.nameType == 1) {
                text = blockMeta.getName();
            } else if (hasItem) {
                switch (this.nameType) {
                    case 2: {
                        text = stack.func_77977_a();
                        text = text.substring(text.indexOf(".") + 1);
                        break;
                    }
                    default: {
                        text = stack.func_82833_r();
                        break;
                    }
                }
            } else {
                switch (this.nameType) {
                    case 2: {
                        text = block.func_149739_a();
                        text = text.substring(text.indexOf(".") + 1);
                        break;
                    }
                    default: {
                        text = block.func_149732_F();
                    }
                }
            }
            if (!Strings.isNullOrEmpty((String)text)) {
                GuiVeinsEditor.this.func_73732_a(GuiVeinsEditor.this.field_146289_q, text, this.field_148155_a / 2, par3 + 3, 0xFFFFFF);
            }
            if (GuiVeinsEditor.this.detailInfo.isChecked()) {
                this.drawItemStack(GuiVeinsEditor.this.field_146296_j, blockMeta, this.field_148155_a / 2 - 100, par3 + 1, GuiVeinsEditor.this.field_146289_q, Integer.toString(vein.getSize()));
                this.drawItemStack(GuiVeinsEditor.this.field_146296_j, vein.getTarget(), this.field_148155_a / 2 + 90, par3 + 1, GuiVeinsEditor.this.field_146289_q, Integer.toString(vein.getWeight()));
            }
        }

        protected void func_148144_a(int slot, boolean flag, int mouseX, int mouseY) {
            if (GuiVeinsEditor.this.editMode) {
                return;
            }
            CaveVein vein = this.contents.get(slot, null);
            if (vein != null && (this.clickFlag = !this.clickFlag) && !this.selected.remove(vein)) {
                if (!GuiScreen.func_146271_m()) {
                    this.selected.clear();
                }
                this.selected.add(vein);
            }
        }

        protected boolean func_148131_a(int slot) {
            CaveVein vein = this.contents.get(slot, null);
            return vein != null && this.selected.contains(vein);
        }

        @Override
        public int compare(CaveVein o1, CaveVein o2) {
            int i = CaveUtils.compareWithNull(o1, o2);
            if (i == 0 && o1 != null && o2 != null) {
                i = Integer.compare(this.veins.indexOf(o1), this.veins.indexOf(o2));
            }
            return i;
        }

        protected void setFilter(String filter) {
            List<CaveVein> result;
            if (Strings.isNullOrEmpty((String)filter)) {
                result = this.veins;
            } else if (filter.equals("selected")) {
                result = this.selected;
            } else {
                if (!this.filterCache.containsKey(filter)) {
                    this.filterCache.put(filter, this.veins.parallelStream().filter(e -> this.filterMatch((CaveVein)e, filter)).collect(Collectors.toList()));
                }
                result = this.filterCache.get(filter);
            }
            if (!this.contents.equals(result)) {
                this.contents.clear();
                this.contents.addAll(result);
            }
        }

        protected boolean filterMatch(CaveVein vein, String filter) {
            if (CaveFilters.blockFilter(vein.getBlockMeta(), filter) || CaveFilters.blockFilter(vein.getTarget(), filter)) {
                return true;
            }
            for (Biome biome : vein.getBiomeList()) {
                if (!CaveFilters.biomeFilter(biome, filter)) continue;
                return true;
            }
            return false;
        }
    }
}

