/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.handler;

import cavern.api.CavernAPI;
import cavern.api.IIceEquipment;
import cavern.block.RandomiteHelper;
import cavern.client.CaveKeyBindings;
import cavern.client.gui.GuiDownloadCaveTerrain;
import cavern.client.gui.GuiLoadCaveTerrain;
import cavern.client.gui.GuiMiningRecords;
import cavern.client.gui.toasts.DelayedToast;
import cavern.config.AquaCavernConfig;
import cavern.config.CavelandConfig;
import cavern.config.CaveniaConfig;
import cavern.config.CavernConfig;
import cavern.config.Config;
import cavern.config.DisplayConfig;
import cavern.config.GeneralConfig;
import cavern.config.HugeCavernConfig;
import cavern.config.MiningAssistConfig;
import cavern.config.MirageWorldsConfig;
import cavern.core.Cavern;
import cavern.item.ItemBowCavenic;
import cavern.item.ItemBowIce;
import cavern.miningassist.MiningAssist;
import cavern.stats.MinerRank;
import cavern.stats.MinerStats;
import cavern.util.CaveUtils;
import cavern.util.Version;
import cavern.world.CaveDimensions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ClientEventHooks {
    public static final List<DelayedToast> DELAYED_TOAST = Lists.newArrayList();

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71462_r != null && mc.field_71462_r instanceof GuiMainMenu && Config.configChecker.isUpdated() && !Config.configChecker.isNotified()) {
            String line1 = I18n.func_135052_a((String)"cavern.config.message.update", (Object[])new Object[0]);
            String line2 = I18n.func_135052_a((String)"cavern.config.message.open", (Object[])new Object[0]);
            GuiScreen parentScreen = mc.field_71462_r;
            mc.func_147108_a((GuiScreen)new GuiYesNo((result, id) -> {
                if (result) {
                    IModGuiFactory guiFactory = FMLClientHandler.instance().getGuiFactoryFor(CaveUtils.getModContainer());
                    GuiScreen guiConfig = guiFactory.createConfigGui(parentScreen);
                    mc.func_147108_a(guiConfig);
                } else {
                    mc.func_147108_a(parentScreen);
                }
            }, line1, line2, -1));
            Config.configChecker.setNotified(true);
        }
        if (!DELAYED_TOAST.isEmpty()) {
            Iterator<DelayedToast> iterator = DELAYED_TOAST.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().onUpdate()) continue;
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        String mod = event.getModID();
        String type = event.getConfigID();
        if (mod.equals("cavern")) {
            if (Strings.isNullOrEmpty((String)type)) {
                GeneralConfig.syncConfig();
                DisplayConfig.syncConfig();
                MiningAssistConfig.syncConfig();
                CavernConfig.syncConfig();
                HugeCavernConfig.syncConfig();
                AquaCavernConfig.syncConfig();
                CavelandConfig.syncConfig();
                CaveniaConfig.syncConfig();
                MirageWorldsConfig.syncConfig();
            } else {
                switch (type) {
                    case "general": {
                        GeneralConfig.syncConfig();
                        if (!event.isWorldRunning()) break;
                        GeneralConfig.miningPointItems.refreshItems();
                        GeneralConfig.miningPoints.refreshPoints();
                        GeneralConfig.cavebornBonusItems.refreshItems();
                        GeneralConfig.randomiteExcludeItems.refreshItems();
                        RandomiteHelper.refreshItems();
                        break;
                    }
                    case "display": {
                        DisplayConfig.syncConfig();
                        break;
                    }
                    case "miningassist": {
                        MiningAssistConfig.syncConfig();
                        if (!event.isWorldRunning()) break;
                        MiningAssistConfig.effectiveItems.refreshItems();
                        MiningAssistConfig.quickTargetBlocks.refreshBlocks();
                        MiningAssistConfig.rangedTargetBlocks.refreshBlocks();
                        MiningAssistConfig.aditTargetBlocks.refreshBlocks();
                        break;
                    }
                    case "dimension.cavern": {
                        CavernConfig.syncConfig();
                        if (!event.isWorldRunning()) break;
                        CavernConfig.triggerItems.refreshItems();
                        CavernConfig.dungeonMobs.refreshEntities();
                        CavernConfig.towerDungeonMobs.refreshEntities();
                        break;
                    }
                    case "dimension.hugeCavern": {
                        HugeCavernConfig.syncConfig();
                        if (!event.isWorldRunning()) break;
                        HugeCavernConfig.triggerItems.refreshItems();
                        break;
                    }
                    case "dimension.aquaCavern": {
                        AquaCavernConfig.syncConfig();
                        if (!event.isWorldRunning()) break;
                        AquaCavernConfig.triggerItems.refreshItems();
                        AquaCavernConfig.dungeonMobs.refreshEntities();
                        AquaCavernConfig.towerDungeonMobs.refreshEntities();
                        break;
                    }
                    case "dimension.caveland": {
                        CavelandConfig.syncConfig();
                        break;
                    }
                    case "dimension.cavenia": {
                        CaveniaConfig.syncConfig();
                        break;
                    }
                    case "dimension.mirageWorlds": {
                        MirageWorldsConfig.syncConfig();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameTextOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = mc.field_71439_g;
        if (mc.field_71474_y.field_74330_P) {
            String name = CaveDimensions.getLocalizedName(mc.field_71441_e.field_73011_w.func_186058_p());
            if (CavernAPI.dimension.isInMirageWorlds((Entity)player)) {
                String dim = "Dim: " + I18n.func_135052_a((String)"dimension.mirageWorlds.name", (Object[])new Object[0]);
                if (Strings.isNullOrEmpty((String)name)) {
                    event.getLeft().add(dim);
                } else {
                    event.getLeft().add(dim + " / " + name);
                }
            } else if (!Strings.isNullOrEmpty((String)name)) {
                event.getLeft().add("Dim: " + name);
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (!Keyboard.getEventKeyState()) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71439_g == null) {
            return;
        }
        int key = Keyboard.getEventKey();
        if (CaveKeyBindings.KEY_MINING_RECORDS.isActiveAndMatches(key)) {
            mc.func_147108_a((GuiScreen)new GuiMiningRecords());
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        GuiScreen gui = event.getGui();
        if (gui != null && GuiModList.class == gui.getClass()) {
            String desc = I18n.func_135052_a((String)"cavern.description", (Object[])new Object[0]);
            if (!Strings.isNullOrEmpty((String)desc)) {
                Cavern.metadata.description = desc;
            }
        } else if (DisplayConfig.customLoadingScreen && CavernAPI.dimension.isInCaveDimensions((Entity)mc.field_71439_g) && (mc.field_71462_r == null || !(mc.field_71462_r instanceof GuiWorldSelection))) {
            if (gui == null) {
                if (mc.field_71462_r != null && GuiDownloadCaveTerrain.class == mc.field_71462_r.getClass()) {
                    event.setGui((GuiScreen)new GuiLoadCaveTerrain());
                }
            } else if (GuiDownloadTerrain.class == gui.getClass()) {
                event.setGui((GuiScreen)new GuiDownloadCaveTerrain());
            }
        }
    }

    @SubscribeEvent
    public void onConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (GeneralConfig.versionNotify) {
            TextComponentTranslation message;
            TextComponentString name = new TextComponentString(Cavern.metadata.name);
            name.func_150256_b().func_150238_a(TextFormatting.AQUA);
            if (Version.isOutdated()) {
                TextComponentString latest = new TextComponentString(Version.getLatest().toString());
                latest.func_150256_b().func_150238_a(TextFormatting.YELLOW);
                message = new TextComponentTranslation("cavern.version.message", new Object[]{name});
                message.func_150258_a(" : ").func_150257_a((ITextComponent)latest);
                message.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, Cavern.metadata.url));
                mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)message);
            }
            message = null;
            if (Version.DEV_DEBUG) {
                message = new TextComponentTranslation("cavern.version.message.dev", new Object[]{name});
            } else if (Version.isBeta()) {
                message = new TextComponentTranslation("cavern.version.message.beta", new Object[]{name});
            } else if (Version.isAlpha()) {
                message = new TextComponentTranslation("cavern.version.message.alpha", new Object[]{name});
            }
            if (message != null) {
                mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)message);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        MiningAssist assist;
        EntityPlayer player = event.player;
        if (MiningAssistConfig.miningAssistNotify && (assist = MiningAssist.byPlayer(player)) != MiningAssist.DISABLED) {
            TextComponentTranslation message = new TextComponentTranslation(assist.getUnlocalizedName(), new Object[0]);
            message.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true));
            message = new TextComponentTranslation("cavern.miningassist.notify.message", new Object[]{message});
            player.func_145747_a((ITextComponent)message);
        }
    }

    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        Entity entity = event.getEntity();
        IBlockState state = event.getState();
        if (CavernAPI.dimension.isInCaveDimensions(entity)) {
            if (state.func_185904_a() == Material.field_151586_h) {
                EntityPlayer player;
                if (entity instanceof EntityPlayer && MinerStats.get(player = (EntityPlayer)entity).getRank() >= MinerRank.AQUA_MINER.getRank()) {
                    GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                    if (player.func_70644_a(MobEffects.field_76427_o)) {
                        event.setDensity(0.005f);
                    } else {
                        event.setDensity(0.01f - (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.003f);
                    }
                    event.setCanceled(true);
                }
            } else if (CavernAPI.dimension.isInCaveland(entity)) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                event.setDensity((float)Math.abs(Math.pow((Math.min(entity.field_70163_u, 20.0) - 63.0) / 192.0, 4.0)));
                event.setCanceled(true);
            } else if (CavernAPI.dimension.isInHugeCavern(entity) || CavernAPI.dimension.isInCavenia(entity) || CavernAPI.dimension.isInDarkForest(entity)) {
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
                event.setDensity(0.005f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onFogColors(EntityViewRenderEvent.FogColors event) {
        Entity entity = event.getEntity();
        float var1 = 0.0f;
        if (CavernAPI.dimension.isInHugeCavern(entity)) {
            var1 = 0.8f;
        } else if (CavernAPI.dimension.isInCaveland(entity)) {
            var1 = 0.7f;
        } else if (CavernAPI.dimension.isInCavenia(entity)) {
            var1 = 0.95f;
        } else if (CavernAPI.dimension.isInDarkForest(entity)) {
            var1 = 0.75f;
        }
        if (var1 > 0.0f) {
            float red = event.getRed();
            float green = event.getGreen();
            float blue = event.getBlue();
            float var2 = 1.0f / red;
            if (var2 > 1.0f / green) {
                var2 = 1.0f / green;
            }
            if (var2 > 1.0f / blue) {
                var2 = 1.0f / blue;
            }
            event.setRed(red * (1.0f - var1) + red * var2 * var1);
            event.setGreen(green * (1.0f - var1) + green * var2 * var1);
            event.setBlue(blue * (1.0f - var1) + blue * var2 * var1);
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        EntityPlayer player = event.getEntity();
        if (!player.func_184587_cr()) {
            return;
        }
        ItemStack using = player.func_184607_cu();
        if (using.func_190926_b()) {
            return;
        }
        if (using.func_77973_b() instanceof ItemBowIce) {
            float f = (float)player.func_184612_cw() / 8.0f;
            f = f > 1.0f ? 1.0f : (f *= f);
            event.setNewfov(event.getFov() * (1.0f - f * 0.15f));
        }
        if (using.func_77973_b() instanceof ItemBowCavenic) {
            ItemBowCavenic.BowMode mode = ItemBowCavenic.BowMode.byItemStack(using);
            float zoom = mode.getZoomScale();
            if (zoom <= 0.0f) {
                return;
            }
            float f = (float)player.func_184612_cw() / mode.getPullingSpeed();
            f = f > 1.0f ? 1.0f : (f *= f);
            event.setNewfov(event.getFov() * (1.0f - f * zoom));
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        IIceEquipment equip;
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof IIceEquipment && (!(equip = (IIceEquipment)stack.func_77973_b()).isHiddenTooltip() || event.getFlags().func_194127_a())) {
            event.getToolTip().add(Cavern.proxy.translateFormat("tooltip.iceEquipment.charge", equip.getCharge(stack)));
        }
    }
}

