/*
 * Decompiled with CFR 0.152.
 */
package cavern.client.handler;

import cavern.api.CavernAPI;
import cavern.api.IMinerStats;
import cavern.api.IMiningData;
import cavern.client.CaveRenderingRegistry;
import cavern.config.DisplayConfig;
import cavern.config.GeneralConfig;
import cavern.config.MiningAssistConfig;
import cavern.config.property.ConfigDisplayPos;
import cavern.miningassist.MiningAssist;
import cavern.stats.MinerRank;
import cavern.stats.MinerStats;
import cavern.stats.MiningData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MinerStatsHUDEventHooks {
    private int posX;
    private int posY;
    private double miningPointPer = -1.0;

    protected ConfigDisplayPos.Type getDisplayType() {
        return DisplayConfig.miningPointPosition.getType();
    }

    protected boolean canRenderHUD(Minecraft mc) {
        ConfigDisplayPos.Type type = this.getDisplayType();
        if (type.isHidden()) {
            return false;
        }
        if (mc.field_71462_r != null && !GuiChat.class.isInstance(mc.field_71462_r)) {
            return false;
        }
        if (!CavernAPI.dimension.isInCaveDimensions((Entity)mc.field_71439_g)) {
            return false;
        }
        for (ItemStack held : mc.field_71439_g.func_184214_aD()) {
            if (!GeneralConfig.isMiningPointItem(held)) continue;
            return true;
        }
        return DisplayConfig.alwaysShowMinerStatus || mc.field_71439_g.field_71075_bZ.field_75098_d || mc.field_71474_y.field_82882_x;
    }

    protected void setDisplayPos(ConfigDisplayPos.Type type, Minecraft mc, int scaledWidth, int scaledHeight) {
        switch (type) {
            case TOP_RIGHT: {
                this.posX = scaledWidth - 20;
                this.posY = 5;
                if (mc.field_71439_g.func_70651_bq().isEmpty()) break;
                this.posY = 30;
                break;
            }
            case TOP_LEFT: {
                this.posX = 5;
                this.posY = 5;
                break;
            }
            case BOTTOM_RIGHT: {
                this.posX = scaledWidth - 20;
                this.posY = scaledHeight - 21;
                break;
            }
            case BOTTOM_LEFT: {
                this.posX = 5;
                this.posY = scaledHeight - 21;
                break;
            }
        }
    }

    protected double calcMiningPointPer(int point, int phase, boolean direct) {
        double per;
        double d = per = point == 0 ? 0.0 : (double)point / (double)phase * 100.0;
        if (direct) {
            return per;
        }
        double diff = Math.abs(per - this.miningPointPer);
        double d1 = 0.0175;
        double d2 = 0.35;
        if (this.miningPointPer < 0.0 || diff < d1) {
            this.miningPointPer = per;
        } else if (per > this.miningPointPer) {
            this.miningPointPer = diff > 1.0 ? (this.miningPointPer += d2) : (this.miningPointPer += d1);
        } else if (per < this.miningPointPer) {
            this.miningPointPer = diff > 1.0 ? (this.miningPointPer -= d2 * 2.0) : (this.miningPointPer -= d1 * 1.5);
        }
        return this.miningPointPer;
    }

    @SubscribeEvent
    public void onRenderGamePostOverlay(RenderGameOverlayEvent.Post event) {
        int comboX;
        int rankY;
        int rankX;
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        ConfigDisplayPos.Type displayType = this.getDisplayType();
        if (!this.canRenderHUD(mc)) {
            this.miningPointPer = -1.0;
            return;
        }
        ScaledResolution resolution = event.getResolution();
        IMinerStats stats = MinerStats.get((EntityPlayer)mc.field_71439_g, true);
        if (stats == null || stats.getPoint() < 0) {
            return;
        }
        MinerRank minerRank = MinerRank.get(stats.getRank());
        MiningAssist miningAssist = MiningAssist.get(stats.getMiningAssist());
        String point = Integer.toString(stats.getPoint());
        String rank = I18n.func_135052_a((String)minerRank.getTranslationKey(), (Object[])new Object[0]);
        if (miningAssist != MiningAssist.DISABLED && stats.getRank() >= MiningAssistConfig.minerRank.getValue()) {
            rank = rank + " / " + I18n.func_135052_a((String)miningAssist.getUnlocalizedName(), (Object[])new Object[0]);
        }
        this.setDisplayPos(displayType, mc, resolution.func_78326_a(), resolution.func_78328_b());
        int x = this.posX;
        int y = this.posY;
        RenderItem renderItem = mc.func_175599_af();
        FontRenderer renderer = mc.field_71466_p;
        boolean flag = false;
        IMiningData data = MiningData.get((EntityPlayer)mc.field_71439_g);
        long processTime = mc.field_71441_e.func_82737_E() - data.getLastMiningTime();
        if (data.getLastMiningTime() > 0L && processTime < 50L && data.getLastMiningBlock() != null && data.getLastMiningPoint() != 0) {
            IBlockState state = data.getLastMiningBlock();
            ItemStack stack = new ItemStack(CaveRenderingRegistry.getRenderBlock(state.func_177230_c()), 1, state.func_177230_c().func_176201_c(state));
            RenderHelper.func_74520_c();
            renderItem.func_175042_a(stack, x, y);
            renderItem.func_180453_a(renderer, stack, x, y, Integer.toString(data.getLastMiningPoint()));
            RenderHelper.func_74518_a();
            flag = true;
        }
        if (flag) {
            x += displayType.isLeft() ? 20 : -20;
        }
        renderItem.func_175042_a(minerRank.getItemStack(), x, y);
        GlStateManager.func_179094_E();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        if (point.length() <= 1) {
            point = " " + point;
        }
        MinerRank nextRank = MinerRank.get(stats.getRank() + 1);
        if (minerRank.getRank() < nextRank.getRank()) {
            String per = String.format("%.2f", this.calcMiningPointPer(stats.getPoint(), nextRank.getPhase(), false)) + "%";
            point = displayType.isLeft() ? point + " < " + per : per + " > " + point;
        }
        String combo = null;
        if (data.getMiningCombo() > 0) {
            TextFormatting format = TextFormatting.WHITE;
            if (processTime < 60L) {
                format = TextFormatting.BOLD;
            } else if (processTime > 240L) {
                format = TextFormatting.GRAY;
            }
            combo = format + String.format("%d COMBO!", data.getMiningCombo()) + TextFormatting.RESET;
        }
        boolean showRank = DisplayConfig.showMinerRank;
        boolean hasCombo = combo != null;
        int pointX = displayType.isLeft() ? x + 5 : x + 17 - renderer.func_78256_a(point);
        int pointY = y + 9;
        int n = showRank ? (displayType.isLeft() ? this.posX + 5 : this.posX + 17 - renderer.func_78256_a(rank)) : (rankX = -1);
        int n2 = showRank ? (displayType.isTop() ? y + 21 : y - 12) : (rankY = -1);
        int n3 = hasCombo ? (displayType.isLeft() ? this.posX + 5 : this.posX + 17 - renderer.func_78256_a(combo)) : (comboX = -1);
        int comboY = hasCombo ? (displayType.isTop() ? y + 33 : y - 24) : -1;
        renderer.func_175063_a(point, (float)pointX, (float)pointY, 0xCECECE);
        if (showRank) {
            renderer.func_175063_a(rank, (float)rankX, (float)rankY, 0xCECECE);
            if (hasCombo) {
                renderer.func_175063_a(combo, (float)comboX, (float)comboY, 0xFFFFFF);
            }
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

