/*
 * Decompiled with CFR 0.152.
 */
package cavern.config;

import cavern.block.BlockCave;
import cavern.block.CaveBlocks;
import cavern.client.config.CaveConfigEntries;
import cavern.config.CavernConfig;
import cavern.config.Config;
import cavern.config.manager.CaveBiome;
import cavern.config.manager.CaveBiomeManager;
import cavern.config.manager.CaveVein;
import cavern.config.manager.CaveVeinManager;
import cavern.config.property.ConfigBiomeType;
import cavern.config.property.ConfigEntities;
import cavern.config.property.ConfigItems;
import cavern.core.Cavern;
import cavern.entity.EntityCavenicSkeleton;
import cavern.entity.EntityCavenicSpider;
import cavern.entity.EntityCavenicZombie;
import cavern.util.BlockMeta;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStone;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.io.FileUtils;

public class AquaCavernConfig {
    public static Configuration config;
    public static int dimensionId;
    public static int worldHeight;
    public static ConfigBiomeType biomeType;
    public static ConfigItems triggerItems;
    public static double floodDepth;
    public static boolean generateCaves;
    public static boolean generateRavine;
    public static boolean generateDungeons;
    public static boolean generateTowerDungeons;
    public static ConfigEntities dungeonMobs;
    public static ConfigEntities towerDungeonMobs;
    public static double caveBrightness;
    public static CaveBiomeManager biomeManager;
    public static CaveVeinManager veinManager;

    public static void syncConfig() {
        String category = "dimension";
        ArrayList propOrder = Lists.newArrayList();
        if (config == null) {
            config = Config.loadConfig("aquacavern", category);
        }
        Property prop = config.get(category, "dimension", -52);
        prop.setRequiresMcRestart(true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        String comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        dimensionId = prop.getInt(dimensionId);
        prop = config.get(category, "worldHeight", Config.highProfiles ? 256 : 128);
        prop.setMinValue(64).setMaxValue(256);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        worldHeight = prop.getInt(worldHeight);
        prop = config.get(category, "biomeType", ConfigBiomeType.Type.NATURAL.ordinal());
        prop.setMinValue(0).setMaxValue(ConfigBiomeType.Type.values().length - 1).setConfigEntryClass(CaveConfigEntries.cycleInteger);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        int min = Integer.parseInt(prop.getMinValue());
        int max = Integer.parseInt(prop.getMaxValue());
        for (int i = min; i <= max; ++i) {
            comment = comment + Configuration.NEW_LINE + i + ": " + Cavern.proxy.translate(prop.getLanguageKey() + "." + i);
            if (i >= max) continue;
            comment = comment + ",";
        }
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        biomeType.setValue(prop.getInt(biomeType.getValue()));
        prop = config.get(category, "triggerItems", new String[0]);
        prop.setConfigEntryClass(CaveConfigEntries.selectBlocksAndItems);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        triggerItems.setValues(prop.getStringList());
        prop = config.get(category, "floodDepth", 1.0);
        prop.setMinValue(0.0).setMaxValue(1.0);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        floodDepth = prop.getDouble(floodDepth);
        prop = config.get(category, "generateCaves", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateCaves = prop.getBoolean(generateCaves);
        prop = config.get(category, "generateRavine", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateRavine = prop.getBoolean(generateRavine);
        prop = config.get(category, "generateDungeons", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateDungeons = prop.getBoolean(generateDungeons);
        prop = config.get(category, "generateTowerDungeons", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateTowerDungeons = prop.getBoolean(generateTowerDungeons);
        HashSet mobs = Sets.newHashSet();
        mobs.add(EntityZombie.class);
        mobs.add(EntitySkeleton.class);
        mobs.add(EntitySpider.class);
        prop = config.get(category, "dungeonMobs", (String[])mobs.stream().map(EntityList::func_191306_a).map(ResourceLocation::toString).sorted().toArray(String[]::new));
        prop.setConfigEntryClass(CaveConfigEntries.selectMobs);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        dungeonMobs.setValues(prop.getStringList());
        mobs.clear();
        mobs.add(EntityZombie.class);
        mobs.add(EntitySkeleton.class);
        mobs.add(EntitySpider.class);
        mobs.add(EntityCaveSpider.class);
        mobs.add(EntityEnderman.class);
        mobs.add(EntityCavenicSkeleton.class);
        mobs.add(EntityCavenicZombie.class);
        mobs.add(EntityCavenicSpider.class);
        prop = config.get(category, "towerDungeonMobs", (String[])mobs.stream().map(EntityList::func_191306_a).map(ResourceLocation::toString).sorted().toArray(String[]::new));
        prop.setConfigEntryClass(CaveConfigEntries.selectMobs);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        towerDungeonMobs.setValues(prop.getStringList());
        prop = config.get(category, "caveBrightness", 0.075);
        prop.setMinValue(0.0).setMaxValue(1.0);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        caveBrightness = prop.getDouble(caveBrightness);
        config.setCategoryPropertyOrder(category, (List)propOrder);
        Config.saveConfig(config);
    }

    public static void syncBiomesConfig() {
        if (AquaCavernConfig.biomeManager.config == null) {
            AquaCavernConfig.biomeManager.config = Config.loadConfig("aquacavern", "biomes");
        } else {
            biomeManager.getCaveBiomes().clear();
        }
        if (AquaCavernConfig.biomeManager.config.getCategoryNames().isEmpty()) {
            ArrayList biomes = Lists.newArrayList();
            biomes.add(new CaveBiome(Biomes.field_76771_b, 100));
            biomes.add(new CaveBiome(Biomes.field_76772_c, 50));
            biomes.add(new CaveBiome(Biomes.field_76769_d, 10));
            biomes.add(new CaveBiome(Biomes.field_76786_s, 5));
            biomes.add(new CaveBiome(Biomes.field_76767_f, 50));
            biomes.add(new CaveBiome(Biomes.field_76785_t, 10));
            biomes.add(new CaveBiome(Biomes.field_76768_g, 70));
            biomes.add(new CaveBiome(Biomes.field_76784_u, 10));
            biomes.add(new CaveBiome(Biomes.field_76782_w, 50));
            biomes.add(new CaveBiome(Biomes.field_76792_x, 10));
            biomes.add(new CaveBiome(Biomes.field_76780_h, 30));
            biomes.add(new CaveBiome(Biomes.field_76770_e, 20));
            biomes.add(new CaveBiome(Biomes.field_76774_n, 80));
            biomes.add(new CaveBiome(Biomes.field_76775_o, 10));
            biomes.add(new CaveBiome(Biomes.field_150588_X, 50));
            biomes.add(new CaveBiome(Biomes.field_150589_Z, 30, new BlockMeta(Blocks.field_180395_cM.func_176223_P())));
            CavernConfig.generateBiomesConfig(biomeManager, biomes);
        } else {
            CavernConfig.addBiomesFromConfig(biomeManager);
        }
        Config.saveConfig(AquaCavernConfig.biomeManager.config);
    }

    public static void syncVeinsConfig() {
        if (AquaCavernConfig.veinManager.config == null) {
            AquaCavernConfig.veinManager.config = Config.loadConfig("aquacavern", "veins");
        } else {
            veinManager.getCaveVeins().clear();
        }
        if (AquaCavernConfig.veinManager.config.getCategoryNames().isEmpty()) {
            ArrayList veins = Lists.newArrayList();
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.GRANITE.func_176642_a()), 30, 25, 1, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.DIORITE.func_176642_a()), 32, 25, 1, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.ANDESITE.func_176642_a()), 32, 25, 1, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150365_q, 0), 40, 17, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150366_p, 0), 40, 10, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150352_o, 0), 8, 7, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150450_ax, 0), 12, 7, 1, 40, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150369_x, 0), 8, 5, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150482_ag, 0), 3, 6, 1, 20, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150412_bA, 0), 8, 5, 50, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.AQUAMARINE_ORE.getMetadata()), 30, 8, 20, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.MAGNITE_ORE.getMetadata()), 35, 10, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.RANDOMITE_ORE.getMetadata()), 28, 6, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.HEXCITE_ORE.getMetadata()), 6, 5, 1, 30, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.FISSURED_STONE.getMetadata()), 70, 3, 1, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150346_d, 0), 20, 25, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150351_n, 0), 10, 20, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150435_aG, 0), 30, 20, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta((Block)Blocks.field_150354_m, BlockSand.EnumType.SAND.func_176688_a()), 15, 20, 1, 127, new Object[0]));
            if (Config.highProfiles) {
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150365_q, 0), 35, 20, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150366_p, 0), 30, 12, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150352_o, 0), 5, 8, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150369_x, 0), 4, 7, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.AQUAMARINE_ORE.getMetadata()), 12, 12, 128, 255, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET));
                veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.MAGNITE_ORE.getMetadata()), 30, 10, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.RANDOMITE_ORE.getMetadata()), 28, 4, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.HEXCITE_ORE.getMetadata()), 4, 5, 200, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150346_d, 0), 20, 25, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150351_n, 0), 10, 20, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150435_aG, 0), 30, 20, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta((Block)Blocks.field_150354_m, BlockSand.EnumType.SAND.func_176688_a()), 10, 20, 128, 255, BiomeDictionary.Type.SANDY));
            }
            CavernConfig.generateVeinsConfig(veinManager, veins);
        } else if (CavernConfig.addVeinsFromConfig(veinManager)) {
            try {
                FileUtils.forceDelete((File)new File(AquaCavernConfig.veinManager.config.toString()));
                veinManager.getCaveVeins().clear();
                AquaCavernConfig.veinManager.config = null;
                AquaCavernConfig.syncVeinsConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Config.saveConfig(AquaCavernConfig.veinManager.config);
    }

    static {
        biomeType = new ConfigBiomeType();
        triggerItems = new ConfigItems();
        dungeonMobs = new ConfigEntities();
        towerDungeonMobs = new ConfigEntities();
        biomeManager = new CaveBiomeManager();
        veinManager = new CaveVeinManager();
    }
}

