/*
 * Decompiled with CFR 0.152.
 */
package cavern.config;

import cavern.block.BlockCave;
import cavern.block.CaveBlocks;
import cavern.client.config.CaveConfigEntries;
import cavern.config.Config;
import cavern.config.manager.CaveBiome;
import cavern.config.manager.CaveBiomeManager;
import cavern.config.manager.CaveVein;
import cavern.config.manager.CaveVeinManager;
import cavern.config.property.ConfigBiomeType;
import cavern.config.property.ConfigEntities;
import cavern.config.property.ConfigItems;
import cavern.core.Cavern;
import cavern.entity.EntityCavenicSkeleton;
import cavern.entity.EntityCavenicSpider;
import cavern.entity.EntityCavenicZombie;
import cavern.util.BlockMeta;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStone;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CavernConfig {
    public static Configuration config;
    public static int dimensionId;
    public static int worldHeight;
    public static ConfigBiomeType biomeType;
    public static ConfigItems triggerItems;
    public static boolean generateCaves;
    public static boolean generateRavine;
    public static boolean generateExtremeCaves;
    public static boolean generateExtremeRavine;
    public static boolean generateLakes;
    public static boolean generateDungeons;
    public static boolean generateTowerDungeons;
    public static boolean generateMirageLibrary;
    public static boolean generateMineshaft;
    public static ConfigEntities dungeonMobs;
    public static ConfigEntities towerDungeonMobs;
    public static int monsterSpawn;
    public static double caveBrightness;
    public static CaveBiomeManager biomeManager;
    public static CaveVeinManager veinManager;

    public static void syncConfig() {
        String category = "dimension";
        ArrayList propOrder = Lists.newArrayList();
        if (config == null) {
            config = Config.loadConfig("cavern", category);
        }
        Property prop = config.get(category, "dimension", -50);
        prop.setRequiresMcRestart(true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        String comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        dimensionId = prop.getInt(dimensionId);
        prop = config.get(category, "worldHeight", Config.highProfiles ? 256 : 128);
        prop.setMinValue(64).setMaxValue(256);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        worldHeight = prop.getInt(worldHeight);
        prop = config.get(category, "biomeType", ConfigBiomeType.Type.NATURAL.ordinal());
        prop.setMinValue(0).setMaxValue(ConfigBiomeType.Type.values().length - 1).setConfigEntryClass(CaveConfigEntries.cycleInteger);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        int min = Integer.parseInt(prop.getMinValue());
        int max = Integer.parseInt(prop.getMaxValue());
        for (int i = min; i <= max; ++i) {
            comment = comment + Configuration.NEW_LINE + i + ": " + Cavern.proxy.translate(prop.getLanguageKey() + "." + i);
            if (i >= max) continue;
            comment = comment + ",";
        }
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        biomeType.setValue(prop.getInt(biomeType.getValue()));
        prop = config.get(category, "triggerItems", new String[0]);
        prop.setConfigEntryClass(CaveConfigEntries.selectBlocksAndItems);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        triggerItems.setValues(prop.getStringList());
        prop = config.get(category, "generateCaves", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateCaves = prop.getBoolean(generateCaves);
        prop = config.get(category, "generateRavine", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateRavine = prop.getBoolean(generateRavine);
        prop = config.get(category, "generateExtremeCaves", Config.highProfiles);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateExtremeCaves = prop.getBoolean(generateExtremeCaves);
        prop = config.get(category, "generateExtremeRavine", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateExtremeRavine = prop.getBoolean(generateExtremeRavine);
        prop = config.get(category, "generateLakes", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateLakes = prop.getBoolean(generateLakes);
        prop = config.get(category, "generateDungeons", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateDungeons = prop.getBoolean(generateDungeons);
        prop = config.get(category, "generateTowerDungeons", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateTowerDungeons = prop.getBoolean(generateTowerDungeons);
        prop = config.get(category, "generateMirageLibrary", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateMirageLibrary = prop.getBoolean(generateMirageLibrary);
        prop = config.get(category, "generateMineshaft", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateMineshaft = prop.getBoolean(generateMineshaft);
        HashSet mobs = Sets.newHashSet();
        mobs.add(EntityZombie.class);
        mobs.add(EntitySkeleton.class);
        mobs.add(EntitySpider.class);
        mobs.add(EntityCaveSpider.class);
        mobs.add(EntityCreeper.class);
        mobs.add(EntityEnderman.class);
        mobs.add(EntitySilverfish.class);
        prop = config.get(category, "dungeonMobs", (String[])mobs.stream().map(EntityList::func_191306_a).map(ResourceLocation::toString).sorted().toArray(String[]::new));
        prop.setConfigEntryClass(CaveConfigEntries.selectMobs);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        dungeonMobs.setValues(prop.getStringList());
        mobs.clear();
        mobs.add(EntityZombie.class);
        mobs.add(EntitySkeleton.class);
        mobs.add(EntitySpider.class);
        mobs.add(EntityCaveSpider.class);
        mobs.add(EntityEnderman.class);
        mobs.add(EntityCavenicSkeleton.class);
        mobs.add(EntityCavenicZombie.class);
        mobs.add(EntityCavenicSpider.class);
        prop = config.get(category, "towerDungeonMobs", (String[])mobs.stream().map(EntityList::func_191306_a).map(ResourceLocation::toString).sorted().toArray(String[]::new));
        prop.setConfigEntryClass(CaveConfigEntries.selectMobs);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        towerDungeonMobs.setValues(prop.getStringList());
        prop = config.get(category, "monsterSpawn", Config.highProfiles ? 200 : 0);
        prop.setMinValue(0).setMaxValue(5000);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        monsterSpawn = prop.getInt(monsterSpawn);
        prop = config.get(category, "caveBrightness", 0.035);
        prop.setMinValue(0.0).setMaxValue(1.0);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        caveBrightness = prop.getDouble(caveBrightness);
        config.setCategoryPropertyOrder(category, (List)propOrder);
        Config.saveConfig(config);
    }

    public static void syncBiomesConfig() {
        if (CavernConfig.biomeManager.config == null) {
            CavernConfig.biomeManager.config = Config.loadConfig("cavern", "biomes");
        } else {
            biomeManager.getCaveBiomes().clear();
        }
        if (CavernConfig.biomeManager.config.getCategoryNames().isEmpty()) {
            ArrayList biomes = Lists.newArrayList();
            biomes.add(new CaveBiome(Biomes.field_76771_b, 15));
            biomes.add(new CaveBiome(Biomes.field_76772_c, 100));
            biomes.add(new CaveBiome(Biomes.field_76769_d, 70));
            biomes.add(new CaveBiome(Biomes.field_76786_s, 10));
            biomes.add(new CaveBiome(Biomes.field_76767_f, 80));
            biomes.add(new CaveBiome(Biomes.field_76785_t, 10));
            biomes.add(new CaveBiome(Biomes.field_76768_g, 80));
            biomes.add(new CaveBiome(Biomes.field_76784_u, 10));
            biomes.add(new CaveBiome(Biomes.field_76782_w, 80));
            biomes.add(new CaveBiome(Biomes.field_76792_x, 10));
            biomes.add(new CaveBiome(Biomes.field_76780_h, 60));
            biomes.add(new CaveBiome(Biomes.field_76770_e, 50));
            biomes.add(new CaveBiome(Biomes.field_150588_X, 50));
            biomes.add(new CaveBiome(Biomes.field_150589_Z, 50));
            CavernConfig.generateBiomesConfig(biomeManager, biomes);
        } else {
            CavernConfig.addBiomesFromConfig(biomeManager);
        }
        Config.saveConfig(CavernConfig.biomeManager.config);
    }

    public static void syncVeinsConfig() {
        if (CavernConfig.veinManager.config == null) {
            CavernConfig.veinManager.config = Config.loadConfig("cavern", "veins");
        } else {
            veinManager.getCaveVeins().clear();
        }
        if (CavernConfig.veinManager.config.getCategoryNames().isEmpty()) {
            ArrayList veins = Lists.newArrayList();
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.GRANITE.func_176642_a()), 28, 25, 1, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.DIORITE.func_176642_a()), 28, 25, 1, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.ANDESITE.func_176642_a()), 30, 25, 1, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150365_q, 0), 35, 17, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150366_p, 0), 30, 10, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150352_o, 0), 5, 7, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150450_ax, 0), 12, 7, 1, 40, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150369_x, 0), 4, 5, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150482_ag, 0), 2, 6, 1, 20, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150412_bA, 0), 8, 5, 50, 127, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.AQUAMARINE_ORE.getMetadata()), 12, 8, 20, 127, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.MAGNITE_ORE.getMetadata()), 30, 10, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.RANDOMITE_ORE.getMetadata()), 24, 4, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.HEXCITE_ORE.getMetadata()), 4, 5, 1, 30, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.FISSURED_STONE.getMetadata()), 60, 2, 1, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150346_d, 0), 20, 25, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150351_n, 0), 10, 20, 1, 127, new Object[0]));
            veins.add(new CaveVein(new BlockMeta((Block)Blocks.field_150354_m, BlockSand.EnumType.SAND.func_176688_a()), 10, 20, 1, 127, BiomeDictionary.Type.SANDY));
            if (Config.highProfiles) {
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150365_q, 0), 35, 18, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150366_p, 0), 30, 10, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150352_o, 0), 5, 7, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150369_x, 0), 4, 6, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.AQUAMARINE_ORE.getMetadata()), 12, 8, 128, 255, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET));
                veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.MAGNITE_ORE.getMetadata()), 30, 10, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.RANDOMITE_ORE.getMetadata()), 28, 2, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.HEXCITE_ORE.getMetadata()), 4, 5, 200, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150346_d, 0), 20, 25, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta(Blocks.field_150351_n, 0), 10, 20, 128, 255, new Object[0]));
                veins.add(new CaveVein(new BlockMeta((Block)Blocks.field_150354_m, BlockSand.EnumType.SAND.func_176688_a()), 10, 20, 128, 255, BiomeDictionary.Type.SANDY));
            }
            CavernConfig.generateVeinsConfig(veinManager, veins);
        } else if (CavernConfig.addVeinsFromConfig(veinManager)) {
            try {
                FileUtils.forceDelete((File)new File(CavernConfig.veinManager.config.toString()));
                veinManager.getCaveVeins().clear();
                CavernConfig.veinManager.config = null;
                CavernConfig.syncVeinsConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Config.saveConfig(CavernConfig.veinManager.config);
    }

    public static void generateBiomesConfig(CaveBiomeManager manager, Collection<CaveBiome> biomes) {
        String category = "biomes";
        for (CaveBiome caveBiome : biomes) {
            Biome biome = caveBiome.getBiome();
            String entry = biome.getRegistryName().toString();
            ArrayList propOrder = Lists.newArrayList();
            Property prop = manager.config.get(entry, "weight", 0);
            prop.setMinValue(0).setMaxValue(100);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            String comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + "]";
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(caveBiome.getWeight());
            prop = manager.config.get(entry, "terrainBlock", biome.field_76753_B.func_177230_c().getRegistryName().toString());
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(caveBiome.getTerrainBlock().getBlockName());
            prop = manager.config.get(entry, "terrainBlockMeta", Integer.toString(biome.field_76753_B.func_177230_c().func_176201_c(biome.field_76753_B)));
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(caveBiome.getTerrainBlock().getMetaString());
            prop = manager.config.get(entry, "topBlock", biome.field_76752_A.func_177230_c().getRegistryName().toString());
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(caveBiome.getTopBlock().getBlockName());
            prop = manager.config.get(entry, "topBlockMeta", Integer.toString(biome.field_76752_A.func_177230_c().func_176201_c(biome.field_76752_A)));
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(caveBiome.getTopBlock().getMetaString());
            manager.config.setCategoryPropertyOrder(entry, (List)propOrder);
            manager.addCaveBiome(caveBiome);
        }
    }

    public static void addBiomesFromConfig(CaveBiomeManager manager) {
        for (String name : manager.config.getCategoryNames()) {
            Biome biome = Config.getBiomeFromString(name);
            if (biome == null) continue;
            ConfigCategory category = manager.config.getCategory(name);
            int weight = category.get("weight").getInt();
            String terrainBlock = category.get("terrainBlock").getString();
            String terrainBlockMeta = category.get("terrainBlockMeta").getString();
            String topBlock = category.get("topBlock").getString();
            String topBlockMeta = category.get("topBlockMeta").getString();
            CaveBiome caveBiome = new CaveBiome(biome, weight);
            caveBiome.setTerrainBlock(new BlockMeta(terrainBlock, terrainBlockMeta));
            caveBiome.setTopBlock(new BlockMeta(topBlock, topBlockMeta));
            manager.addCaveBiome(caveBiome);
        }
    }

    public static void generateVeinsConfig(CaveVeinManager manager, Collection<CaveVein> veins) {
        String category = "veins";
        String blockDefault = Blocks.field_150348_b.getRegistryName().toString();
        int index = 0;
        for (CaveVein vein : veins) {
            String entry = Integer.toString(index);
            ArrayList propOrder = Lists.newArrayList();
            Property prop = manager.config.get(entry, "block", blockDefault);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            String comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getBlockMeta().getBlockName());
            prop = manager.config.get(entry, "blockMeta", Integer.toString(0));
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getBlockMeta().getMetaString());
            prop = manager.config.get(entry, "targetBlock", blockDefault);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getTarget().getBlockName());
            prop = manager.config.get(entry, "targetBlockMeta", Integer.toString(0));
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getTarget().getMetaString());
            prop = manager.config.get(entry, "weight", 1);
            prop.setMinValue(0).setMaxValue(100);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + "]";
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getWeight());
            prop = manager.config.get(entry, "chance", 1.0);
            prop.setMinValue(0.0).setMaxValue(1.0);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getChance());
            prop = manager.config.get(entry, "size", 1);
            prop.setMinValue(0).setMaxValue(100);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + "]";
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getSize());
            prop = manager.config.get(entry, "minHeight", 0);
            prop.setMinValue(0).setMaxValue(255);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getMinHeight());
            prop = manager.config.get(entry, "maxHeight", 255);
            prop.setMinValue(0).setMaxValue(255);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getMaxHeight());
            prop = manager.config.get(entry, "biomes", new String[0]);
            prop.setMaxListLength(256);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            prop.setComment(comment);
            propOrder.add(prop.getName());
            prop.set(vein.getBiomes());
            manager.config.setCategoryPropertyOrder(entry, (List)propOrder);
            manager.addCaveVein(vein);
            ++index;
        }
    }

    public static boolean addVeinsFromConfig(CaveVeinManager manager) {
        boolean flag = false;
        for (String name : manager.config.getCategoryNames()) {
            if (NumberUtils.isCreatable((String)name)) {
                try {
                    ConfigCategory category = manager.config.getCategory(name);
                    String block = category.get("block").getString();
                    String blockMeta = category.get("blockMeta").getString();
                    String targetBlock = category.get("targetBlock").getString();
                    String targetBlockMeta = category.get("targetBlockMeta").getString();
                    int weight = category.get("weight").getInt();
                    double chance = category.get("chance").getDouble();
                    int size = category.get("size").getInt();
                    int minHeight = category.get("minHeight").getInt();
                    int maxHeight = category.get("maxHeight").getInt();
                    String[] biomes = category.get("biomes").getStringList();
                    CaveVein vein = new CaveVein();
                    vein.setBlockMeta(new BlockMeta(block, blockMeta));
                    vein.setTarget(new BlockMeta(targetBlock, targetBlockMeta));
                    vein.setWeight(weight);
                    vein.setChance(chance);
                    vein.setSize(size);
                    vein.setMinHeight(minHeight);
                    vein.setMaxHeight(maxHeight);
                    vein.setBiomes(biomes);
                    manager.addCaveVein(vein);
                }
                catch (Exception exception) {}
                continue;
            }
            flag = true;
        }
        return flag;
    }

    static {
        biomeType = new ConfigBiomeType();
        triggerItems = new ConfigItems();
        dungeonMobs = new ConfigEntities();
        towerDungeonMobs = new ConfigEntities();
        biomeManager = new CaveBiomeManager();
        veinManager = new CaveVeinManager();
    }
}

