/*
 * Decompiled with CFR 0.152.
 */
package cavern.config;

import cavern.config.CaveConfiguration;
import cavern.config.ConfigChecker;
import cavern.util.CaveLog;
import com.google.common.base.Strings;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.Level;

public class Config {
    public static final String LANG_KEY = "cavern.config.";
    protected static final Side SIDE = FMLLaunchHandler.side();
    public static ConfigChecker configChecker;
    public static boolean highProfiles;

    public static boolean updateConfig() {
        if (configChecker == null) {
            File dir = Config.getConfigDir();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(dir, "internal.properties");
            configChecker = new ConfigChecker(file, dir);
        }
        return configChecker.updateConfigFiles();
    }

    public static File getConfigDir() {
        return new File(Loader.instance().getConfigDir(), "cavern");
    }

    public static File getConfigFile(String name) {
        File dir = Config.getConfigDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, name + ".cfg");
    }

    public static Configuration loadConfig(String name) {
        File file = Config.getConfigFile(name);
        CaveConfiguration config = new CaveConfiguration(file, true);
        try {
            config.load();
        }
        catch (Exception e) {
            File dest = new File(file.getParentFile(), file.getName() + ".bak");
            if (dest.exists()) {
                dest.delete();
            }
            file.renameTo(dest);
            CaveLog.log(Level.ERROR, e, "A critical error occured reading the " + file.getName() + " file, defaults will be used - the invalid file is backed up at " + dest.getName(), new Object[0]);
        }
        return config;
    }

    public static File getConfigFile(String name, String category) {
        File dir = Config.getConfigDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, name + "-" + category + ".cfg");
    }

    public static Configuration loadConfig(String name, String category) {
        File file = Config.getConfigFile(name, category);
        CaveConfiguration config = new CaveConfiguration(file, true);
        try {
            config.load();
        }
        catch (Exception e) {
            File dest = new File(file.getParentFile(), file.getName() + ".bak");
            if (dest.exists()) {
                dest.delete();
            }
            file.renameTo(dest);
            CaveLog.log(Level.ERROR, e, "A critical error occured reading the " + file.getName() + " file, defaults will be used - the invalid file is backed up at " + dest.getName(), new Object[0]);
        }
        return config;
    }

    public static void saveConfig(@Nullable Configuration config) {
        if (config != null && config.hasChanged()) {
            config.save();
        }
    }

    @Nullable
    public static Biome getBiomeFromString(@Nullable String str) {
        return Config.getBiomeFromString(str, null);
    }

    public static Biome getBiomeFromString(@Nullable String str, @Nullable Biome fallback) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        if (NumberUtils.isCreatable((String)str)) {
            int id = NumberUtils.toInt((String)str, (int)-1);
            if (id < 0 || id > 255) {
                return null;
            }
            return Biome.func_180276_a((int)id, (Biome)fallback);
        }
        ResourceLocation key = new ResourceLocation(str);
        return (Biome)ObjectUtils.defaultIfNull((Object)Biome.field_185377_q.func_82594_a((Object)key), (Object)fallback);
    }

    public static boolean containsBiome(@Nullable String[] biomes, @Nullable Biome biome) {
        if (biomes == null || biomes.length <= 0) {
            return false;
        }
        if (biome == null) {
            return false;
        }
        for (String str : biomes) {
            if (!(NumberUtils.isCreatable((String)str) ? NumberUtils.toInt((String)str, (int)-1) == Biome.func_185362_a((Biome)biome) : str.equals(biome.getRegistryName().toString()))) continue;
            return true;
        }
        return false;
    }
}

