/*
 * Decompiled with CFR 0.152.
 */
package cavern.config;

import cavern.block.BlockCave;
import cavern.block.CaveBlocks;
import cavern.client.config.CaveConfigEntries;
import cavern.config.CavernConfig;
import cavern.config.Config;
import cavern.config.manager.CaveBiome;
import cavern.config.manager.CaveBiomeManager;
import cavern.config.manager.CaveVein;
import cavern.config.manager.CaveVeinManager;
import cavern.config.property.ConfigBiomeType;
import cavern.config.property.ConfigItems;
import cavern.core.Cavern;
import cavern.util.BlockMeta;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStone;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.io.FileUtils;

public class HugeCavernConfig {
    public static Configuration config;
    public static int dimensionId;
    public static int worldHeight;
    public static ConfigBiomeType biomeType;
    public static ConfigItems triggerItems;
    public static boolean generateCaves;
    public static boolean generateLakes;
    public static int monsterSpawn;
    public static double caveBrightness;
    public static CaveBiomeManager biomeManager;
    public static CaveVeinManager veinManager;

    public static void syncConfig() {
        String category = "dimension";
        ArrayList propOrder = Lists.newArrayList();
        if (config == null) {
            config = Config.loadConfig("hugecavern", category);
        }
        Property prop = config.get(category, "dimension", -51);
        prop.setRequiresMcRestart(true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        String comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        dimensionId = prop.getInt(dimensionId);
        prop = config.get(category, "worldHeight", Config.highProfiles ? 256 : 128);
        prop.setMinValue(64).setMaxValue(256);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        worldHeight = prop.getInt(worldHeight);
        prop = config.get(category, "biomeType", ConfigBiomeType.Type.NATURAL.ordinal());
        prop.setMinValue(0).setMaxValue(ConfigBiomeType.Type.values().length - 1).setConfigEntryClass(CaveConfigEntries.cycleInteger);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        int min = Integer.parseInt(prop.getMinValue());
        int max = Integer.parseInt(prop.getMaxValue());
        for (int i = min; i <= max; ++i) {
            comment = comment + Configuration.NEW_LINE + i + ": " + Cavern.proxy.translate(prop.getLanguageKey() + "." + i);
            if (i >= max) continue;
            comment = comment + ",";
        }
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        biomeType.setValue(prop.getInt(biomeType.getValue()));
        prop = config.get(category, "triggerItems", new String[0]);
        prop.setConfigEntryClass(CaveConfigEntries.selectBlocksAndItems);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        triggerItems.setValues(prop.getStringList());
        prop = config.get(category, "generateCaves", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateCaves = prop.getBoolean(generateCaves);
        prop = config.get(category, "generateLakes", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        generateLakes = prop.getBoolean(generateLakes);
        prop = config.get(category, "monsterSpawn", Config.highProfiles ? 100 : 0);
        prop.setMinValue(0).setMaxValue(5000);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        monsterSpawn = prop.getInt(monsterSpawn);
        prop = config.get(category, "caveBrightness", 0.095);
        prop.setMinValue(0.0).setMaxValue(1.0);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        caveBrightness = prop.getDouble(caveBrightness);
        config.setCategoryPropertyOrder(category, (List)propOrder);
        Config.saveConfig(config);
    }

    public static void syncBiomesConfig() {
        if (HugeCavernConfig.biomeManager.config == null) {
            HugeCavernConfig.biomeManager.config = Config.loadConfig("hugecavern", "biomes");
        } else {
            biomeManager.getCaveBiomes().clear();
        }
        if (HugeCavernConfig.biomeManager.config.getCategoryNames().isEmpty()) {
            ArrayList biomes = Lists.newArrayList();
            biomes.add(new CaveBiome(Biomes.field_76771_b, 15));
            biomes.add(new CaveBiome(Biomes.field_76772_c, 100));
            biomes.add(new CaveBiome(Biomes.field_76769_d, 70));
            biomes.add(new CaveBiome(Biomes.field_76786_s, 10));
            biomes.add(new CaveBiome(Biomes.field_76767_f, 80));
            biomes.add(new CaveBiome(Biomes.field_76785_t, 10));
            biomes.add(new CaveBiome(Biomes.field_76768_g, 80));
            biomes.add(new CaveBiome(Biomes.field_76784_u, 10));
            biomes.add(new CaveBiome(Biomes.field_76782_w, 80, null, new BlockMeta(Blocks.field_150351_n.func_176223_P())));
            biomes.add(new CaveBiome(Biomes.field_76792_x, 10, null, new BlockMeta(Blocks.field_150351_n.func_176223_P())));
            biomes.add(new CaveBiome(Biomes.field_76780_h, 60));
            biomes.add(new CaveBiome(Biomes.field_76770_e, 50));
            biomes.add(new CaveBiome(Biomes.field_150588_X, 50));
            biomes.add(new CaveBiome(Biomes.field_150589_Z, 50, null, new BlockMeta(Blocks.field_180395_cM.func_176223_P())));
            CavernConfig.generateBiomesConfig(biomeManager, biomes);
        } else {
            CavernConfig.addBiomesFromConfig(biomeManager);
        }
        Config.saveConfig(HugeCavernConfig.biomeManager.config);
    }

    public static void syncVeinsConfig() {
        if (HugeCavernConfig.veinManager.config == null) {
            HugeCavernConfig.veinManager.config = Config.loadConfig("hugecavern", "veins");
        } else {
            veinManager.getCaveVeins().clear();
        }
        if (HugeCavernConfig.veinManager.config.getCategoryNames().isEmpty()) {
            ArrayList veins = Lists.newArrayList();
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.GRANITE.func_176642_a()), 15, 25, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.GRANITE.func_176642_a()), 28, 25, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.DIORITE.func_176642_a()), 15, 25, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.DIORITE.func_176642_a()), 28, 25, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.ANDESITE.func_176642_a()), 18, 25, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150348_b, BlockStone.EnumType.ANDESITE.func_176642_a()), 30, 25, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150365_q, 0), 30, 17, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150365_q, 0), 55, 17, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150366_p, 0), 35, 10, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150366_p, 0), 60, 10, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150352_o, 0), 5, 5, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150352_o, 0), 10, 5, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150450_ax, 0), 8, 6, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150450_ax, 0), 20, 6, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150369_x, 0), 10, 5, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150369_x, 0), 22, 5, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150482_ag, 0), 2, 5, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150482_ag, 0), 4, 5, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.AQUAMARINE_ORE.getMetadata()), 10, 8, 1, 50, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.AQUAMARINE_ORE.getMetadata()), 12, 8, 50, 255, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.MAGNITE_ORE.getMetadata()), 30, 10, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.MAGNITE_ORE.getMetadata()), 50, 10, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.RANDOMITE_ORE.getMetadata()), 15, 4, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.RANDOMITE_ORE.getMetadata()), 24, 4, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.HEXCITE_ORE.getMetadata()), 2, 5, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.HEXCITE_ORE.getMetadata()), 4, 5, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.FISSURED_STONE.getMetadata()), 40, 2, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.FISSURED_STONE.getMetadata()), 80, 2, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150346_d, 0), 16, 25, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150346_d, 0), 20, 25, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150351_n, 0), 8, 20, 1, 50, new Object[0]));
            veins.add(new CaveVein(new BlockMeta(Blocks.field_150351_n, 0), 10, 20, 50, 255, new Object[0]));
            veins.add(new CaveVein(new BlockMeta((Block)Blocks.field_150354_m, BlockSand.EnumType.SAND.func_176688_a()), 8, 20, 1, 50, BiomeDictionary.Type.SANDY));
            veins.add(new CaveVein(new BlockMeta((Block)Blocks.field_150354_m, BlockSand.EnumType.SAND.func_176688_a()), 10, 20, 50, 255, BiomeDictionary.Type.SANDY));
            CavernConfig.generateVeinsConfig(veinManager, veins);
        } else if (CavernConfig.addVeinsFromConfig(veinManager)) {
            try {
                FileUtils.forceDelete((File)new File(HugeCavernConfig.veinManager.config.toString()));
                veinManager.getCaveVeins().clear();
                HugeCavernConfig.veinManager.config = null;
                HugeCavernConfig.syncVeinsConfig();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Config.saveConfig(HugeCavernConfig.veinManager.config);
    }

    static {
        biomeType = new ConfigBiomeType();
        triggerItems = new ConfigItems();
        biomeManager = new CaveBiomeManager();
        veinManager = new CaveVeinManager();
    }
}

