/*
 * Decompiled with CFR 0.152.
 */
package cavern.config;

import cavern.client.config.CaveConfigEntries;
import cavern.config.Config;
import cavern.config.GeneralConfig;
import cavern.config.property.ConfigBlocks;
import cavern.config.property.ConfigItems;
import cavern.config.property.ConfigMinerRank;
import cavern.core.Cavern;
import cavern.stats.MinerRank;
import cavern.util.CaveUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class MiningAssistConfig {
    public static Configuration config;
    public static ConfigItems effectiveItems;
    public static ConfigMinerRank minerRank;
    public static boolean collectDrops;
    public static boolean collectExps;
    public static ConfigBlocks quickTargetBlocks;
    public static ConfigBlocks rangedTargetBlocks;
    public static ConfigBlocks aditTargetBlocks;
    public static boolean priorityQuickMining;
    public static int quickMiningLimit;
    public static int rangedMining;
    public static boolean modifiedHardness;
    public static boolean miningAssistNotify;

    public static void syncConfig() {
        String category = "miningassist";
        ArrayList propOrder = Lists.newArrayList();
        if (config == null) {
            config = Config.loadConfig("mining-assist");
        }
        Property prop = config.get(category, "effectiveItems", new String[0]);
        prop.setConfigEntryClass(CaveConfigEntries.selectItems);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        String comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        effectiveItems.setValues(prop.getStringList());
        prop = config.get(category, "minerRank", MinerRank.IRON_MINER.getRank());
        prop.setMinValue(0).setMaxValue(MinerRank.values().length - 1).setConfigEntryClass(CaveConfigEntries.cycleInteger);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        int min = Integer.parseInt(prop.getMinValue());
        int max = Integer.parseInt(prop.getMaxValue());
        for (int i = min; i <= max; ++i) {
            comment = comment + Configuration.NEW_LINE + i + ": " + Cavern.proxy.translate(prop.getLanguageKey() + "." + i);
            if (i >= max) continue;
            comment = comment + ",";
        }
        prop.setComment(comment);
        propOrder.add(prop.getName());
        minerRank.setValue(prop.getInt(minerRank.getValue()));
        prop = config.get(category, "collectDrops", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        collectDrops = prop.getBoolean(collectDrops);
        prop = config.get(category, "collectExps", true);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        collectExps = prop.getBoolean(collectExps);
        prop = config.get(category, "quickTargetBlocks", new String[0]);
        prop.setConfigEntryClass(CaveConfigEntries.selectBlocksAndOreDicts);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        quickTargetBlocks.setValues(prop.getStringList());
        prop = config.get(category, "rangedTargetBlocks", new String[0]);
        prop.setConfigEntryClass(CaveConfigEntries.selectBlocksAndOreDicts);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        rangedTargetBlocks.setValues(prop.getStringList());
        prop = config.get(category, "aditTargetBlocks", new String[0]);
        prop.setConfigEntryClass(CaveConfigEntries.selectBlocksAndOreDicts);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        aditTargetBlocks.setValues(prop.getStringList());
        prop = config.get(category, "priorityQuickMining", false);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [default: " + prop.getDefault() + "]";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        priorityQuickMining = prop.getBoolean(priorityQuickMining);
        prop = config.get(category, "quickMiningLimit", 30);
        prop.setMinValue(1).setMaxValue(100);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        quickMiningLimit = prop.getInt(quickMiningLimit);
        prop = config.get(category, "rangedMining", 1);
        prop.setMinValue(1).setMaxValue(10);
        prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
        comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
        comment = comment + " [range: " + prop.getMinValue() + " ~ " + prop.getMaxValue() + ", default: " + prop.getDefault() + "]";
        comment = comment + Configuration.NEW_LINE;
        comment = comment + "Note: If multiplayer, server-side only.";
        prop.setComment(comment);
        propOrder.add(prop.getName());
        rangedMining = prop.getInt(rangedMining);
        if (GeneralConfig.SIDE.isClient()) {
            prop = config.get(category, "modifiedHardness", true);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            comment = comment + " [default: " + prop.getDefault() + "]";
            prop.setComment(comment);
            propOrder.add(prop.getName());
            modifiedHardness = prop.getBoolean(modifiedHardness);
            prop = config.get(category, "miningAssistNotify", true);
            prop.setLanguageKey("cavern.config." + category + "." + prop.getName());
            comment = Cavern.proxy.translate(prop.getLanguageKey() + ".tooltip");
            comment = comment + " [default: " + prop.getDefault() + "]";
            prop.setComment(comment);
            propOrder.add(prop.getName());
            miningAssistNotify = prop.getBoolean(miningAssistNotify);
        }
        config.setCategoryPropertyOrder(category, (List)propOrder);
        Config.saveConfig(config);
    }

    public static boolean isEffectiveItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (effectiveItems.isEmpty()) {
            return CaveUtils.isItemPickaxe(stack);
        }
        return effectiveItems.hasItemStack(stack);
    }

    static {
        effectiveItems = new ConfigItems();
        minerRank = new ConfigMinerRank();
        quickTargetBlocks = new ConfigBlocks();
        rangedTargetBlocks = new ConfigBlocks();
        aditTargetBlocks = new ConfigBlocks();
    }
}

