/*
 * Decompiled with CFR 0.152.
 */
package cavern.config.manager;

import cavern.config.Config;
import cavern.util.BlockMeta;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.init.Blocks;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class CaveVein {
    private BlockMeta blockMeta;
    private BlockMeta targetBlockMeta;
    private int veinWeight;
    private double veinChance;
    private int veinSize;
    private int minHeight;
    private int maxHeight;
    private String[] biomes;

    public CaveVein() {
    }

    public CaveVein(BlockMeta block, BlockMeta target, int weight, double chance, int size, int min, int max) {
        this.blockMeta = block;
        this.targetBlockMeta = target;
        this.veinWeight = weight;
        this.veinChance = chance;
        this.veinSize = size;
        this.minHeight = min;
        this.maxHeight = max;
        this.biomes = new String[0];
    }

    public CaveVein(BlockMeta block, int weight, int size, int min, int max, Object ... biomes) {
        this(block, new BlockMeta(Blocks.field_150348_b.func_176223_P()), weight, 1.0, size, min, max);
        this.biomes = this.getBiomes(biomes);
    }

    public CaveVein(CaveVein vein) {
        this(vein.blockMeta, vein.targetBlockMeta, vein.veinWeight, vein.veinChance, vein.veinSize, vein.minHeight, vein.maxHeight);
        this.biomes = vein.biomes;
    }

    private String[] getBiomes(Object ... objects) {
        TreeSet biomes = Sets.newTreeSet();
        for (Object element : objects) {
            Biome biome;
            if (element instanceof Biome) {
                biomes.add(((Biome)element).getRegistryName().toString());
                continue;
            }
            if (element instanceof String) {
                biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation((String)element));
                if (biome == null) continue;
                biomes.add((String)element);
                continue;
            }
            if (element instanceof Integer) {
                biome = Biome.func_150568_d((int)((Integer)element));
                if (biome == null) continue;
                biomes.add(biome.getRegistryName().toString());
                continue;
            }
            if (!(element instanceof BiomeDictionary.Type)) continue;
            BiomeDictionary.Type type = (BiomeDictionary.Type)element;
            for (Biome biome2 : BiomeDictionary.getBiomes((BiomeDictionary.Type)type)) {
                biomes.add(biome2.getRegistryName().toString());
            }
        }
        return biomes.toArray(new String[biomes.size()]);
    }

    public BlockMeta getBlockMeta() {
        return this.blockMeta;
    }

    public void setBlockMeta(BlockMeta block) {
        this.blockMeta = block;
    }

    public BlockMeta getTarget() {
        return this.targetBlockMeta;
    }

    public void setTarget(BlockMeta block) {
        this.targetBlockMeta = block;
    }

    public int getWeight() {
        return this.veinWeight;
    }

    public void setWeight(int weight) {
        this.veinWeight = weight;
    }

    public double getChance() {
        return this.veinChance;
    }

    public void setChance(double chance) {
        this.veinChance = chance;
    }

    public int getSize() {
        return this.veinSize;
    }

    public void setSize(int size) {
        this.veinSize = size;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int height) {
        this.minHeight = height;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(int height) {
        this.maxHeight = height;
    }

    public String[] getBiomes() {
        return this.biomes;
    }

    public void setBiomes(String[] target) {
        this.biomes = target;
    }

    public List<Biome> getBiomeList() {
        if (this.biomes == null || this.biomes.length <= 0) {
            return Collections.emptyList();
        }
        NonNullList list = NonNullList.func_191196_a();
        for (String key : this.biomes) {
            Biome biome = Config.getBiomeFromString(key);
            if (biome == null) continue;
            list.add((Object)biome);
        }
        return list;
    }
}

