/*
 * Decompiled with CFR 0.152.
 */
package cavern.config.property;

import cavern.block.BlockCave;
import cavern.block.CaveBlocks;
import cavern.config.GeneralConfig;
import cavern.stats.MinerStats;
import cavern.util.BlockMeta;
import cavern.util.CaveUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfigMiningPoints {
    private String[] values;
    private boolean init;

    public String[] getValues() {
        if (this.values == null) {
            this.values = new String[0];
        }
        return this.values;
    }

    public void setValues(String[] entries) {
        this.values = entries;
    }

    public boolean shouldInit() {
        return this.init;
    }

    public void setInit(boolean flag) {
        this.init = flag;
    }

    public void init() {
        TreeSet entries = Sets.newTreeSet();
        entries.add(new PointEntry("oreCoal", 1));
        entries.add(new PointEntry("oreIron", 1));
        entries.add(new PointEntry("oreGold", 1));
        entries.add(new PointEntry("oreRedstone", 2));
        entries.add(new PointEntry(new BlockMeta(Blocks.field_150439_ay, 0), 2));
        entries.add(new PointEntry("oreLapis", 3));
        entries.add(new PointEntry("oreEmerald", 3));
        entries.add(new PointEntry("oreDiamond", 5));
        entries.add(new PointEntry("oreQuartz", 2));
        entries.add(new PointEntry("oreCopper", 1));
        entries.add(new PointEntry("oreTin", 1));
        entries.add(new PointEntry("oreLead", 1));
        entries.add(new PointEntry("oreSilver", 1));
        entries.add(new PointEntry("oreAdamantium", 1));
        entries.add(new PointEntry("oreAluminum", 1));
        entries.add(new PointEntry("oreApatite", 1));
        entries.add(new PointEntry("oreMythril", 1));
        entries.add(new PointEntry("oreOnyx", 1));
        entries.add(new PointEntry("oreUranium", 2));
        entries.add(new PointEntry("oreSapphire", 3));
        entries.add(new PointEntry("oreRuby", 3));
        entries.add(new PointEntry("oreTopaz", 2));
        entries.add(new PointEntry("oreChrome", 1));
        entries.add(new PointEntry("orePlatinum", 1));
        entries.add(new PointEntry("oreTitanium", 1));
        entries.add(new PointEntry("oreSulfur", 1));
        entries.add(new PointEntry("oreSaltpeter", 1));
        entries.add(new PointEntry("oreFirestone", 2));
        entries.add(new PointEntry("oreSalt", 1));
        entries.add(new PointEntry("oreJade", 1));
        entries.add(new PointEntry("oreManganese", 1));
        entries.add(new PointEntry("oreLanite", 1));
        entries.add(new PointEntry("oreMeurodite", 1));
        entries.add(new PointEntry("oreSoul", 1));
        entries.add(new PointEntry("oreSunstone", 1));
        entries.add(new PointEntry("oreZinc", 1));
        entries.add(new PointEntry("oreCrocoite", 3));
        entries.add(new PointEntry("glowstone", 2));
        entries.add(new PointEntry("oreGypsum", 1));
        entries.add(new PointEntry("oreChalcedonyB", 1));
        entries.add(new PointEntry("oreChalcedonyW", 1));
        entries.add(new PointEntry("oreMagnetite", 1));
        entries.add(new PointEntry("oreNiter", 1));
        entries.add(new PointEntry("oreSchorl", 1));
        entries.add(new PointEntry("oreCobalt", 1));
        entries.add(new PointEntry("oreArdite", 1));
        entries.add(new PointEntry("oreAquamarine", 2));
        entries.add(new PointEntry("oreMagnite", 1));
        entries.add(new PointEntry("oreRandomite", 2));
        entries.add(new PointEntry("oreHexcite", 4));
        entries.add(new PointEntry(new BlockMeta(CaveBlocks.CAVE_BLOCK, BlockCave.EnumType.FISSURED_STONE.getMetadata()), 3));
        ConfigCategory category = GeneralConfig.config.getCategory("general");
        Property prop = category.get("miningPoints");
        if (prop != null) {
            String[] data = (String[])entries.stream().filter(entry -> entry.isValid()).map(PointEntry::toString).toArray(String[]::new);
            prop.set(data);
            this.setValues(data);
        }
    }

    public void refreshPoints() {
        MinerStats.MINING_POINTS.clear();
        for (String value : this.values) {
            BlockMeta blockMeta;
            if (Strings.isNullOrEmpty((String)value) || !value.contains(",")) continue;
            value = value.trim();
            int i = value.indexOf(44);
            String str = value.substring(0, i).trim();
            int point = NumberUtils.toInt((String)value.substring(i + 1));
            if (OreDictionary.doesOreNameExist((String)str)) {
                MinerStats.setPointAmount(str, point);
                continue;
            }
            if (!str.contains(":")) {
                str = "minecraft:" + str;
            }
            if (str.indexOf(58) != str.lastIndexOf(58)) {
                i = str.lastIndexOf(58);
                blockMeta = new BlockMeta(str.substring(0, i), str.substring(i + 1));
            } else {
                blockMeta = new BlockMeta(str, 0);
            }
            if (!blockMeta.isNotAir()) continue;
            MinerStats.setPointAmount(blockMeta, point);
        }
    }

    public class PointEntry
    implements Comparable<PointEntry> {
        private String name;
        private int point;

        public PointEntry(String name, int point) {
            this.name = name;
            this.point = point;
        }

        public PointEntry(BlockMeta blockMeta, int point) {
            this(blockMeta.getName(true), point);
        }

        public String getName() {
            return this.name;
        }

        public int getPoint() {
            return this.point;
        }

        public boolean isOreDict() {
            return OreDictionary.doesOreNameExist((String)this.name);
        }

        public boolean isNotOreDictEmpty() {
            return OreDictionary.getOres((String)this.name, (boolean)false).size() > 0;
        }

        public boolean isValid() {
            if (Strings.isNullOrEmpty((String)this.name)) {
                return false;
            }
            return this.isOreDict() && this.isNotOreDictEmpty() || Block.func_149684_b((String)this.name) != null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PointEntry)) {
                return false;
            }
            PointEntry entry = (PointEntry)obj;
            return this.name.equals(entry.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name + "," + this.point;
        }

        @Override
        public int compareTo(PointEntry entry) {
            int i = CaveUtils.compareWithNull(this, entry);
            if (i == 0 && entry != null && (i = Boolean.compare(!this.isOreDict(), !entry.isOreDict())) == 0) {
                i = this.name.compareTo(entry.name);
            }
            return i;
        }
    }
}

