/*
 * Decompiled with CFR 0.152.
 */
package cavern.core;

import cavern.api.CavernAPI;
import cavern.block.CaveBlocks;
import cavern.block.RandomiteHelper;
import cavern.capability.CaveCapabilities;
import cavern.client.CaveKeyBindings;
import cavern.client.CaveMusics;
import cavern.client.CaveRenderingRegistry;
import cavern.client.config.CaveConfigEntries;
import cavern.client.handler.ClientEventHooks;
import cavern.client.handler.MagicEventHooks;
import cavern.client.handler.MinerStatsHUDEventHooks;
import cavern.config.AquaCavernConfig;
import cavern.config.CavelandConfig;
import cavern.config.CaveniaConfig;
import cavern.config.CavernConfig;
import cavern.config.Config;
import cavern.config.DisplayConfig;
import cavern.config.GeneralConfig;
import cavern.config.HugeCavernConfig;
import cavern.config.MiningAssistConfig;
import cavern.config.MirageWorldsConfig;
import cavern.core.CaveSounds;
import cavern.core.CommandCavern;
import cavern.core.CommonProxy;
import cavern.core.CreativeTabCavern;
import cavern.entity.CaveEntityRegistry;
import cavern.handler.CaveEventHooks;
import cavern.handler.CaveGuiHandler;
import cavern.handler.CavebornEventHooks;
import cavern.handler.MiningAssistEventHooks;
import cavern.handler.api.DimensionHandler;
import cavern.handler.api.EntityDataHandler;
import cavern.item.CaveItems;
import cavern.network.CaveNetworkRegistry;
import cavern.plugin.HaCPlugin;
import cavern.plugin.MCEPlugin;
import cavern.util.CaveLog;
import cavern.util.Version;
import cavern.world.CaveDimensions;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Level;

@Mod(modid="cavern", dependencies="required:forge@[14.23.5.2854,);", guiFactory="cavern.client.config.CaveGuiFactory", updateJSON="https://raw.githubusercontent.com/kegare/Cavern2/master/cavern2.json")
public class Cavern {
    public static final String MODID = "cavern";
    @Mod.Instance(value="cavern")
    public static Cavern instance;
    @Mod.Metadata(value="cavern")
    public static ModMetadata metadata;
    @SidedProxy(modId="cavern", clientSide="cavern.client.ClientProxy", serverSide="cavern.core.CommonProxy")
    public static CommonProxy proxy;
    public static final CreativeTabCavern TAB_CAVERN;

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        Version.initVersion();
        CavernAPI.dimension = new DimensionHandler();
        CavernAPI.data = new EntityDataHandler();
        if (event.getSide().isClient()) {
            this.clientConstruct();
        }
        Config.updateConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void clientConstruct() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.func_147111_S() && Runtime.getRuntime().maxMemory() >= 2000000000L) {
            Config.highProfiles = true;
        }
        CaveConfigEntries.initEntries();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GeneralConfig.syncConfig();
        CaveNetworkRegistry.registerMessages();
        CaveCapabilities.registerCapabilities();
        MiningAssistConfig.syncConfig();
        if (event.getSide().isClient()) {
            DisplayConfig.syncConfig();
            CaveRenderingRegistry.registerRenderers();
            CaveRenderingRegistry.registerRenderBlocks();
            CaveKeyBindings.registerKeyBindings();
            MinecraftForge.EVENT_BUS.register((Object)new ClientEventHooks());
            MinecraftForge.EVENT_BUS.register((Object)new MinerStatsHUDEventHooks());
            MinecraftForge.EVENT_BUS.register((Object)new MagicEventHooks());
        }
        MinecraftForge.EVENT_BUS.register((Object)new CaveEventHooks());
        MinecraftForge.EVENT_BUS.register((Object)new CavebornEventHooks());
        MinecraftForge.EVENT_BUS.register((Object)new MiningAssistEventHooks());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new CaveGuiHandler());
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        CaveBlocks.registerBlocks((IForgeRegistry<Block>)registry);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        CaveBlocks.registerItemBlocks((IForgeRegistry<Item>)registry);
        CaveItems.registerItems((IForgeRegistry<Item>)registry);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        CaveBlocks.registerModels();
        CaveItems.registerModels();
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        CaveSounds.registerSounds((IForgeRegistry<SoundEvent>)registry);
    }

    @SubscribeEvent
    public void registerEntityEntries(RegistryEvent.Register<EntityEntry> event) {
        CaveEntityRegistry.registerEntities();
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        CaveItems.registerRecipes((IForgeRegistry<IRecipe>)registry);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        CaveBlocks.registerBlockColors(colors);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        BlockColors blockColors = event.getBlockColors();
        CaveBlocks.registerItemBlockColors(blockColors, itemColors);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        CaveBlocks.registerOreDicts();
        CaveItems.registerOreDicts();
        CaveItems.registerEquipments();
        CaveBlocks.registerSmeltingRecipes();
        CaveEntityRegistry.addSpawns();
        CavernConfig.syncConfig();
        CavernConfig.syncBiomesConfig();
        CavernConfig.syncVeinsConfig();
        HugeCavernConfig.syncConfig();
        HugeCavernConfig.syncBiomesConfig();
        HugeCavernConfig.syncVeinsConfig();
        AquaCavernConfig.syncConfig();
        AquaCavernConfig.syncBiomesConfig();
        AquaCavernConfig.syncVeinsConfig();
        CavelandConfig.syncConfig();
        CavelandConfig.syncVeinsConfig();
        CaveniaConfig.syncConfig();
        CaveniaConfig.syncBiomesConfig();
        CaveniaConfig.syncVeinsConfig();
        MirageWorldsConfig.syncConfig();
        CaveDimensions.registerDimensions();
        if (event.getSide().isClient()) {
            CaveMusics.registerMusics();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.loadPlugins();
    }

    public void loadPlugins() {
        if (Loader.isModLoaded((String)"dcs_climate|lib")) {
            try {
                HaCPlugin.load();
            }
            catch (Exception e) {
                CaveLog.log(Level.WARN, e, "Failed to load the Heat&Climate mod plugin.", new Object[0]);
            }
        }
        if (Loader.isModLoaded((String)"mceconomy3")) {
            try {
                MCEPlugin.load();
            }
            catch (Exception e) {
                CaveLog.log(Level.WARN, e, "Failed to load the MCEconomy mod plugin.", new Object[0]);
            }
        }
    }

    @Mod.EventHandler
    public void loaded(FMLLoadCompleteEvent event) {
        if (GeneralConfig.miningPoints.shouldInit()) {
            GeneralConfig.miningPoints.init();
        }
        Config.saveConfig(GeneralConfig.config);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        if (event.getSide().isServer() && Config.configChecker.isUpdated()) {
            event.getServer().func_145747_a((ITextComponent)new TextComponentTranslation("cavern.config.message.update", new Object[0]));
        }
        event.registerServerCommand((ICommand)new CommandCavern());
        GeneralConfig.miningPointItems.refreshItems();
        GeneralConfig.miningPoints.refreshPoints();
        GeneralConfig.cavebornBonusItems.refreshItems();
        GeneralConfig.randomiteExcludeItems.refreshItems();
        MiningAssistConfig.effectiveItems.refreshItems();
        MiningAssistConfig.quickTargetBlocks.refreshBlocks();
        MiningAssistConfig.rangedTargetBlocks.refreshBlocks();
        MiningAssistConfig.aditTargetBlocks.refreshBlocks();
        CavernConfig.triggerItems.refreshItems();
        CavernConfig.dungeonMobs.refreshEntities();
        CavernConfig.towerDungeonMobs.refreshEntities();
        HugeCavernConfig.triggerItems.refreshItems();
        AquaCavernConfig.triggerItems.refreshItems();
        AquaCavernConfig.dungeonMobs.refreshEntities();
        AquaCavernConfig.towerDungeonMobs.refreshEntities();
        RandomiteHelper.refreshItems();
    }

    static {
        TAB_CAVERN = new CreativeTabCavern();
    }
}

