/*
 * Decompiled with CFR 0.152.
 */
package cavern.entity;

import cavern.core.Cavern;
import cavern.entity.EntityAquaSquid;
import cavern.entity.EntityCaveman;
import cavern.entity.EntityCavenicBear;
import cavern.entity.EntityCavenicCreeper;
import cavern.entity.EntityCavenicSkeleton;
import cavern.entity.EntityCavenicSpider;
import cavern.entity.EntityCavenicWitch;
import cavern.entity.EntityCavenicZombie;
import cavern.entity.EntityCrazyCreeper;
import cavern.entity.EntityCrazySkeleton;
import cavern.entity.EntityCrazySpider;
import cavern.entity.EntityCrazyZombie;
import cavern.entity.EntityMagicTorcher;
import cavern.entity.EntitySummonCavenicSkeleton;
import cavern.entity.EntitySummonCavenicZombie;
import cavern.entity.EntitySummonSkeleton;
import cavern.entity.EntitySummonZombie;
import cavern.util.CaveUtils;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CaveEntityRegistry {
    private static int entityId;

    public static void registerEntity(Class<? extends Entity> entityClass, String key, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)CaveUtils.getKey(key), entityClass, (String)name, (int)entityId++, (Object)Cavern.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String key, String name, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity((ResourceLocation)CaveUtils.getKey(key), entityClass, (String)name, (int)entityId++, (Object)Cavern.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)primaryColor, (int)secondaryColor);
    }

    public static void registerMob(Class<? extends Entity> entityClass, String key, String name) {
        CaveEntityRegistry.registerEntity(entityClass, key, name, 128, 3, true);
    }

    public static void registerMob(Class<? extends Entity> entityClass, String key, String name, int primaryColor, int secondaryColor) {
        CaveEntityRegistry.registerEntity(entityClass, key, name, 128, 3, true, primaryColor, secondaryColor);
        EntitySpawnPlacementRegistry.setPlacementType(entityClass, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND);
    }

    public static void registerEntities() {
        CaveEntityRegistry.registerMob(EntityCavenicSkeleton.class, "cavenic_skeleton", "CavenicSkeleton", 0xAAAAAA, 0xDDDDDD);
        CaveEntityRegistry.registerMob(EntityCavenicCreeper.class, "cavenic_creeper", "CavenicCreeper", 0xAAAAAA, 3050327);
        CaveEntityRegistry.registerMob(EntityCavenicZombie.class, "cavenic_zombie", "CavenicZombie", 0xAAAAAA, 41120);
        CaveEntityRegistry.registerMob(EntityCavenicSpider.class, "cavenic_spider", "CavenicSpider", 0xAAAAAA, 0x811F1F);
        CaveEntityRegistry.registerMob(EntityCavenicWitch.class, "cavenic_witch", "CavenicWitch", 0xAAAAAA, 4870984);
        CaveEntityRegistry.registerMob(EntityCavenicBear.class, "cavenic_bear", "CavenicBear", 0xAAAAAA, 0xFFFFFF);
        CaveEntityRegistry.registerMob(EntityCrazySkeleton.class, "crazy_skeleton", "CrazySkeleton", 0x909090, 0xDDDDDD);
        CaveEntityRegistry.registerMob(EntityCrazyCreeper.class, "crazy_creeper", "CrazyCreeper", 0x909090, 3050327);
        CaveEntityRegistry.registerMob(EntityCrazyZombie.class, "crazy_zombie", "CrazyZombie", 0x909090, 41120);
        CaveEntityRegistry.registerMob(EntityCrazySpider.class, "crazy_spider", "CrazySpider", 0x909090, 0x811F1F);
        CaveEntityRegistry.registerMob(EntityCaveman.class, "caveman", "Caveman", 0xAAAAAA, 0xCCCCCC);
        CaveEntityRegistry.registerMob(EntitySummonZombie.class, "summon_zombie", "Zombie");
        CaveEntityRegistry.registerMob(EntitySummonSkeleton.class, "summon_skeleton", "Skeleton");
        CaveEntityRegistry.registerMob(EntitySummonCavenicZombie.class, "summon_cavenic_zombie", "CavenicZombie");
        CaveEntityRegistry.registerMob(EntitySummonCavenicSkeleton.class, "summon_cavenic_skeleton", "CavenicSkeleton");
        CaveEntityRegistry.registerEntity(EntityAquaSquid.class, "squid", "Squid", 64, 3, true);
        CaveEntityRegistry.registerEntity(EntityMagicTorcher.class, "magic_torcher", "MagicTorcher", 16, 3, false);
        EntitySpawnPlacementRegistry.setPlacementType(EntityAquaSquid.class, (EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.IN_WATER);
    }

    public static void addSpawns() {
        Collection biomes = ForgeRegistries.BIOMES.getValuesCollection();
        Biome[] biomeArray = biomes.toArray(new Biome[biomes.size()]);
        EntityRegistry.addSpawn(EntityCavenicSkeleton.class, (int)20, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCavenicCreeper.class, (int)30, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCavenicZombie.class, (int)30, (int)2, (int)2, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCavenicSpider.class, (int)30, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCavenicWitch.class, (int)15, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCavenicBear.class, (int)30, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCrazySkeleton.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCrazyCreeper.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCrazyZombie.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCrazySpider.class, (int)1, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityCaveman.class, (int)30, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])biomeArray);
        EntityRegistry.addSpawn(EntityAquaSquid.class, (int)100, (int)4, (int)4, (EnumCreatureType)EnumCreatureType.WATER_CREATURE, (Biome[])biomeArray);
    }
}

