/*
 * Decompiled with CFR 0.152.
 */
package cavern.entity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityMagicTorcher
extends Entity {
    protected EntityPlayer entityPlayer;
    protected int torcherRange;
    protected ItemStack torchItem = ItemStack.field_190927_a;
    protected int lifeTime = 600;
    protected int idleTime;
    protected boolean tracking;

    public EntityMagicTorcher(World world) {
        super(world);
    }

    public EntityMagicTorcher(World world, EntityPlayer player, int range) {
        super(world);
        this.entityPlayer = player;
        this.torcherRange = range;
        this.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    public EntityPlayer getPlayer() {
        return this.entityPlayer;
    }

    public int getRange() {
        return this.torcherRange;
    }

    public EntityMagicTorcher setLifeTime(int time) {
        this.lifeTime = time;
        return this;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public void setTracking(boolean value) {
        this.tracking = value;
    }

    public boolean isTracking() {
        return this.tracking;
    }

    public void func_70030_z() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.entityPlayer == null || this.entityPlayer.field_70128_L) {
            this.func_70106_y();
            return;
        }
        if (this.entityPlayer.field_71071_by.func_70431_c(new ItemStack(Blocks.field_150478_aa))) {
            if (this.torchItem.func_190926_b()) {
                for (ItemStack stack : this.entityPlayer.field_71071_by.field_70462_a) {
                    if (stack.func_190926_b() || stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150478_aa)) continue;
                    this.torchItem = stack;
                    break;
                }
            }
            if (this.torchItem.func_190926_b()) {
                for (ItemStack stack : this.entityPlayer.field_71071_by.field_184439_c) {
                    if (stack.func_190926_b() || stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150478_aa)) continue;
                    this.torchItem = stack;
                    break;
                }
            }
        } else {
            this.func_70106_y();
            return;
        }
        if (--this.lifeTime <= 0 || !this.tracking && ++this.idleTime > 50) {
            this.func_70106_y();
            return;
        }
        if (this.lifeTime % 10 != 0) {
            return;
        }
        if (this.tracking) {
            this.func_70107_b(this.entityPlayer.field_70165_t, this.entityPlayer.field_70163_u, this.entityPlayer.field_70161_v);
        }
        BlockPos center = this.func_180425_c();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)center.func_177982_a(this.torcherRange, 0, this.torcherRange), (BlockPos)center.func_177982_a(-this.torcherRange, 0, -this.torcherRange))) {
            BlockPos blockpos = this.getTorchPos(pos);
            if (blockpos == null) continue;
            this.setTorch(blockpos);
            break;
        }
    }

    @Nullable
    protected BlockPos getTorchPos(BlockPos checkPos) {
        int diff;
        BlockPos pos = checkPos;
        if (this.field_70170_p.func_175623_d(pos)) {
            for (diff = 0; diff < 5 && this.field_70170_p.func_175623_d(pos); ++diff) {
                pos = pos.func_177977_b();
            }
            pos = pos.func_177984_a();
        } else {
            while (diff < 5 && !this.field_70170_p.func_175623_d(pos)) {
                pos = pos.func_177984_a();
                ++diff;
            }
        }
        if (!this.field_70170_p.func_175623_d(pos) || this.field_70170_p.func_175623_d(pos.func_177977_b())) {
            return null;
        }
        if (!this.canPlaceTorchOn(pos.func_177977_b())) {
            return null;
        }
        if (this.field_70170_p.func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + 1.85, this.field_70161_v), new Vec3d((Vec3i)pos), false, true, false) != null) {
            return null;
        }
        if (this.getLightLevel(pos) > 7) {
            return null;
        }
        return pos;
    }

    protected int getLightLevel(BlockPos pos) {
        return this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, pos);
    }

    protected boolean canPlaceTorchOn(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        return state.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)this.field_70170_p, pos);
    }

    protected void setTorch(BlockPos pos) {
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)this.field_70170_p, pos)) {
            pos = pos.func_177984_a();
        }
        if (this.entityPlayer.func_175151_a(pos, EnumFacing.UP, this.torchItem) && this.field_70170_p.func_190527_a(Blocks.field_150478_aa, pos, false, EnumFacing.UP, null)) {
            if (!this.canPlaceTorchOn(pos.func_177977_b())) {
                return;
            }
            if (!this.field_70170_p.func_180501_a(pos, Blocks.field_150478_aa.func_176223_P(), 11)) {
                return;
            }
            IBlockState newState = this.field_70170_p.func_180495_p(pos);
            if (newState.func_177230_c() == Blocks.field_150478_aa) {
                newState.func_177230_c().func_180633_a(this.field_70170_p, pos, newState, (EntityLivingBase)this.entityPlayer, this.torchItem);
            }
            SoundType soundType = newState.func_177230_c().getSoundType(newState, this.field_70170_p, pos, (Entity)this.entityPlayer);
            this.field_70170_p.func_184133_a(null, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
            if (!this.entityPlayer.field_71075_bZ.field_75098_d) {
                this.torchItem.func_190918_g(1);
            }
            this.idleTime = 0;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K && this.tracking) {
            this.func_184185_a(SoundEvents.field_187561_bM, 1.0f, 0.375f);
            this.entityPlayer.func_146105_b((ITextComponent)new TextComponentTranslation("item.magicBook.torch.dead", new Object[0]), true);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }
}

