/*
 * Decompiled with CFR 0.152.
 */
package cavern.entity.ai;

import cavern.item.ItemBowCavenic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class EntityAIAttackCavenicBow<T extends EntityMob>
extends EntityAIAttackRangedBow<T> {
    private final T attacker;
    private final double moveSpeedAmp;
    private final float maxAttackDistance;
    private final int attackSpeed;
    private int seeTime;
    private int attackTime;
    private int attackCooldown;
    private int attackRapid;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public EntityAIAttackCavenicBow(T attacker, double speedAmplifier, float maxDistance, int attackSpeed) {
        super(attacker, speedAmplifier, 0, maxDistance);
        this.attacker = attacker;
        this.moveSpeedAmp = speedAmplifier;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.attackSpeed = attackSpeed;
        this.func_75248_a(3);
    }

    public void func_189428_b(int time) {
    }

    public boolean func_75250_a() {
        return this.attacker.func_70638_az() != null && this.func_188498_f();
    }

    protected boolean func_188498_f() {
        ItemStack held = this.attacker.func_184614_ca();
        return !held.func_190926_b() && held.func_77973_b() instanceof ItemBow;
    }

    protected int getAttackSpeed() {
        ItemStack held = this.attacker.func_184614_ca();
        if (!held.func_190926_b() && held.func_77973_b() instanceof ItemBowCavenic) {
            return Math.max(this.attackSpeed / 2, 1);
        }
        return this.attackSpeed;
    }

    public boolean func_75253_b() {
        return (this.func_75250_a() || !this.attacker.func_70661_as().func_75500_f()) && this.func_188498_f();
    }

    public void func_75249_e() {
        super.func_75249_e();
        ((IRangedAttackMob)this.attacker).func_184724_a(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        ((IRangedAttackMob)this.attacker).func_184724_a(false);
        this.seeTime = 0;
        this.attackTime = 0;
        this.attacker.func_184602_cy();
    }

    public void func_75246_d() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target != null) {
            boolean seeing;
            double dist = this.attacker.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
            boolean canSee = this.attacker.func_70635_at().func_75522_a((Entity)target);
            boolean bl = seeing = this.seeTime > 0;
            if (canSee != seeing) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (dist <= (double)this.maxAttackDistance && this.seeTime >= 15) {
                this.attacker.func_70661_as().func_75499_g();
                ++this.strafingTime;
            } else {
                this.attacker.func_70661_as().func_75497_a((Entity)target, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 5) {
                if ((double)this.attacker.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.attacker.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (dist > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (dist < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.attacker.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.attacker.func_70625_a((Entity)target, 30.0f, 30.0f);
            } else {
                this.attacker.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            }
            if (this.attacker.func_184587_cr()) {
                if (!canSee && this.seeTime < -20 || this.attackTime > 200) {
                    this.attacker.func_184602_cy();
                    this.attackTime = 0;
                    this.attackCooldown = 50;
                } else if (canSee && --this.attackCooldown <= 0) {
                    if (++this.attackRapid >= this.getAttackSpeed()) {
                        ((IRangedAttackMob)this.attacker).func_82196_d(target, ItemBow.func_185059_b((int)5));
                        this.attackRapid = 0;
                    }
                    ++this.attackTime;
                }
            } else if (this.seeTime >= -20) {
                this.attacker.func_184598_c(EnumHand.MAIN_HAND);
                this.attackTime = 0;
            }
        }
    }
}

