/*
 * Decompiled with CFR 0.152.
 */
package cavern.handler;

import cavern.api.CavernAPI;
import cavern.api.ICavenicMob;
import cavern.api.IIceEquipment;
import cavern.api.IMinerStats;
import cavern.api.IMiningData;
import cavern.api.IPlayerData;
import cavern.api.event.CriticalMiningEvent;
import cavern.block.BlockLeavesPerverted;
import cavern.block.BlockLogPerverted;
import cavern.block.BlockPortalCavern;
import cavern.block.BlockSaplingPerverted;
import cavern.block.CaveBlocks;
import cavern.block.RandomiteHelper;
import cavern.config.GeneralConfig;
import cavern.item.CaveItems;
import cavern.item.IAquaTool;
import cavern.item.ItemCave;
import cavern.magic.Magic;
import cavern.magic.MagicBook;
import cavern.magic.MagicInvisible;
import cavern.network.CaveNetworkRegistry;
import cavern.network.client.CustomSeedMessage;
import cavern.network.client.MiningMessage;
import cavern.stats.MinerRank;
import cavern.stats.MinerStats;
import cavern.stats.MiningData;
import cavern.stats.PlayerData;
import cavern.util.BlockMeta;
import cavern.util.CaveUtils;
import cavern.util.PlayerHelper;
import cavern.world.CaveDimensions;
import cavern.world.CustomSeedData;
import cavern.world.ICustomSeed;
import cavern.world.gen.WorldGenDarkLibrary;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.apache.commons.lang3.ObjectUtils;

public class CaveEventHooks {
    public static final Random RANDOM = new Random();

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K && world.field_73011_w instanceof ICustomSeed) {
            CustomSeedData data = ((ICustomSeed)world.field_73011_w).getSeedData();
            if (data == null) {
                return;
            }
            if (event.getEntity() instanceof EntityPlayerMP) {
                CaveNetworkRegistry.sendTo(new CustomSeedMessage(data.getSeedValue(world.func_72912_H().func_76063_b())), (EntityPlayerMP)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            MinerStats.adjustData(player);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            WorldServer world = player.func_71121_q();
            DimensionType type = world.field_73011_w.func_186058_p();
            if (CavernAPI.dimension.isCaves(type)) {
                PlayerHelper.grantCriterion((EntityPlayer)player, "root", "entered_cavern");
            }
            if (type != CaveDimensions.CAVERN) {
                String name = type.func_186065_b();
                if (name.startsWith("the_")) {
                    name = name.substring(4);
                }
                PlayerHelper.grantCriterion((EntityPlayer)player, "enter_the_" + name, "entered_" + name);
            }
        }
        MinerStats.adjustData(player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        BlockPos pos;
        WorldServer world;
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (CavernAPI.dimension.isInCaveDimensions((Entity)player) && (world = player.func_71121_q()).func_180495_p(pos = player.func_180425_c().func_177977_b()).func_185887_b((World)world, pos) < 0.0f) {
            pos = new BlockPos(pos.func_177958_n(), 50, pos.func_177952_p());
            world.func_180501_a(pos.func_177981_b(2), Blocks.field_150348_b.func_176223_P(), 2);
            world.func_180501_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150348_b.func_176223_P(), 2);
            player.func_174828_a(pos, player.field_70177_z, player.field_70125_A);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        ItemStack stack = event.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        World world = event.getWorld();
        IBlockState state = world.func_180495_p(pos = event.getPos());
        if (state.func_177230_c() != Blocks.field_150341_Y && (state.func_177230_c() != Blocks.field_150417_aV || state.func_177230_c().func_176201_c(state) != BlockStoneBrick.field_176250_M)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        HashSet portals = Sets.newHashSet();
        portals.add(CaveBlocks.CAVERN_PORTAL);
        portals.add(CaveBlocks.HUGE_CAVERN_PORTAL);
        portals.add(CaveBlocks.AQUA_CAVERN_PORTAL);
        portals.add(CaveBlocks.MIRAGE_PORTAL);
        Item portalItem = Items.field_190931_a;
        for (BlockPortalCavern portal : portals) {
            if (!portal.isTriggerItem(stack)) continue;
            portalItem = Item.func_150898_a((Block)portal);
            break;
        }
        if (portalItem != Items.field_190931_a) {
            EnumFacing facing = (EnumFacing)ObjectUtils.defaultIfNull((Object)event.getFace(), (Object)EnumFacing.UP);
            Vec3d hit = event.getHitVec();
            EnumActionResult result = portalItem.func_180614_a(player, world, pos, event.getHand(), facing, (float)hit.field_72450_a, (float)hit.field_72448_b, (float)hit.field_72449_c);
            if (result == EnumActionResult.SUCCESS) {
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        int point;
        EntityPlayer entityPlayer = event.getPlayer();
        if (entityPlayer == null || entityPlayer instanceof FakePlayer || !(entityPlayer instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        if (!CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            return;
        }
        World world = event.getWorld();
        IBlockState state = event.getState();
        ItemStack stack = player.func_184614_ca();
        if (GeneralConfig.isMiningPointItem(stack) && (point = MinerStats.getPointAmount(state)) != 0) {
            IMinerStats stats = MinerStats.get((EntityPlayer)player);
            IMiningData data = MiningData.get((EntityPlayer)player);
            if (player.field_71071_by.func_70431_c(ItemCave.EnumType.MINER_ORB.getItemStack()) && RANDOM.nextDouble() < 0.15) {
                point += Math.max(point / 2, 1);
            }
            stats.addPoint(point);
            stats.addMiningRecord(new BlockMeta(state));
            data.notifyMining(state, point);
            int combo = data.getMiningCombo();
            if (combo > 0 && combo % 10 == 0) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((RANDOM.nextFloat() - RANDOM.nextFloat()) * 0.7f + 1.8f));
                player.func_71023_q(combo / 10);
            }
            if (combo >= 50) {
                PlayerHelper.grantAdvancement((EntityPlayer)player, "good_mine");
            }
            CaveNetworkRegistry.sendTo(new MiningMessage(state, point), player);
        }
        if (CavernAPI.dimension.isInFrostMountains((Entity)player)) {
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            if (state.func_177230_c() != Blocks.field_150403_cj || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
                return;
            }
            BlockPos pos = event.getPos();
            Biome biome = world.func_180494_b(pos);
            if (!biome.func_150559_j()) {
                return;
            }
            if (RANDOM.nextDouble() < 0.05) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Blocks.field_150432_aD));
            } else if (RANDOM.nextDouble() < 0.005) {
                RandomiteHelper.Category category = RandomiteHelper.Category.COMMON;
                if (RANDOM.nextInt(5) == 0) {
                    category = RandomiteHelper.Category.FOOD;
                }
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)RandomiteHelper.getDropItem(category));
            } else if (stack.func_77973_b() instanceof IIceEquipment && RANDOM.nextDouble() < 0.03 || RANDOM.nextDouble() < 0.01) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Blocks.field_150403_cj));
            }
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b()) {
            return;
        }
        float original = event.getOriginalSpeed();
        boolean flag = EnchantmentHelper.func_185287_i((EntityLivingBase)player);
        if (player.func_70090_H() && stack.func_77973_b() instanceof IAquaTool) {
            IAquaTool tool = (IAquaTool)stack.func_77973_b();
            float speed = tool.getAquaBreakSpeed(stack, player, event.getPos(), event.getState(), original);
            if (flag) {
                speed *= 0.5f;
            }
            event.setNewSpeed(speed);
            flag = true;
        }
        if (CavernAPI.dimension.isInCaveDimensions((Entity)player) && CaveUtils.isItemPickaxe(stack)) {
            int rank = MinerStats.get(player).getRank();
            if (!flag && player.func_70090_H() && rank >= MinerRank.AQUA_MINER.getRank()) {
                event.setNewSpeed(original * 5.0f);
            }
            event.setNewSpeed(event.getNewSpeed() * MinerRank.get(rank).getBoost());
        }
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (!GeneralConfig.criticalMining || event.isSilkTouching()) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || player instanceof FakePlayer || !CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            return;
        }
        IBlockState state = event.getState();
        if (MinerStats.getPointAmount(state) <= 0) {
            return;
        }
        if (state.func_185904_a() != Material.field_151576_e) {
            return;
        }
        MinerRank rank = MinerRank.get(MinerStats.get(player).getRank());
        float f = rank.getBoost();
        if (f <= 1.0f) {
            return;
        }
        f = (f - 1.0f) * 0.3f;
        ItemStack held = player.func_184614_ca();
        String tool = state.func_177230_c().getHarvestTool(state);
        if (held.func_190926_b() || tool == null) {
            return;
        }
        int toolLevel = held.func_77973_b().getHarvestLevel(held, tool, player, state);
        if (toolLevel <= 0) {
            return;
        }
        f *= 1.0f + (float)toolLevel * 0.1f;
        List originalDrops = event.getDrops();
        ArrayList drops = Lists.newArrayList();
        for (ItemStack stack : originalDrops) {
            if (stack.func_190926_b() || stack.func_77973_b() instanceof ItemBlock || !(RANDOM.nextFloat() <= f)) continue;
            drops.add(stack.func_77946_l());
        }
        if (!drops.isEmpty()) {
            CriticalMiningEvent criticalEvent = new CriticalMiningEvent(world, event.getPos(), state, player, event.getFortuneLevel(), originalDrops, drops);
            if (MinecraftForge.EVENT_BUS.post((Event)criticalEvent)) {
                return;
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation("cavern.message.mining.critical", new Object[0]), true);
            originalDrops.addAll(criticalEvent.getBonusDrops());
        }
    }

    @SubscribeEvent
    public void onPortalSpawn(BlockEvent.PortalSpawnEvent event) {
        World world = event.getWorld();
        if (CavernAPI.dimension.isCaveDimensions(world.field_73011_w.func_186058_p())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        MiningData.get(player).onUpdate();
        if (!player.func_70090_H() || !CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            return;
        }
        IMinerStats stats = MinerStats.get(player);
        if (stats.getRank() < MinerRank.AQUA_MINER.getRank()) {
            return;
        }
        if (!player.func_70648_aU() && !player.func_70644_a(MobEffects.field_76427_o) && player.field_70173_aa % 20 == 0) {
            player.func_70050_g(300);
        }
        if (player.field_71075_bZ.field_75100_b || EnchantmentHelper.func_185294_d((EntityLivingBase)player) > 0) {
            return;
        }
        double prevY = player.field_70163_u;
        float vec1 = 0.6f;
        float vec2 = 0.01f;
        float vec3 = 0.4f;
        if (!player.field_70122_E) {
            vec3 *= 0.5f;
        }
        if (player.func_82243_bO() >= 0.75f) {
            vec3 *= 0.5f;
        }
        if (vec3 > 0.0f) {
            vec1 += (0.54600006f - vec1) * vec3 / 3.0f;
            vec2 += (player.func_70689_ay() - vec2) * vec3 / 3.0f;
        }
        player.func_191958_b(player.field_70702_br, player.field_70701_bs, player.field_191988_bg, vec2);
        player.func_70091_d(MoverType.SELF, player.field_70159_w, player.field_70181_x, player.field_70179_y);
        player.field_70159_w *= (double)vec1;
        player.field_70181_x *= (double)0.8f;
        player.field_70179_y *= (double)vec1;
        if (player.field_70123_F && player.func_70038_c(player.field_70159_w, player.field_70181_x + (double)0.6f - player.field_70163_u + prevY, player.field_70179_y)) {
            player.field_70181_x = 0.3f;
        }
        if (player.field_82175_bq || player.func_70093_af()) {
            player.field_70181_x *= 0.3;
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (CavernAPI.dimension.isInMirageWorlds((Entity)entity) && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_70606_j(0.1f);
            CaveItems.MIRAGE_BOOK.transferTo(null, player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (CavernAPI.dimension.isInCavenia((Entity)entity)) {
            if (entity instanceof ICavenicMob && ((ICavenicMob)entity).canSpawnInCavenia()) {
                return;
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityLivingBase target = event.getTarget();
        if (target == null || !(target instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)target;
        Magic magic = MagicBook.get(player).getSpellingMagic();
        if (magic == null || !(magic instanceof MagicInvisible)) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        entity.func_70604_c(null);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            return;
        }
        EntityPlayer.SleepResult result = null;
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            IPlayerData data = PlayerData.get(player);
            long worldTime = world.func_82737_E();
            long sleepTime = data.getLastSleepTime();
            long requireTime = GeneralConfig.sleepWaitTime * 20;
            if (sleepTime <= 0L) {
                sleepTime = worldTime;
                requireTime = 0L;
                data.setLastSleepTime(sleepTime);
            }
            if (requireTime > 0L && sleepTime + requireTime > worldTime) {
                result = EntityPlayer.SleepResult.OTHER_PROBLEM;
                long remainTime = requireTime - (worldTime - sleepTime);
                int min = MathHelper.func_76123_f((float)(remainTime / 20L / 60L + 1L));
                player.func_146105_b((ITextComponent)new TextComponentTranslation("cavern.message.sleep.still", new Object[]{min}), true);
            }
        }
        if (result == null) {
            result = PlayerHelper.trySleep(player, event.getPos());
        }
        if (!world.field_72995_K && result == EntityPlayer.SleepResult.OK) {
            PlayerData.get(player).setLastSleepTime(world.func_82737_E());
        }
        event.setResult(result);
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent event) {
        if (!GeneralConfig.sleepRefresh) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (world.field_72995_K || !player.func_70996_bM()) {
            return;
        }
        if (CavernAPI.dimension.isInCaveDimensions((Entity)player)) {
            player.func_70691_i(player.func_110138_aP() * 0.5f);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        int charge;
        EntityPlayer player = event.player;
        ItemStack stack = event.crafting;
        World world = player.field_70170_p;
        if (!world.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() instanceof IIceEquipment && (charge = ((IIceEquipment)stack.func_77973_b()).getCharge(stack)) > 0 && stack.func_77978_p().func_74767_n("AfterIceCharge")) {
            PlayerHelper.grantAdvancement(player, "ice_charge");
            stack.func_77978_p().func_82580_o("AfterIceCharge");
        }
    }

    @SubscribeEvent
    public void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block == null) {
            return;
        }
        if (block instanceof BlockLogPerverted) {
            event.setBurnTime(100);
        } else if (block instanceof BlockLeavesPerverted || block instanceof BlockSaplingPerverted) {
            event.setBurnTime(35);
        }
    }

    @SubscribeEvent
    public void onDecorateBiome(DecorateBiomeEvent.Pre event) {
        World world = event.getWorld();
        Random rand = event.getRand();
        ChunkPos chunkPos = event.getChunkPos();
        if (world.field_73011_w.func_186058_p() == CaveDimensions.DARK_FOREST && rand.nextInt(50) == 0) {
            int seaLevel;
            int x = rand.nextInt(16) + 8;
            int z = rand.nextInt(16) + 8;
            int top = world.func_189649_b(chunkPos.func_180334_c() + x, chunkPos.func_180333_d() + z);
            if (top >= (seaLevel = world.func_181545_F()) && top - seaLevel < 6) {
                new WorldGenDarkLibrary().func_180709_b(world, rand, new BlockPos(chunkPos.func_180334_c() + x, seaLevel, chunkPos.func_180333_d() + z));
            }
        }
    }
}

