/*
 * Decompiled with CFR 0.152.
 */
package cavern.handler;

import cavern.api.IPortalCache;
import cavern.block.BlockPortalCavern;
import cavern.config.GeneralConfig;
import cavern.config.property.ConfigCaveborn;
import cavern.handler.CaveEventHooks;
import cavern.stats.PortalCache;
import cavern.util.ItemMeta;
import cavern.util.PlayerHelper;
import cavern.world.CaveDimensions;
import cavern.world.TeleporterCavern;
import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class CavebornEventHooks {
    public static final Set<String> FIRST_PLAYERS = Sets.newHashSet();

    @SubscribeEvent
    public void onPlayerLoadFromFile(PlayerEvent.LoadFromFile event) {
        String uuid = event.getPlayerUUID();
        for (String str : event.getPlayerDirectory().list()) {
            if (!str.startsWith(uuid)) continue;
            return;
        }
        ConfigCaveborn.Type caveborn = GeneralConfig.caveborn.getType();
        if (caveborn == ConfigCaveborn.Type.DISABLED) {
            return;
        }
        BlockPortalCavern portal = caveborn.getPortalBlock();
        if (portal == null || portal.getDimension() == null) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        player.field_71093_bK = portal.getDimension().func_186068_a();
        FIRST_PLAYERS.add(uuid);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (!FIRST_PLAYERS.contains(player.func_189512_bd())) {
            return;
        }
        WorldServer world = player.func_71121_q();
        ConfigCaveborn.Type caveborn = GeneralConfig.caveborn.getType();
        BlockPortalCavern portal = caveborn.getPortalBlock();
        BlockPos pos = player.func_180425_c();
        IPortalCache cache = PortalCache.get((ICapabilityProvider)player);
        BlockPattern.PatternHelper pattern = portal.func_181089_f((World)world, pos);
        double d0 = pattern.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)pattern.func_181117_a().func_177952_p() : (double)pattern.func_181117_a().func_177958_n();
        double d1 = pattern.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? player.field_70161_v : player.field_70165_t;
        d1 = Math.abs(MathHelper.func_181160_c((double)(d1 - (double)(pattern.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)pattern.func_181118_d())));
        double d2 = MathHelper.func_181160_c((double)(player.field_70163_u - 1.0), (double)pattern.func_181117_a().func_177956_o(), (double)(pattern.func_181117_a().func_177956_o() - pattern.func_181119_e()));
        cache.setLastPortalVec(new Vec3d(d1, d2, 0.0));
        cache.setTeleportDirection(pattern.func_177669_b());
        player.field_71088_bW = player.func_82147_ab();
        new TeleporterCavern(world, portal).placeEntity((World)world, (Entity)player, player.field_70177_z);
        FIRST_PLAYERS.remove(event.player.func_189512_bd());
        DimensionType type = portal.getDimension();
        PlayerHelper.grantCriterion((EntityPlayer)player, "root", "entered_cavern");
        if (type != CaveDimensions.CAVERN) {
            String name = type.func_186065_b();
            PlayerHelper.grantCriterion((EntityPlayer)player, "enter_the_" + (String)name, "entered_" + (String)name);
        }
        pos = player.func_180425_c();
        for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-1, -1, -1), (BlockPos)pos.func_177982_a(1, 1, 1))) {
            if (world.func_180495_p(blockpos).func_177230_c() != portal) continue;
            world.func_175698_g(blockpos);
            break;
        }
        double x = player.field_70165_t;
        double y = player.field_70163_u + 0.25;
        double z = player.field_70161_v;
        world.func_184148_a(null, x, y, z, SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, 0.65f);
        for (ItemMeta itemMeta : GeneralConfig.cavebornBonusItems.getItems()) {
            ItemStack stack = itemMeta.getItemStack();
            if (stack.func_77985_e()) {
                stack = itemMeta.getItemStack(MathHelper.func_76136_a((Random)CaveEventHooks.RANDOM, (int)4, (int)16));
            }
            InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)stack);
        }
    }
}

