/*
 * Decompiled with CFR 0.152.
 */
package cavern.handler;

import cavern.api.IMinerStats;
import cavern.client.CaveKeyBindings;
import cavern.config.MiningAssistConfig;
import cavern.core.Cavern;
import cavern.handler.CaveEventHooks;
import cavern.miningassist.MiningAssist;
import cavern.miningassist.MiningAssistUnit;
import cavern.miningassist.MiningSnapshot;
import cavern.network.CaveNetworkRegistry;
import cavern.network.server.MiningAssistMessage;
import cavern.stats.MinerStats;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class MiningAssistEventHooks {
    private boolean breaking;
    private boolean checking;

    private boolean isActive(EntityPlayer player, IBlockState state) {
        ItemStack held = player.func_184614_ca();
        if (!MiningAssistConfig.isEffectiveItem(held)) {
            return false;
        }
        IMinerStats stats = MinerStats.get(player);
        if (stats.getRank() < MiningAssistConfig.minerRank.getValue()) {
            return false;
        }
        MiningAssist type = MiningAssist.get(stats.getMiningAssist());
        if (type == MiningAssist.DISABLED) {
            return false;
        }
        return type.isEffectiveTarget(held, state);
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        IBlockState state;
        if (!MiningAssistConfig.modifiedHardness || !Cavern.proxy.isSinglePlayer()) {
            return;
        }
        if (this.checking) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (!this.isActive(player, state = event.getState())) {
            return;
        }
        MiningAssistUnit assist = MiningAssistUnit.get(player);
        MiningAssist type = MiningAssist.byPlayer(player);
        BlockPos pos = event.getPos();
        this.checking = true;
        MiningSnapshot snapshot = assist.getSnapshot(type, pos, state);
        if (!snapshot.isEmpty()) {
            event.setNewSpeed(assist.getBreakSpeed(snapshot));
        }
        this.checking = false;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        Map<BlockPos, Integer> map;
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player == null || player instanceof FakePlayer) {
            return;
        }
        BlockPos pos = event.getPos();
        MiningAssistUnit assist = MiningAssistUnit.get(player);
        if (assist.addExperience(pos, event.getExpToDrop())) {
            event.setExpToDrop(0);
        }
        if (this.breaking) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        IBlockState state = event.getState();
        if (!this.isActive(player, state)) {
            return;
        }
        MiningAssist type = MiningAssist.byPlayer(player);
        MiningSnapshot snapshot = assist.getSnapshot(type, pos, state);
        if (snapshot.isEmpty()) {
            return;
        }
        PlayerInteractionManager im = ((EntityPlayerMP)player).field_71134_c;
        assist.captureDrops(MiningAssistConfig.collectDrops);
        assist.captureExperiences(MiningAssistConfig.collectExps);
        this.breaking = true;
        for (BlockPos blockPos : snapshot.getTargets()) {
            if (snapshot.validTarget(blockPos) && !this.harvestBlock(im, blockPos)) break;
        }
        this.breaking = false;
        Map<BlockPos, NonNullList<ItemStack>> drops = assist.captureDrops(false);
        if (drops != null && !drops.isEmpty()) {
            for (NonNullList<ItemStack> nonNullList : drops.values()) {
                for (ItemStack stack : nonNullList) {
                    Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
                }
            }
        }
        if ((map = assist.captureExperiences(false)) != null && !map.isEmpty() && !im.func_73083_d() && world.func_82736_K().func_82766_b("doTileDrops")) {
            void var12_17;
            int n = map.values().stream().mapToInt(Integer::intValue).sum();
            while (var12_17 > 0) {
                int i = EntityXPOrb.func_70527_a((int)var12_17);
                var12_17 -= i;
                world.func_72838_d((Entity)new EntityXPOrb(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, i));
            }
        }
    }

    private boolean harvestBlock(PlayerInteractionManager im, @Nullable BlockPos pos) {
        if (pos == null) {
            return false;
        }
        if (Cavern.proxy.isSinglePlayer()) {
            World world = im.field_73092_a;
            IBlockState state = world.func_180495_p(pos);
            if (im.func_180237_b(pos)) {
                if (!im.func_73083_d()) {
                    world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                }
                return true;
            }
        } else if (im.func_180237_b(pos)) {
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || player instanceof FakePlayer) {
            return;
        }
        BlockPos pos = event.getPos();
        MiningAssistUnit assist = MiningAssistUnit.get(player);
        if (!assist.getCaptureDrops()) {
            return;
        }
        NonNullList items = NonNullList.func_191196_a();
        List drops = event.getDrops();
        float chance = event.getDropChance();
        for (ItemStack stack : drops) {
            if (!(CaveEventHooks.RANDOM.nextFloat() < chance)) continue;
            items.add((Object)stack);
        }
        drops.clear();
        assist.addDrops(pos, (NonNullList<ItemStack>)items);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (!Keyboard.getEventKeyState()) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71439_g == null) {
            return;
        }
        int key = Keyboard.getEventKey();
        if (CaveKeyBindings.KEY_MINING_ASSIST.isActiveAndMatches(key)) {
            CaveNetworkRegistry.sendToServer(new MiningAssistMessage());
        }
    }
}

