/*
 * Decompiled with CFR 0.152.
 */
package cavern.inventory;

import cavern.capability.CaveCapabilities;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.ObjectUtils;

public class InventoryMagicStorage {
    private IInventory inventory;

    public IInventory getInventory() {
        return this.inventory;
    }

    public void setInventory(IInventory inv) {
        this.inventory = inv;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.inventory == null) {
            return;
        }
        nbt.func_74768_a("Size", this.inventory.func_70302_i_() / 9);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (this.inventory == null) {
            if (!nbt.func_150297_b("Size", 99)) {
                return;
            }
            int size = 9 * nbt.func_74762_e("Size");
            this.inventory = new InventoryBasic("Items", false, size);
        }
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            int j = compound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, new ItemStack(compound));
        }
    }

    public static InventoryMagicStorage get(ItemStack stack) {
        return (InventoryMagicStorage)ObjectUtils.defaultIfNull((Object)CaveCapabilities.getCapability((ICapabilityProvider)stack, CaveCapabilities.MAGIC_STORAGE), (Object)new InventoryMagicStorage());
    }
}

