/*
 * Decompiled with CFR 0.152.
 */
package cavern.item;

import cavern.core.Cavern;
import cavern.handler.CaveEventHooks;
import cavern.inventory.InventoryMagicStorage;
import cavern.item.CaveItems;
import cavern.magic.Magic;
import cavern.magic.MagicBook;
import cavern.magic.MagicExplosion;
import cavern.magic.MagicHeal;
import cavern.magic.MagicInfinity;
import cavern.magic.MagicInvisible;
import cavern.magic.MagicOverload;
import cavern.magic.MagicStorage;
import cavern.magic.MagicSummon;
import cavern.magic.MagicTeleport;
import cavern.magic.MagicThunderbolt;
import cavern.magic.MagicTorch;
import cavern.magic.MagicWarp;
import cavern.util.CaveLog;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;

public class ItemMagicBook
extends Item {
    public ItemMagicBook() {
        this.func_77655_b("magicBook");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(Cavern.TAB_CAVERN);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + EnumType.byItemStack(stack).getTranslationKey();
    }

    public String func_77653_i(ItemStack stack) {
        return Cavern.proxy.translateFormat(this.func_77658_a() + ".name", super.func_77653_i(stack));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (EnumType type : EnumType.VALUES) {
            subItems.add((Object)type.getItemStack());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        switch (EnumType.byItemStack(stack)) {
            case STORAGE: {
                IInventory inventory = InventoryMagicStorage.get(stack).getInventory();
                if (inventory == null) break;
                int count = 0;
                TreeSet names = Sets.newTreeSet();
                for (int i = 0; i < inventory.func_70302_i_() && count < 5; ++i) {
                    ItemStack item = inventory.func_70301_a(i);
                    if (item.func_190926_b() || !names.add(item.func_82833_r())) continue;
                    ++count;
                }
                for (String name : names) {
                    tooltip.add(TextFormatting.ITALIC + name + TextFormatting.RESET);
                }
                break;
            }
            case WARP: {
                Pair<BlockPos, DimensionType> warpPoint = MagicWarp.getWarpPoint(stack);
                if (warpPoint == null) break;
                BlockPos pos = (BlockPos)warpPoint.getLeft();
                DimensionType type = (DimensionType)warpPoint.getRight();
                tooltip.add(String.format("%s: %d, %d, %d", type.func_186065_b(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (ItemMagicBook.getMana(stack) <= 0) {
            return false;
        }
        return mc.field_71439_g.field_71075_bZ.field_75098_d || !ItemMagicBook.isInCoolTime((EntityPlayer)mc.field_71439_g, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (MagicBook.get((EntityPlayer)mc.field_71439_g).getSpellingMagicBook() == stack) {
            return true;
        }
        return ItemMagicBook.getMana(stack) < EnumType.byItemStack(stack).getMana();
    }

    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        MagicBook book = MagicBook.get((EntityPlayer)mc.field_71439_g);
        if (book.getSpellingMagicBook() == stack) {
            double progress = book.getSpellingMagic().getSpellingProgress();
            if (book.getSpecialMagic() != null && book.getSpecialMagic() instanceof MagicInfinity) {
                progress = MathHelper.func_151237_a((double)(progress * 2.5), (double)0.0, (double)1.0);
            }
            return 1.0 - progress;
        }
        return 1.0 - (double)ItemMagicBook.getMana(stack) / (double)EnumType.byItemStack(stack).getMana();
    }

    @SideOnly(value=Side.CLIENT)
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        MagicBook book = MagicBook.get((EntityPlayer)mc.field_71439_g);
        if (book.getSpellingMagicBook() == stack) {
            return book.getSpellingMagic().isOverload() ? 16370105 : 41680;
        }
        return super.getRGBDurabilityForDisplay(stack);
    }

    public static int getMana(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt == null ? 0 : MathHelper.func_76125_a((int)nbt.func_74762_e("Mana"), (int)0, (int)EnumType.byItemStack(stack).getMana());
    }

    public static ItemStack setMana(ItemStack stack, int amount) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74768_a("Mana", MathHelper.func_76125_a((int)amount, (int)0, (int)EnumType.byItemStack(stack).getMana()));
        stack.func_77982_d(nbt);
        return stack;
    }

    public static int consumeMana(ItemStack stack, int amount) {
        return ItemMagicBook.getMana(ItemMagicBook.setMana(stack, ItemMagicBook.getMana(stack) - amount));
    }

    public static long getLastUseTime(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt == null ? 0L : nbt.func_74763_f("LastUseTime");
    }

    public static ItemStack setLastUseTime(ItemStack stack, long time) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74772_a("LastUseTime", time);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static boolean isInCoolTime(EntityPlayer player, ItemStack stack) {
        long lastUseTime;
        MagicBook book = MagicBook.get(player);
        EnumType type = EnumType.byItemStack(stack);
        int coolTime = type.getCoolTime();
        if (book.getSpecialMagic() != null && book.getSpecialMagic() instanceof MagicInfinity) {
            coolTime = Math.min(coolTime, 100);
        }
        return coolTime > 0 && (lastUseTime = ItemMagicBook.getLastUseTime(stack)) > 0L && player.field_70170_p.func_82737_E() - lastUseTime <= (long)coolTime;
    }

    public static ItemStack getRandomBook() {
        int i = MathHelper.func_76128_c((double)(CaveEventHooks.RANDOM.nextDouble() * (double)EnumType.VALUES.length));
        EnumType type = EnumType.VALUES[i];
        int mana = type.getMana();
        if (mana >= 10) {
            mana = MathHelper.func_76136_a((Random)CaveEventHooks.RANDOM, (int)(mana / 2), (int)mana);
        } else if (mana > 1) {
            mana = CaveEventHooks.RANDOM.nextInt(mana) + 1;
        }
        return type.getItemStack(mana);
    }

    public static enum EnumType {
        STORAGE(0, "storage", 50, MagicStorage.class, 100),
        HEAL(1, "heal", 10, MagicHeal.class, 400),
        WARP(2, "warp", 10, MagicWarp.class, 1200),
        TELEPORT(3, "teleport", 50, MagicTeleport.class, 300),
        TORCH(4, "torch", 30, MagicTorch.class, 1200),
        INVISIBLE(5, "invisible", 10, MagicInvisible.class, 400),
        SUMMON(6, "summon", 30, MagicSummon.class, 1200),
        EXPLOSION(7, "explosion", 20, MagicExplosion.class, 600),
        THUNDERBOLT(8, "thunderbolt", 20, MagicThunderbolt.class, 600),
        INFINITY(9, "infinity", 3, MagicInfinity.class, 3600),
        OVERLOAD(10, "overload", 3, MagicOverload.class, 1200);

        private final int meta;
        private final String translationKey;
        private final int mana;
        private final Class<? extends Magic> magicClass;
        private final int coolTime;
        public static final EnumType[] VALUES;

        private EnumType(int meta, String name, int mana, Class<? extends Magic> magic, int coolTime) {
            this.meta = meta;
            this.translationKey = name;
            this.mana = mana;
            this.magicClass = magic;
            this.coolTime = coolTime;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getMana() {
            return this.mana;
        }

        public Class<? extends Magic> getMagicClass() {
            return this.magicClass;
        }

        @Nullable
        public Magic createMagic(World world, EntityPlayer player, EnumHand hand) {
            try {
                return this.getMagicClass().getConstructor(World.class, EntityPlayer.class, EnumHand.class).newInstance(world, player, hand);
            }
            catch (ReflectiveOperationException e) {
                CaveLog.log(Level.ERROR, e, "Failed to create the %s magic.", this.name());
                return null;
            }
        }

        public int getCoolTime() {
            return this.coolTime;
        }

        public ItemStack getItemStack() {
            return this.getItemStack(this.getMana());
        }

        public ItemStack getItemStack(int mana) {
            return ItemMagicBook.setMana(new ItemStack((Item)CaveItems.MAGIC_BOOK, 1, this.getMetadata()), mana);
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= VALUES.length) {
                meta = 0;
            }
            return VALUES[meta];
        }

        public static EnumType byItemStack(ItemStack stack) {
            return EnumType.byMetadata(stack.func_190926_b() ? 0 : stack.func_77960_j());
        }

        static {
            VALUES = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.VALUES[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

