/*
 * Decompiled with CFR 0.152.
 */
package cavern.item;

import cavern.api.CavernAPI;
import cavern.api.IPortalCache;
import cavern.core.Cavern;
import cavern.handler.CaveEventHooks;
import cavern.item.CaveItems;
import cavern.stats.PlayerData;
import cavern.stats.PortalCache;
import cavern.util.CaveUtils;
import cavern.world.CaveDimensions;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.ITeleporter;

public class ItemMirageBook
extends Item
implements ITeleporter {
    public ItemMirageBook() {
        this.func_77655_b("mirageBook");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(Cavern.TAB_CAVERN);
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + EnumType.byItemStack(stack).getTranslationKey();
    }

    public String func_77653_i(ItemStack stack) {
        return Cavern.proxy.translateFormat(this.func_77658_a() + ".name", super.func_77653_i(stack));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (EnumType type : EnumType.VALUES) {
            if (type.getDimension() == null) continue;
            subItems.add((Object)type.getItemStack());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        DimensionType type = EnumType.byItemStack(stack).getDimension();
        if (type == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (world.field_73011_w.func_186058_p() == type) {
            if (!world.field_72995_K) {
                PlayerData.get(player).setLastTeleportTime(type, world.func_82737_E());
                this.transferTo(null, player);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (world.field_72995_K) {
            if (CavernAPI.dimension.isInMirageWorlds((Entity)player)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".fail", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".portal", new Object[0]), true);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean transferTo(@Nullable DimensionType dimNew, EntityPlayer entityPlayer) {
        if (entityPlayer == null || !(entityPlayer instanceof EntityPlayerMP)) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
        ResourceLocation key = CaveUtils.getKey("mirage_worlds");
        IPortalCache cache = PortalCache.get((ICapabilityProvider)player);
        DimensionType dimOld = player.field_70170_p.field_73011_w.func_186058_p();
        if (dimNew == null) {
            dimNew = cache.getLastDim(key, null);
        }
        if (dimNew == null || dimOld == dimNew) {
            return false;
        }
        if (CavernAPI.dimension.isMirageWorlds(dimNew)) {
            cache.setLastDim(key, dimOld);
        }
        cache.setLastPos(key, dimOld, player.func_180425_c());
        player.field_71088_bW = player.func_82147_ab();
        player.changeDimension(dimNew.func_186068_a(), (ITeleporter)this);
        if (player.getBedLocation(dimNew.func_186068_a()) == null) {
            player.setSpawnChunk(player.func_180425_c(), true, dimNew.func_186068_a());
        }
        return true;
    }

    public void placeEntity(World world, Entity entity, float rotationYaw) {
        if (this.attemptToLastPos(world, entity)) {
            return;
        }
        if (this.attemptRandomly(world, entity)) {
            return;
        }
        this.attemptToVoid(world, entity);
    }

    protected boolean attemptToLastPos(World world, Entity entity) {
        DimensionType type;
        ResourceLocation key;
        IPortalCache cache = PortalCache.get((ICapabilityProvider)entity);
        if (cache.hasLastPos(key = CaveUtils.getKey("mirage_worlds"), type = world.field_73011_w.func_186058_p())) {
            BlockPos pos = cache.getLastPos(key, type);
            if (world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a() && world.func_180495_p(pos).func_177230_c().func_181623_g() && world.func_180495_p(pos.func_177984_a()).func_177230_c().func_181623_g()) {
                entity.func_174828_a(pos, entity.field_70177_z, entity.field_70125_A);
                return true;
            }
            cache.setLastPos(key, type, null);
        }
        return false;
    }

    protected boolean attemptRandomly(World world, Entity entity) {
        int count = 0;
        block0: while (++count < 50) {
            int x = MathHelper.func_76128_c((double)entity.field_70165_t) + field_77697_d.nextInt(64) - 32;
            int z = MathHelper.func_76128_c((double)entity.field_70161_v) + field_77697_d.nextInt(64) - 32;
            int y = CavernAPI.dimension.isInCaves(entity) ? field_77697_d.nextInt(30) + 20 : field_77697_d.nextInt(20) + 60;
            BlockPos pos = new BlockPos(x, y, z);
            while (pos.func_177956_o() > 1 && world.func_175623_d(pos)) {
                pos = pos.func_177977_b();
            }
            while (pos.func_177956_o() < world.func_72940_L() - 3 && !world.func_175623_d(pos)) {
                pos = pos.func_177984_a();
            }
            if (!world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a() || !world.func_180495_p(pos).func_177230_c().func_181623_g() || !world.func_180495_p(pos.func_177984_a()).func_177230_c().func_181623_g()) continue;
            for (BlockPos around : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, 0, -4), (BlockPos)pos.func_177982_a(4, 0, 4))) {
                if (!world.func_180495_p(around).func_185904_a().func_76224_d()) continue;
                continue block0;
            }
            entity.func_174828_a(pos, entity.field_70177_z, entity.field_70125_A);
            return true;
        }
        return false;
    }

    protected boolean attemptToVoid(World world, Entity entity) {
        if (!CavernAPI.dimension.isInTheVoid(entity)) {
            return false;
        }
        BlockPos pos = new BlockPos(entity.field_70165_t, 0.0, entity.field_70161_v);
        BlockPos from = pos.func_177982_a(-1, 0, -1);
        BlockPos to = pos.func_177982_a(1, 0, 1);
        BlockPos.func_177975_b((BlockPos)from, (BlockPos)to).forEach(blockPos -> world.func_180501_a((BlockPos)blockPos, Blocks.field_150341_Y.func_176223_P(), 2));
        entity.func_174828_a(pos.func_177984_a(), entity.field_70177_z, entity.field_70125_A);
        return true;
    }

    public static ItemStack getRandomBook() {
        int i = MathHelper.func_76128_c((double)(CaveEventHooks.RANDOM.nextDouble() * (double)EnumType.VALUES.length));
        EnumType type = EnumType.VALUES[i];
        if (type.getDimension() != null) {
            return type.getItemStack();
        }
        return ItemStack.field_190927_a;
    }

    public static enum EnumType {
        CAVELAND(0, "caveland"),
        CAVENIA(1, "cavenia"),
        FROST_MOUNTAINS(2, "frostMountains"),
        WIDE_DESERT(3, "wideDesert"),
        THE_VOID(4, "theVoid"),
        DARK_FOREST(5, "darkForest"),
        CROWN_CLIFFS(6, "crownCliffs");

        public static final EnumType[] VALUES;
        private final int meta;
        private final String translationKey;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.translationKey = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        @Nullable
        public DimensionType getDimension() {
            switch (this) {
                case CAVELAND: {
                    return CaveDimensions.CAVELAND;
                }
                case CAVENIA: {
                    return CaveDimensions.CAVENIA;
                }
                case FROST_MOUNTAINS: {
                    return CaveDimensions.FROST_MOUNTAINS;
                }
                case WIDE_DESERT: {
                    return CaveDimensions.WIDE_DESERT;
                }
                case THE_VOID: {
                    return CaveDimensions.THE_VOID;
                }
                case DARK_FOREST: {
                    return CaveDimensions.DARK_FOREST;
                }
                case CROWN_CLIFFS: {
                    return CaveDimensions.CROWN_CLIFFS;
                }
            }
            return null;
        }

        public ItemStack getItemStack() {
            return new ItemStack((Item)CaveItems.MIRAGE_BOOK, 1, this.getMetadata());
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= VALUES.length) {
                meta = 0;
            }
            return VALUES[meta];
        }

        public static EnumType byItemStack(ItemStack stack) {
            return EnumType.byMetadata(stack.func_190926_b() ? 0 : stack.func_77960_j());
        }

        static {
            VALUES = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.VALUES[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

